/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.gui.quests.GuiQuests;
import com.feed_the_beast.ftbquests.net.MessageCreateObject;
import com.feed_the_beast.ftbquests.net.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.reward.RandomReward;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigFromString;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigString;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiEditConfigFromString;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.misc.GuiButtonListBase;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenuItem;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleTextButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class GuiRewardTables
extends GuiButtonListBase {
    public GuiRewardTables() {
        this.setTitle(I18n.func_135052_a((String)"ftbquests.reward_tables", (Object[])new Object[0]));
        this.setHasSearchBox(true);
        this.setBorder(1, 1, 1);
    }

    public void addButtons(Panel panel) {
        SimpleTextButton button = new SimpleTextButton(panel, I18n.func_135052_a((String)"gui.add", (Object[])new Object[0]), GuiIcons.ADD){

            public void onClicked(MouseButton button) {
                this.playClickSound();
                ConfigString c = new ConfigString();
                GuiEditConfigFromString.open((ConfigFromString)c, (Object)"", (Object)"", accepted -> {
                    if (accepted) {
                        RewardTable table = new RewardTable(ClientQuestFile.INSTANCE);
                        table.title = (String)c.value;
                        new MessageCreateObject(table, null).sendToServer();
                    }
                    this.openGui();
                });
            }
        };
        button.setHeight(14);
        panel.add((Widget)button);
        for (RewardTable table : ClientQuestFile.INSTANCE.rewardTables) {
            panel.add((Widget)new ButtonRewardTable(panel, table));
        }
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private class ButtonRewardTable
    extends SimpleTextButton {
        private final RewardTable table;

        public ButtonRewardTable(Panel panel, RewardTable t) {
            super(panel, t.getTitle(), t.getIcon());
            this.table = t;
            this.setHeight(14);
            if (this.table.lootCrate != null) {
                this.title = TextFormatting.YELLOW + this.title;
            }
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            GuiQuests.addObjectMenuItems(contextMenu, (Runnable)((Object)GuiRewardTables.this), this.table);
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"item.ftbquests.lootcrate.name", (Object[])new Object[0]), GuiIcons.ACCEPT, () -> {
                if (this.table.lootCrate == null) {
                    this.table.lootCrate = new LootCrate(this.table);
                    Matcher matcher = Pattern.compile("[^a-z0-9_]").matcher(this.table.getUnformattedTitle().toLowerCase());
                    Matcher matcher1 = Pattern.compile("_{2,}").matcher(matcher.replaceAll("_"));
                    switch (this.table.lootCrate.stringID = matcher1.replaceAll("_")) {
                        case "common": {
                            this.table.lootCrate.color = Color4I.rgb((int)0x92999A);
                            this.table.lootCrate.drops.passive = 350;
                            this.table.lootCrate.drops.monster = 10;
                            this.table.lootCrate.drops.boss = 0;
                            break;
                        }
                        case "uncommon": {
                            this.table.lootCrate.color = Color4I.rgb((int)3648105);
                            this.table.lootCrate.drops.passive = 200;
                            this.table.lootCrate.drops.monster = 90;
                            this.table.lootCrate.drops.boss = 0;
                            break;
                        }
                        case "rare": {
                            this.table.lootCrate.color = Color4I.rgb((int)38143);
                            this.table.lootCrate.drops.passive = 50;
                            this.table.lootCrate.drops.monster = 200;
                            this.table.lootCrate.drops.boss = 0;
                            break;
                        }
                        case "epic": {
                            this.table.lootCrate.color = Color4I.rgb((int)0x8000FF);
                            this.table.lootCrate.drops.passive = 9;
                            this.table.lootCrate.drops.monster = 10;
                            this.table.lootCrate.drops.boss = 10;
                            break;
                        }
                        case "legendary": {
                            this.table.lootCrate.color = Color4I.rgb((int)16761159);
                            this.table.lootCrate.glow = true;
                            this.table.lootCrate.drops.passive = 1;
                            this.table.lootCrate.drops.monster = 1;
                            this.table.lootCrate.drops.boss = 190;
                        }
                    }
                    this.title = TextFormatting.YELLOW + this.table.getTitle();
                } else {
                    this.table.lootCrate = null;
                    this.title = this.table.getTitle();
                }
                new MessageEditObject(this.table).sendToServer();
            }){

                public void drawIcon(Theme theme, int x, int y, int w, int h) {
                    (((ButtonRewardTable)ButtonRewardTable.this).table.lootCrate != null ? GuiIcons.ACCEPT : GuiIcons.ACCEPT_GRAY).draw(x, y, w, h);
                }
            });
            this.getGui().openContextMenu(contextMenu);
        }

        public void addMouseOverText(List<String> list) {
            super.addMouseOverText(list);
            int usedIn = 0;
            for (Chapter chapter : this.table.file.chapters) {
                for (Quest quest : chapter.quests) {
                    for (Reward reward : quest.rewards) {
                        if (!(reward instanceof RandomReward) || ((RandomReward)reward).table != this.table) continue;
                        ++usedIn;
                    }
                }
            }
            if (usedIn > 0) {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.reward_table.used_in", (Object[])new Object[]{usedIn}));
            }
            this.table.addMouseOverText(list, true, true);
        }
    }
}

