/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigCallback;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.misc.GuiButtonListBase;
import com.feed_the_beast.mods.ftbguilibrary.utils.Key;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleTextButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class GuiSelectQuestObject<T extends QuestObjectBase>
extends GuiButtonListBase {
    private final ConfigQuestObject<T> config;
    private final ConfigCallback callback;

    public GuiSelectQuestObject(ConfigQuestObject<T> c, ConfigCallback cb) {
        this.setTitle(I18n.func_135052_a((String)"ftbquests.gui.select_quest_object", (Object[])new Object[0]));
        this.setHasSearchBox(true);
        this.focus();
        this.setBorder(1, 1, 1);
        this.config = c;
        this.callback = cb;
    }

    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return false;
        }
        return false;
    }

    public void addButtons(Panel panel) {
        ArrayList<QuestObjectBase> list = new ArrayList<QuestObjectBase>();
        for (QuestObjectBase objectBase : ClientQuestFile.INSTANCE.getAllObjects()) {
            if (!this.config.predicate.test(objectBase)) continue;
            list.add(objectBase);
        }
        list.sort((o1, o2) -> {
            int i = Integer.compare(o1.getObjectType().ordinal(), o2.getObjectType().ordinal());
            return i == 0 ? o1.getUnformattedTitle().compareToIgnoreCase(o2.getUnformattedTitle()) : i;
        });
        if (this.config.predicate.test(null)) {
            panel.add((Widget)new ButtonQuestObject(this, panel, null));
        }
        for (QuestObjectBase objectBase : list) {
            panel.add((Widget)new ButtonQuestObject(this, panel, objectBase));
        }
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public static class ButtonQuestObject
    extends SimpleTextButton {
        public final T object;
        final /* synthetic */ GuiSelectQuestObject this$0;

        public ButtonQuestObject(@Nullable Panel panel, T o) {
            this.this$0 = this$0;
            super(panel, o == null ? I18n.func_135052_a((String)"ftbquests.null", (Object[])new Object[0]) : ((QuestObjectBase)o).getObjectType().getColor() + ((QuestObjectBase)o).getUnformattedTitle(), (Icon)(o == null ? Icon.EMPTY : ((QuestObjectBase)o).getIcon()));
            this.object = o;
            this.setSize(200, 14);
        }

        private void addObject(List<String> list, QuestObjectBase o) {
            list.add(TextFormatting.GRAY + QuestObjectType.NAME_MAP.getDisplayName((Object)o.getObjectType()).getString() + ": " + o.getObjectType().getColor() + o.getUnformattedTitle());
        }

        public void addMouseOverText(List<String> list) {
            if (this.object == null) {
                return;
            }
            list.add(((QuestObjectBase)this.object).getTitle());
            list.add(TextFormatting.GRAY + "ID: " + TextFormatting.DARK_GRAY + this.object);
            list.add(TextFormatting.GRAY + "Type: " + ((QuestObjectBase)this.object).getObjectType().getColor() + QuestObjectType.NAME_MAP.getDisplayName((Object)((QuestObjectBase)this.object).getObjectType()).getString());
            if (this.object instanceof Quest) {
                Quest quest = (Quest)this.object;
                this.addObject(list, quest.chapter);
                if (quest.rewards.size() == 1) {
                    this.addObject(list, quest.rewards.get(0));
                } else if (!quest.rewards.isEmpty()) {
                    list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.rewards", (Object[])new Object[0]));
                    for (Reward reward : quest.rewards) {
                        list.add("  " + QuestObjectType.REWARD.getColor() + reward.getUnformattedTitle());
                    }
                }
            } else if (this.object instanceof Task) {
                Quest quest = ((Task)this.object).quest;
                this.addObject(list, quest.chapter);
                this.addObject(list, quest);
                if (quest.rewards.size() == 1) {
                    this.addObject(list, quest.rewards.get(0));
                } else if (!quest.rewards.isEmpty()) {
                    list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.rewards", (Object[])new Object[0]));
                    for (Reward reward : quest.rewards) {
                        list.add("  " + QuestObjectType.REWARD.getColor() + reward.getUnformattedTitle());
                    }
                }
            } else if (this.object instanceof RewardTable) {
                ((RewardTable)this.object).addMouseOverText(list, true, true);
            }
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            this.this$0.config.setCurrentValue(this.object);
            this.this$0.callback.save(true);
        }
    }
}

