/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.quests;

import com.feed_the_beast.ftbquests.net.MessageCreateObject;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenuItem;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;

public class ButtonAddReward
extends Button {
    private final Quest quest;

    public ButtonAddReward(Panel panel, Quest q) {
        super(panel, I18n.func_135052_a((String)"gui.add", (Object[])new Object[0]), (Icon)ThemeProperties.ADD_ICON.get());
        this.quest = q;
        this.setSize(18, 18);
    }

    public void onClicked(MouseButton button) {
        this.playClickSound();
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        for (RewardType type : RewardType.getRegistry()) {
            contextMenu.add(new ContextMenuItem(type.getDisplayName(), type.getIcon(), () -> {
                this.playClickSound();
                type.getGuiProvider().openCreationGui((Runnable)((Object)this), this.quest, reward -> {
                    CompoundNBT extra = new CompoundNBT();
                    extra.func_74778_a("type", type.getTypeForNBT());
                    new MessageCreateObject((QuestObjectBase)reward, extra).sendToServer();
                });
            }));
        }
        this.getGui().openContextMenu(contextMenu);
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(theme, x, y, w, h);
        }
    }
}

