/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.quests;

import com.feed_the_beast.ftbquests.gui.quests.GuiQuests;
import com.feed_the_beast.ftbquests.net.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.ChapterImage;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiEditConfig;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenuItem;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ButtonChapterImage
extends Button {
    public GuiQuests treeGui;
    public ChapterImage chapterImage;

    public ButtonChapterImage(Panel panel, ChapterImage i) {
        super(panel, "", i.image);
        this.treeGui = (GuiQuests)panel.getGui();
        this.setSize(20, 20);
        this.chapterImage = i;
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.treeGui.questPanel.mouseOverQuest != null || this.treeGui.movingObjects || this.treeGui.viewQuestPanel.isMouseOver() || this.treeGui.chapterHoverPanel.isMouseOverAnyWidget()) {
            return false;
        }
        if (this.chapterImage.click.isEmpty() && !this.treeGui.file.canEdit()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public void onClicked(MouseButton button) {
        if (this.treeGui.file.canEdit() && button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.edit", (Object[])new Object[0]), (Icon)ThemeProperties.EDIT_ICON.get(), () -> {
                ConfigGroup group = new ConfigGroup("ftbquests");
                this.chapterImage.getConfig(group.getGroup("chapter").getGroup("image"));
                group.savedCallback = accepted -> {
                    if (accepted) {
                        new MessageEditObject(this.chapterImage.chapter).sendToServer();
                    }
                    this.run();
                };
                new GuiEditConfig(group).openGui();
            }));
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"gui.move", (Object[])new Object[0]), (Icon)ThemeProperties.MOVE_UP_ICON.get(this.chapterImage.chapter), () -> {
                this.treeGui.movingObjects = true;
                this.treeGui.selectedObjects.clear();
                this.treeGui.toggleSelected(this.chapterImage);
            }){

                public void addMouseOverText(List<String> list) {
                    list.add(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"ftbquests.gui.move_tooltip", (Object[])new Object[0]));
                }
            });
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), (Icon)ThemeProperties.DELETE_ICON.get(), () -> {
                this.chapterImage.chapter.images.remove(this.chapterImage);
                new MessageEditObject(this.chapterImage.chapter).sendToServer();
            }).setYesNo((ITextComponent)new TranslationTextComponent("delete_item", new Object[]{this.chapterImage.image.toString()})));
            this.getGui().openContextMenu(contextMenu);
        } else if (button.isLeft()) {
            if (!this.chapterImage.click.isEmpty()) {
                this.playClickSound();
                this.handleClick(this.chapterImage.click);
            }
        } else if (this.treeGui.file.canEdit() && button.isMiddle()) {
            if (!this.treeGui.selectedObjects.contains(this.chapterImage)) {
                this.treeGui.toggleSelected(this.chapterImage);
            }
            this.treeGui.movingObjects = true;
        }
    }

    public void addMouseOverText(List<String> list) {
        for (String s : this.chapterImage.hover) {
            if (s.startsWith("{") && s.endsWith("}")) {
                list.add(I18n.func_135052_a((String)s.substring(1, s.length() - 1), (Object[])new Object[0]));
                continue;
            }
            list.add(s);
        }
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)((int)((double)x + (double)w / 2.0)), (double)((int)((double)y + (double)h / 2.0)), (double)10.0);
        RenderSystem.rotatef((float)((float)this.chapterImage.rotation), (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.scalef((float)((float)w / 2.0f), (float)((float)h / 2.0f), (float)1.0f);
        this.chapterImage.image.draw(-1, -1, 2, 2);
        RenderSystem.popMatrix();
    }
}

