/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.quests;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.GuiRewardTables;
import com.feed_the_beast.ftbquests.gui.quests.ButtonTab;
import com.feed_the_beast.ftbquests.net.MessageChangeProgress;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.theme.ThemeLoader;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenuItem;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;

public class ButtonEditSettings
extends ButtonTab {
    public ButtonEditSettings(Panel panel) {
        super(panel, I18n.func_135052_a((String)"gui.settings", (Object[])new Object[0]), (Icon)ThemeProperties.SETTINGS_ICON.get());
    }

    public void onClicked(MouseButton button) {
        this.playClickSound();
        if (this.treeGui.contextMenu != null) {
            this.treeGui.closeContextMenu();
            return;
        }
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.edit_file", (Object[])new Object[0]), (Icon)ThemeProperties.SETTINGS_ICON.get(), () -> this.treeGui.file.onEditButtonClicked((Runnable)((Object)this))));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.reset_progress", (Object[])new Object[0]), (Icon)ThemeProperties.RELOAD_ICON.get(), () -> new MessageChangeProgress(ClientQuestFile.INSTANCE.self.uuid, this.treeGui.file.id, ChangeProgress.RESET).sendToServer()).setYesNo((ITextComponent)new TranslationTextComponent("ftbquests.gui.reset_progress_q", new Object[0])));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.complete_instantly", (Object[])new Object[0]), (Icon)ThemeProperties.CHECK_ICON.get(), () -> new MessageChangeProgress(ClientQuestFile.INSTANCE.self.uuid, this.treeGui.file.id, ChangeProgress.COMPLETE).sendToServer()).setYesNo((ITextComponent)new TranslationTextComponent("ftbquests.gui.complete_instantly_q", new Object[0])));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.reward_tables", (Object[])new Object[0]), (Icon)ThemeProperties.REWARD_TABLE_ICON.get(), () -> new GuiRewardTables().openGui()));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.save_as_file", (Object[])new Object[0]), (Icon)ThemeProperties.DOWNLOAD_ICON.get(), () -> {
            try {
                Calendar time = Calendar.getInstance();
                StringBuilder fileName = new StringBuilder("local/ftbquests/saved/");
                this.appendNum(fileName, time.get(1), '-');
                this.appendNum(fileName, time.get(2) + 1, '-');
                this.appendNum(fileName, time.get(5), '-');
                this.appendNum(fileName, time.get(11), '-');
                this.appendNum(fileName, time.get(12), '-');
                this.appendNum(fileName, time.get(13), '\u0000');
                File file = new File(Minecraft.func_71410_x().field_71412_D, fileName.toString()).getCanonicalFile();
                ClientQuestFile.INSTANCE.writeDataFull(file.toPath());
                TranslationTextComponent component = new TranslationTextComponent("ftbquests.gui.saved_as_file", new Object[]{file.getPath().replace(Minecraft.func_71410_x().field_71412_D.getCanonicalFile().getAbsolutePath(), "")});
                component.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath()));
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)component);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.reload_theme", (Object[])new Object[0]), (Icon)ThemeProperties.RELOAD_ICON.get(), () -> {
            Minecraft mc = Minecraft.func_71410_x();
            ThemeLoader.loadTheme(mc.func_195551_G());
            ClientQuestFile.INSTANCE.refreshGui();
        }));
        this.treeGui.openContextMenu(contextMenu);
    }

    private void appendNum(StringBuilder sb, int num, char c) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
        if (c != '\u0000') {
            sb.append(c);
        }
    }
}

