/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.quests;

import com.feed_the_beast.ftbquests.client.FTBQuestsClient;
import com.feed_the_beast.ftbquests.gui.quests.GuiQuests;
import com.feed_the_beast.ftbquests.net.MessageMoveChapter;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenuItem;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiHelper;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleTextButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetType;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class ButtonExpandedChapter
extends SimpleTextButton {
    public final GuiQuests treeGui = (GuiQuests)this.getGui();
    public final Chapter chapter;
    public List<String> description;

    public ButtonExpandedChapter(Panel panel, Chapter c) {
        super(panel, c.getTitle(), c.getIcon());
        int p;
        this.chapter = c;
        if (this.treeGui.file.self != null && (p = this.treeGui.file.self.getRelativeProgress(c)) > 0 && p < 100) {
            this.setTitle(this.getTitle() + " " + TextFormatting.DARK_GREEN + p + "%");
        }
        this.description = new ArrayList<String>();
        for (String v : this.chapter.subtitle) {
            this.description.add(TextFormatting.GRAY + FTBQuestsClient.addI18nAndColors(v));
        }
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.treeGui.viewQuestPanel.isMouseOver()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public void onClicked(MouseButton button) {
        if (this.treeGui.file.canEdit() || !this.chapter.quests.isEmpty()) {
            this.playClickSound();
            if (this.treeGui.selectedChapter != this.chapter) {
                this.treeGui.open(this.chapter, false);
            }
        }
        if (this.treeGui.file.canEdit() && button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"gui.move", (Object[])new Object[0]), (Icon)ThemeProperties.MOVE_UP_ICON.get(), () -> new MessageMoveChapter(this.chapter.id, true).sendToServer()).setEnabled(() -> this.chapter.getIndex() > 0).setCloseMenu(false));
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"gui.move", (Object[])new Object[0]), (Icon)ThemeProperties.MOVE_DOWN_ICON.get(), () -> new MessageMoveChapter(this.chapter.id, false).sendToServer()).setEnabled(() -> this.chapter.getIndex() < this.treeGui.file.chapters.size() - 1).setCloseMenu(false));
            contextMenu.add(ContextMenuItem.SEPARATOR);
            GuiQuests.addObjectMenuItems(contextMenu, (Runnable)((Object)this.treeGui), this.chapter);
            this.treeGui.openContextMenu(contextMenu);
        }
    }

    public void addMouseOverText(List<String> list) {
        list.addAll(this.description);
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        theme.drawGui(x, y, w, h, WidgetType.NORMAL);
        if (this.isMouseOver()) {
            ((Color4I)ThemeProperties.WIDGET_BACKGROUND.get()).draw(x, y, w - 1, h);
        }
        if (this.parent.widgets.size() > 1) {
            if (this.parent.widgets.get(0) == this) {
                theme.drawButton(x, y, w, h, WidgetType.NORMAL);
            } else {
                Color4I borderColor = (Color4I)ThemeProperties.WIDGET_BORDER.get(this.treeGui.selectedChapter);
                borderColor.draw(x + w - 1, y, 1, h);
                if (this.parent.widgets.get(this.parent.widgets.size() - 1) == this) {
                    borderColor.draw(x, y + h - 1, w - 1, h);
                }
            }
        } else {
            GuiHelper.drawHollowRect((int)x, (int)y, (int)w, (int)h, (Color4I)((Color4I)ThemeProperties.WIDGET_BORDER.get()), (boolean)false);
        }
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        super.draw(theme, x, y, w, h);
        int w2 = 20;
        if (this.treeGui.file.self.hasUnclaimedRewards(this.chapter)) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)450.0f);
            ((Icon)ThemeProperties.ALERT_ICON.get()).draw(x + w2 - 7, y + 3, 6, 6);
            RenderSystem.popMatrix();
        } else if (this.treeGui.file.self.isComplete(this.chapter)) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)450.0f);
            ((Icon)ThemeProperties.CHECK_ICON.get()).draw(x + w2 - 8, y + 2, 8, 8);
            RenderSystem.popMatrix();
        }
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return this.icon.getIngredient();
    }
}

