/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.quests;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.GuiRewardNotifications;
import com.feed_the_beast.ftbquests.gui.quests.ButtonTab;
import com.feed_the_beast.ftbquests.net.MessageClaimAllRewards;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class ButtonModpack
extends ButtonTab {
    private final boolean unclaimedRewards;

    public ButtonModpack(Panel panel) {
        super(panel, "", ClientQuestFile.INSTANCE.getIcon());
        this.title = this.treeGui.file.getTitle();
        this.unclaimedRewards = this.treeGui.file.self.hasUnclaimedRewards();
    }

    public void onClicked(MouseButton button) {
        this.playClickSound();
        if (ClientQuestFile.exists()) {
            new GuiRewardNotifications().openGui();
            new MessageClaimAllRewards().sendToServer();
        }
    }

    public void addMouseOverText(List<String> list) {
        super.addMouseOverText(list);
        if (this.unclaimedRewards) {
            list.add("");
            list.add(TextFormatting.GOLD + I18n.func_135052_a((String)"ftbquests.gui.collect_rewards", (Object[])new Object[0]));
        }
    }

    @Override
    public void draw(Theme theme, int x, int y, int w, int h) {
        super.draw(theme, x, y, w, h);
        if (this.unclaimedRewards) {
            double s = (double)w / 2.0;
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)((double)(x + w) - s), (double)y, (double)500.0);
            RenderSystem.scaled((double)s, (double)s, (double)1.0);
            ((Icon)ThemeProperties.ALERT_ICON.get(this.treeGui.file)).draw(0, 0, 1, 1);
            RenderSystem.popMatrix();
        }
    }
}

