/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.quests;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.quests.GuiQuests;
import com.feed_the_beast.ftbquests.net.MessageCreateObject;
import com.feed_the_beast.ftbquests.net.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.ChapterImage;
import com.feed_the_beast.ftbquests.quest.Movable;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestShape;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenuItem;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ButtonQuest
extends Button {
    public GuiQuests treeGui;
    public Quest quest;
    public ButtonQuest[] dependencies = null;

    public ButtonQuest(Panel panel, Quest q) {
        super(panel, q.getTitle(), q.getIcon());
        this.treeGui = (GuiQuests)panel.getGui();
        this.setSize(20, 20);
        this.quest = q;
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.treeGui.movingObjects || this.treeGui.viewQuestPanel.isMouseOver() || this.treeGui.chapterHoverPanel.isMouseOverAnyWidget()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public void updateMouseOver(int mouseX, int mouseY) {
        super.updateMouseOver(mouseX, mouseY);
        if (this.treeGui.questPanel.mouseOverQuest == null) {
            if (this.isMouseOver) {
                this.treeGui.questPanel.mouseOverQuest = this;
            }
        } else if (this.treeGui.questPanel.mouseOverQuest != this) {
            this.isMouseOver = false;
        }
    }

    public ButtonQuest[] getDependencies() {
        if (this.dependencies == null) {
            ArrayList<ButtonQuest> list = new ArrayList<ButtonQuest>();
            for (QuestObject dependency : this.quest.dependencies) {
                if (dependency.invalid || !(dependency instanceof Quest)) continue;
                for (Widget widget : this.treeGui.questPanel.widgets) {
                    if (!(widget instanceof ButtonQuest) || dependency != ((ButtonQuest)widget).quest) continue;
                    list.add((ButtonQuest)widget);
                }
            }
            this.dependencies = list.toArray(new ButtonQuest[0]);
        }
        return this.dependencies;
    }

    public void onClicked(MouseButton button) {
        this.playClickSound();
        if (this.treeGui.file.canEdit() && button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            if (!this.treeGui.selectedObjects.isEmpty()) {
                if (!this.treeGui.selectedObjects.contains(this.quest)) {
                    contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.add_dependencies", (Object[])new Object[0]), (Icon)ThemeProperties.ADD_ICON.get(), () -> {
                        for (Movable q : this.treeGui.selectedObjects) {
                            if (!(q instanceof Quest)) continue;
                            this.editDependency(this.quest, (Quest)q, true);
                        }
                    }));
                    contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.remove_dependencies", (Object[])new Object[0]), (Icon)ThemeProperties.DELETE_ICON.get(), () -> {
                        for (Movable q : this.treeGui.selectedObjects) {
                            if (!(q instanceof Quest)) continue;
                            this.editDependency(this.quest, (Quest)q, false);
                        }
                    }));
                    contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.add_dependencies_self", (Object[])new Object[0]), (Icon)ThemeProperties.ADD_ICON.get(), () -> {
                        for (Movable q : this.treeGui.selectedObjects) {
                            if (!(q instanceof Quest)) continue;
                            this.editDependency((Quest)q, this.quest, true);
                        }
                    }));
                    contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.remove_dependencies_self", (Object[])new Object[0]), (Icon)ThemeProperties.DELETE_ICON.get(), () -> {
                        for (Movable q : this.treeGui.selectedObjects) {
                            if (!(q instanceof Quest)) continue;
                            this.editDependency((Quest)q, this.quest, false);
                        }
                    }));
                } else {
                    contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.add_reward_all", (Object[])new Object[0]), (Icon)ThemeProperties.ADD_ICON.get(this.quest), () -> {
                        ArrayList<ContextMenuItem> contextMenu2 = new ArrayList<ContextMenuItem>();
                        for (RewardType type : RewardType.getRegistry()) {
                            contextMenu2.add(new ContextMenuItem(type.getDisplayName(), type.getIcon(), () -> {
                                this.playClickSound();
                                type.getGuiProvider().openCreationGui((Runnable)((Object)this), this.quest, reward -> {
                                    for (Movable movable : this.treeGui.selectedObjects) {
                                        if (!(movable instanceof Quest)) continue;
                                        Reward r = type.provider.create((Quest)movable);
                                        CompoundNBT nbt1 = new CompoundNBT();
                                        reward.writeData(nbt1);
                                        r.readData(nbt1);
                                        CompoundNBT extra = new CompoundNBT();
                                        extra.func_74778_a("type", type.getTypeForNBT());
                                        new MessageCreateObject(r, extra).sendToServer();
                                    }
                                });
                            }));
                        }
                        this.getGui().openContextMenu(contextMenu2);
                    }));
                    contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), (Icon)ThemeProperties.DELETE_ICON.get(this.quest), () -> {
                        this.treeGui.selectedObjects.forEach(q -> {
                            if (q instanceof Quest) {
                                ClientQuestFile.INSTANCE.deleteObject(((Quest)q).id);
                            } else if (q instanceof ChapterImage) {
                                ((ChapterImage)q).chapter.images.remove(q);
                                new MessageEditObject(((ChapterImage)q).chapter).sendToServer();
                            }
                        });
                        this.treeGui.selectedObjects.clear();
                    }).setYesNo((ITextComponent)new TranslationTextComponent("delete_item", new Object[]{I18n.func_135052_a((String)"ftbquests.quests", (Object[])new Object[0]) + " [" + this.treeGui.selectedObjects.size() + "]"})));
                }
                contextMenu.add(ContextMenuItem.SEPARATOR);
                contextMenu.add(new ContextMenuItem(TextFormatting.GRAY + "Ctrl+A to select all quests", GuiIcons.INFO, null));
                contextMenu.add(new ContextMenuItem(TextFormatting.GRAY + "Ctrl+D to deselect all quests", GuiIcons.INFO, null));
                contextMenu.add(new ContextMenuItem(TextFormatting.GRAY + "Ctrl+Arrow Key to move selected quests", GuiIcons.INFO, null));
            } else {
                contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"gui.move", (Object[])new Object[0]), (Icon)ThemeProperties.MOVE_UP_ICON.get(this.quest), () -> {
                    this.treeGui.movingObjects = true;
                    this.treeGui.selectedObjects.clear();
                    this.treeGui.toggleSelected(this.quest);
                }){

                    public void addMouseOverText(List<String> list) {
                        list.add(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"ftbquests.gui.move_tooltip", (Object[])new Object[0]));
                    }
                });
                contextMenu.add(ContextMenuItem.SEPARATOR);
                GuiQuests.addObjectMenuItems(contextMenu, (Runnable)this.getGui(), this.quest);
            }
            this.getGui().openContextMenu(contextMenu);
        } else if (button.isLeft()) {
            if (ButtonQuest.isCtrlKeyDown() && this.treeGui.file.canEdit()) {
                if (this.treeGui.getViewedQuest() != null) {
                    this.treeGui.closeQuest();
                }
                this.treeGui.toggleSelected(this.quest);
            } else if (!this.quest.guidePage.isEmpty() && this.quest.tasks.isEmpty() && this.quest.rewards.isEmpty() && this.quest.getDescription().length == 0) {
                this.handleClick("guide", this.quest.guidePage);
            } else if (this.quest.customClick.isEmpty() || !this.handleClick(this.quest.customClick)) {
                this.treeGui.open(this.quest, false);
            }
        } else if (this.treeGui.file.canEdit() && button.isMiddle()) {
            if (!this.treeGui.selectedObjects.contains(this.quest)) {
                this.treeGui.toggleSelected(this.quest);
            }
            this.treeGui.movingObjects = true;
        } else if (button.isRight()) {
            this.treeGui.movingObjects = false;
            if (this.treeGui.getViewedQuest() != this.quest) {
                this.treeGui.viewQuestPanel.hidePanel = true;
                this.treeGui.viewQuest(this.quest);
            } else {
                this.treeGui.closeQuest();
            }
        }
    }

    private void editDependency(Quest quest, QuestObject object, boolean add) {
        ArrayList<QuestObject> prevDeps = new ArrayList<QuestObject>(quest.dependencies);
        if (add != quest.hasDependency(object)) {
            if (add) {
                quest.dependencies.add(object);
            } else {
                quest.dependencies.remove(object);
            }
        }
        if (quest.verifyDependencies(false)) {
            new MessageEditObject(quest).sendToServer();
            this.treeGui.questPanel.refreshWidgets();
        } else {
            quest.dependencies.clear();
            quest.dependencies.addAll(prevDeps);
            GuiQuests.displayError((ITextComponent)new TranslationTextComponent("ftbquests.gui.looping_dependencies", new Object[0]));
        }
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return this.quest.tasks.size() == 1 ? this.quest.tasks.get(0).getIngredient() : null;
    }

    public void addMouseOverText(List<String> list) {
        int p;
        String title = this.getTitle();
        if (this.treeGui.file.self != null && (p = this.treeGui.file.self.getRelativeProgress(this.quest)) > 0 && p < 100) {
            title = title + " " + TextFormatting.DARK_GRAY + p + "%";
        }
        list.add(title);
        String description = this.quest.getSubtitle();
        if (!description.isEmpty()) {
            list.add(TextFormatting.GRAY + description);
        }
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        double s;
        boolean cantStart;
        Color4I outlineColor = Color4I.WHITE.withAlpha(150);
        Color4I qicon = Icon.EMPTY;
        boolean bl = cantStart = !this.treeGui.file.self.canStartTasks(this.quest);
        if (!cantStart) {
            int progress = this.treeGui.file.self.getRelativeProgress(this.quest);
            if (progress >= 100) {
                qicon = this.treeGui.file.self.hasUnclaimedRewards(this.quest) ? (Icon)ThemeProperties.ALERT_ICON.get(this.quest) : (Icon)ThemeProperties.CHECK_ICON.get(this.quest);
                outlineColor = (Color4I)ThemeProperties.QUEST_COMPLETED_COLOR.get(this.quest);
            } else if (progress > 0) {
                outlineColor = (Color4I)ThemeProperties.QUEST_STARTED_COLOR.get(this.quest);
            }
        } else {
            outlineColor = Color4I.GRAY;
        }
        QuestShape shape = this.quest.getShape();
        shape.shape.withColor(Color4I.DARK_GRAY).draw(x, y, w, h);
        shape.background.withColor(Color4I.WHITE.withAlpha(150)).draw(x, y, w, h);
        shape.outline.withColor(outlineColor).draw(x, y, w, h);
        if (!this.icon.isEmpty()) {
            s = (double)w * 2.0 / 3.0;
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)((double)x + ((double)w - s) / 2.0), (double)((double)y + ((double)h - s) / 2.0), (double)0.0);
            RenderSystem.scaled((double)s, (double)s, (double)1.0);
            this.icon.draw(0, 0, 1, 1);
            RenderSystem.popMatrix();
        }
        RenderSystem.enableAlphaTest();
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.quest == this.treeGui.viewQuestPanel.quest || this.treeGui.selectedObjects.contains(this.quest)) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)500.0f);
            Color4I col = Color4I.WHITE.withAlpha((int)(190.0 + Math.sin((double)System.currentTimeMillis() * 0.003) * 50.0));
            shape.outline.withColor(col).draw(x, y, w, h);
            shape.background.withColor(col).draw(x, y, w, h);
            RenderSystem.popMatrix();
        }
        if (cantStart) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)500.0f);
            shape.shape.withColor(Color4I.BLACK.withAlpha(100)).draw(x, y, w, h);
            RenderSystem.popMatrix();
        }
        if (this.isMouseOver()) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)500.0f);
            shape.shape.withColor(Color4I.WHITE.withAlpha(100)).draw(x, y, w, h);
            RenderSystem.popMatrix();
        }
        if (!qicon.isEmpty()) {
            s = (double)w / 2.0;
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)((double)(x + w) - s), (double)y, (double)500.0);
            RenderSystem.scaled((double)s, (double)s, (double)1.0);
            qicon.draw(0, 0, 1, 1);
            RenderSystem.popMatrix();
        }
    }
}

