/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.quests;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.quests.GuiQuests;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenuItem;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetType;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class ButtonReward
extends Button {
    public final GuiQuests treeGui;
    public final Reward reward;

    public ButtonReward(Panel panel, Reward r) {
        super(panel, r.getTitle(), r.getIcon());
        this.treeGui = (GuiQuests)panel.getGui();
        this.reward = r;
        this.setSize(18, 18);
    }

    public String getTitle() {
        if (this.reward.isTeamReward()) {
            return TextFormatting.BLUE + super.getTitle();
        }
        return super.getTitle();
    }

    public void addMouseOverText(List<String> list) {
        if (ButtonReward.isShiftKeyDown() && ButtonReward.isCtrlKeyDown()) {
            list.add(TextFormatting.DARK_GRAY + this.reward.toString());
        }
        if (this.reward.addTitleInMouseOverText()) {
            list.add(this.getTitle());
        }
        if (this.reward.isTeamReward()) {
            list.add(TextFormatting.BLUE + "[" + I18n.func_135052_a((String)"ftbquests.reward.team_reward", (Object[])new Object[0]) + "]");
        }
        this.reward.addMouseOverText(list);
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (button.isRight() || this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public WidgetType getWidgetType() {
        if (!ClientQuestFile.exists() || !ClientQuestFile.INSTANCE.self.isComplete(this.reward.quest)) {
            return WidgetType.DISABLED;
        }
        return super.getWidgetType();
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            if (ClientQuestFile.exists()) {
                this.reward.onButtonClicked(this, ClientQuestFile.INSTANCE.self.getClaimType(this.reward).canClaim());
            }
        } else if (button.isRight() && ClientQuestFile.exists() && ClientQuestFile.INSTANCE.canEdit()) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            GuiQuests.addObjectMenuItems(contextMenu, (Runnable)this.getGui(), this.reward);
            this.getGui().openContextMenu(contextMenu);
        }
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return this.reward.getIngredient();
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(theme, x, y, w, h);
        }
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        String s;
        int bs = h >= 32 ? 32 : 16;
        this.drawBackground(theme, x, y, w, h);
        this.drawIcon(theme, x + (w - bs) / 2, y + (h - bs) / 2, bs, bs);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)500.0f);
        RenderSystem.enableBlend();
        boolean completed = false;
        if (!ClientQuestFile.exists()) {
            GuiIcons.CLOSE.draw(x + w - 9, y + 1, 8, 8);
        } else if (ClientQuestFile.INSTANCE.self.getClaimType(this.reward).isClaimed()) {
            ((Icon)ThemeProperties.CHECK_ICON.get()).draw(x + w - 9, y + 1, 8, 8);
            completed = true;
        } else if (ClientQuestFile.INSTANCE.self.isComplete(this.reward.quest)) {
            ((Icon)ThemeProperties.ALERT_ICON.get()).draw(x + w - 9, y + 1, 8, 8);
        }
        RenderSystem.popMatrix();
        if (!completed && !(s = this.reward.getButtonText()).isEmpty()) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)((float)x + 19.0f - (float)theme.getStringWidth(s) / 2.0f), (float)((float)y + 15.0f), (float)500.0f);
            RenderSystem.scalef((float)0.5f, (float)0.5f, (float)1.0f);
            theme.drawString(s, 0.0f, 0.0f, Color4I.WHITE, 2);
            RenderSystem.popMatrix();
        }
    }
}

