/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.gamestages;

import com.feed_the_beast.ftbquests.integration.gamestages.GameStagesIntegration;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GameStageReward
extends Reward {
    public String stage = "";
    public boolean remove = false;

    public GameStageReward(Quest quest) {
        super(quest);
    }

    @Override
    public RewardType getType() {
        return GameStagesIntegration.GAMESTAGE_REWARD;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("stage", this.stage);
        if (this.remove) {
            nbt.func_74757_a("remove", true);
        }
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.stage = nbt.func_74779_i("stage");
        this.remove = nbt.func_74767_n("remove");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_180714_a(this.stage);
        buffer.writeBoolean(this.remove);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.stage = buffer.func_218666_n();
        this.remove = buffer.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("stage", this.stage, v -> {
            this.stage = v;
        }, "").setNameKey("ftbquests.reward.ftbquests.gamestage");
        config.addBool("remove", this.remove, v -> {
            this.remove = v;
        }, false);
    }

    @Override
    public void claim(ServerPlayerEntity player, boolean notify) {
        if (this.remove) {
            GameStageHelper.removeStage((PlayerEntity)player, (String)this.stage);
        } else {
            GameStageHelper.addStage((PlayerEntity)player, (String)this.stage);
        }
        GameStageHelper.syncPlayer((ServerPlayerEntity)player);
        if (notify) {
            if (this.remove) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("commands.gamestage.remove.target", new Object[]{this.stage}));
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("commands.gamestage.add.target", new Object[]{this.stage}));
            }
        }
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.reward.ftbquests.gamestage", (Object[])new Object[0]) + ": " + TextFormatting.YELLOW + this.stage;
    }
}

