/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.gamestages;

import com.feed_the_beast.ftbquests.integration.gamestages.GameStageReward;
import com.feed_the_beast.ftbquests.integration.gamestages.GameStageTask;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import net.darkhax.gamestages.event.GameStageEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GameStagesIntegration {
    public static TaskType GAMESTAGE_TASK;
    public static RewardType GAMESTAGE_REWARD;

    public void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(TaskType.class, this::registerTasks);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(RewardType.class, this::registerRewards);
        MinecraftForge.EVENT_BUS.register(GameStagesIntegration.class);
    }

    private void registerTasks(RegistryEvent.Register<TaskType> event) {
        GAMESTAGE_TASK = ((TaskType)new TaskType(GameStageTask::new).setRegistryName("gamestage")).setIcon(GuiIcons.CONTROLLER);
        event.getRegistry().register((IForgeRegistryEntry)GAMESTAGE_TASK);
    }

    private void registerRewards(RegistryEvent.Register<RewardType> event) {
        GAMESTAGE_REWARD = ((RewardType)new RewardType(GameStageReward::new).setRegistryName("gamestage")).setIcon(GuiIcons.CONTROLLER);
        event.getRegistry().register((IForgeRegistryEntry)GAMESTAGE_REWARD);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            GameStagesIntegration.checkStages((ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onGameStageAdded(GameStageEvent.Added event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            GameStagesIntegration.checkStages((ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onGameStageRemoved(GameStageEvent.Removed event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            GameStagesIntegration.checkStages((ServerPlayerEntity)event.getPlayer());
        }
    }

    public static void checkStages(ServerPlayerEntity player) {
        PlayerData data;
        PlayerData playerData = data = ServerQuestFile.INSTANCE == null ? null : ServerQuestFile.INSTANCE.getData((Entity)player);
        if (data != null) {
            for (Chapter chapter : ServerQuestFile.INSTANCE.chapters) {
                for (Quest quest : chapter.quests) {
                    if (!data.canStartTasks(quest)) continue;
                    for (Task task : quest.tasks) {
                        if (!(task instanceof GameStageTask)) continue;
                        data.getTaskData(task).submitTask(player);
                    }
                }
            }
        }
    }
}

