/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.kubejs;

import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.task.Task;
import dev.latvian.kubejs.player.PlayerDataJS;
import net.minecraft.world.IWorld;

public class FTBQuestsKubeJSPlayerData {
    private final PlayerDataJS playerData;

    public FTBQuestsKubeJSPlayerData(PlayerDataJS p) {
        this.playerData = p;
    }

    public QuestFile getFile() {
        return FTBQuests.PROXY.getQuestFile((IWorld)this.playerData.getOverworld().minecraftWorld);
    }

    public PlayerData getData() {
        return this.getFile().getData(this.playerData.getId());
    }

    public void addProgress(Object id, long progress) {
        PlayerData data = this.getData();
        Task task = data.file.getTask(data.file.getID(id));
        if (task != null) {
            data.getTaskData(task).addProgress(progress);
        }
    }

    public void complete(Object id) {
        PlayerData data = this.getData();
        QuestObject object = data.file.get(data.file.getID(id));
        if (object != null) {
            object.forceProgress(data, ChangeProgress.COMPLETE, false);
        }
    }

    public void reset(Object id) {
        PlayerData data = this.getData();
        QuestObject object = data.file.get(data.file.getID(id));
        if (object != null) {
            object.forceProgress(data, ChangeProgress.RESET, false);
        }
    }

    public boolean isCompleted(Object id) {
        PlayerData data = this.getData();
        QuestObject object = data.file.get(data.file.getID(id));
        return object != null && data.isComplete(object);
    }

    public boolean isStarted(Object id) {
        PlayerData data = this.getData();
        QuestObject object = data.file.get(data.file.getID(id));
        return object != null && data.isStarted(object);
    }

    public boolean canStartQuest(Object id) {
        PlayerData data = this.getData();
        Quest quest = data.file.getQuest(data.file.getID(id));
        return quest != null && data.canStartTasks(quest);
    }

    public int getProgress(Object id) {
        PlayerData data = this.getData();
        QuestObject object = data.file.get(data.file.getID(id));
        return object != null ? data.getRelativeProgress(object) : 0;
    }
}

