/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.item;

import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.GuiRewardNotifications;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import com.feed_the_beast.mods.ftbguilibrary.config.Tristate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemLootCrate
extends Item {
    public ItemLootCrate() {
        super(new Item.Properties().func_200916_a(FTBQuests.ITEM_GROUP));
    }

    @Nullable
    public static LootCrate getCrate(@Nullable IWorld world, ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77973_b() instanceof ItemLootCrate) {
            QuestFile file = world == null ? FTBQuests.PROXY.getQuestFile(Tristate.DEFAULT) : FTBQuests.PROXY.getQuestFile(world);
            return file == null ? null : file.getLootCrate(stack.func_77978_p().func_74779_i("type"));
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        int size;
        ItemStack stack = player.func_184586_b(hand);
        LootCrate crate = ItemLootCrate.getCrate((IWorld)world, stack);
        if (crate == null) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        int n = size = player.func_213453_ef() ? stack.func_190916_E() : 1;
        if (!world.field_72995_K) {
            int totalWeight = crate.table.getTotalWeight(true);
            if (totalWeight > 0) {
                block0: for (int j = 0; j < size * crate.table.lootSize; ++j) {
                    int currentWeight = crate.table.emptyWeight;
                    int number = player.field_70170_p.field_73012_v.nextInt(totalWeight) + 1;
                    if (currentWeight >= number) continue;
                    for (WeightedReward reward : crate.table.rewards) {
                        if ((currentWeight += reward.weight) < number) continue;
                        reward.reward.claim((ServerPlayerEntity)player, true);
                        continue block0;
                    }
                }
            }
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 0.8f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
        } else {
            new GuiRewardNotifications().openGui();
            for (int i = 0; i < 5; ++i) {
                Vec3d vec3d = new Vec3d(((double)world.field_73012_v.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                vec3d = vec3d.func_178789_a(-player.field_70125_A * ((float)Math.PI / 180));
                vec3d = vec3d.func_178785_b(-player.field_70177_z * ((float)Math.PI / 180));
                double d0 = (double)(-world.field_73012_v.nextFloat()) * 0.6 - 0.3;
                Vec3d vec3d1 = new Vec3d(((double)world.field_73012_v.nextFloat() - 0.5) * 0.3, d0, 0.6);
                vec3d1 = vec3d1.func_178789_a(-player.field_70125_A * ((float)Math.PI / 180));
                vec3d1 = vec3d1.func_178785_b(-player.field_70177_z * ((float)Math.PI / 180));
                vec3d1 = vec3d1.func_72441_c(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_());
                world.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
            }
        }
        stack.func_190918_g(size);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        LootCrate crate = ItemLootCrate.getCrate(null, stack);
        return crate != null && crate.glow;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        LootCrate crate = ItemLootCrate.getCrate(null, stack);
        return crate != null && !crate.itemName.isEmpty() ? new StringTextComponent(crate.itemName) : super.func_200295_i(stack);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.UNCOMMON;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        QuestFile file;
        if (this.func_194125_a(tab) && (file = FTBQuests.PROXY.getQuestFile(Tristate.DEFAULT)) != null) {
            for (RewardTable table : file.rewardTables) {
                if (table.lootCrate == null) continue;
                items.add((Object)table.lootCrate.createStack());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(new TranslationTextComponent("item.ftbquests.lootcrate.tooltip_1", new Object[0]).func_211708_a(TextFormatting.GRAY));
        tooltip.add(new TranslationTextComponent("item.ftbquests.lootcrate.tooltip_2", new Object[0]).func_211708_a(TextFormatting.GRAY));
        if (world == null || !ClientQuestFile.exists()) {
            return;
        }
        LootCrate crate = ItemLootCrate.getCrate((IWorld)world, stack);
        if (crate != null) {
            if (crate.itemName.isEmpty()) {
                tooltip.add((ITextComponent)new StringTextComponent(""));
                tooltip.add(new StringTextComponent(crate.table.getTitle()).func_211708_a(TextFormatting.GRAY));
            }
        } else if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("type")) {
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add(new StringTextComponent(stack.func_77978_p().func_74779_i("type")).func_211708_a(TextFormatting.GRAY));
        }
    }
}

