/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.net;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.net.MessageBase;
import com.feed_the_beast.ftbquests.net.MessageEditObjectResponse;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.util.NetUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageEditObject
extends MessageBase {
    private final int id;
    private final CompoundNBT nbt;

    MessageEditObject(PacketBuffer buffer) {
        this.id = buffer.func_150792_a();
        this.nbt = buffer.func_150793_b();
    }

    public MessageEditObject(QuestObjectBase o) {
        this.id = o.id;
        this.nbt = new CompoundNBT();
        o.writeData(this.nbt);
        FTBQuestsJEIHelper.refresh(o);
        ClientQuestFile.INSTANCE.clearCachedData();
        o.editedFromGUI();
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.id);
        buffer.func_150786_a(this.nbt);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        QuestObjectBase object;
        if (NetUtils.canEdit(context) && (object = ServerQuestFile.INSTANCE.getBase(this.id)) != null) {
            object.readData(this.nbt);
            ServerQuestFile.INSTANCE.clearCachedData();
            ServerQuestFile.INSTANCE.save();
            new MessageEditObjectResponse(object).sendToAll();
        }
    }
}

