/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.events.ClearFileCacheEvent;
import com.feed_the_beast.ftbquests.events.CustomTaskEvent;
import com.feed_the_beast.ftbquests.events.ObjectCompletedEvent;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.net.MessageDisplayCompletionToast;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.QuestShape;
import com.feed_the_beast.ftbquests.quest.loot.EntityWeight;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardAutoClaim;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.feed_the_beast.ftbquests.quest.task.CustomTask;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.ftbquests.util.CompoundSNBT;
import com.feed_the_beast.ftbquests.util.NBTUtils;
import com.feed_the_beast.ftbquests.util.NetUtils;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigItemStack;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigValue;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class QuestFile
extends QuestObject {
    public static final int VERSION = 8;
    private int lastID;
    public final List<Chapter> chapters;
    public final List<RewardTable> rewardTables;
    protected final Map<UUID, PlayerData> playerDataMap;
    private final Int2ObjectOpenHashMap<QuestObjectBase> map;
    public final List<ItemStack> emergencyItems;
    public int emergencyItemsCooldown;
    public int fileVersion;
    public boolean defaultRewardTeam;
    public boolean defaultTeamConsumeItems;
    public RewardAutoClaim defaultRewardAutoClaim;
    public QuestShape defaultQuestShape;
    public boolean defaultQuestDisableJEI;
    public boolean dropLootCrates;
    public final EntityWeight lootCrateNoDrop;
    public boolean disableGui;

    public QuestFile() {
        this.id = 1;
        this.fileVersion = 0;
        this.lastID = 0;
        this.chapters = new ArrayList<Chapter>();
        this.rewardTables = new ArrayList<RewardTable>();
        this.playerDataMap = new HashMap<UUID, PlayerData>();
        this.map = new Int2ObjectOpenHashMap();
        this.emergencyItems = new ArrayList<ItemStack>();
        this.emergencyItems.add(new ItemStack((IItemProvider)Items.field_151034_e));
        this.emergencyItemsCooldown = 300;
        this.defaultRewardTeam = false;
        this.defaultTeamConsumeItems = false;
        this.defaultRewardAutoClaim = RewardAutoClaim.DISABLED;
        this.defaultQuestShape = QuestShape.CIRCLE;
        this.defaultQuestDisableJEI = false;
        this.dropLootCrates = false;
        this.lootCrateNoDrop = new EntityWeight();
        this.lootCrateNoDrop.passive = 4000;
        this.lootCrateNoDrop.monster = 600;
        this.lootCrateNoDrop.boss = 0;
        this.disableGui = false;
    }

    public abstract LogicalSide getSide();

    @Override
    public QuestFile getQuestFile() {
        return this;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.FILE;
    }

    public boolean isLoading() {
        return false;
    }

    public boolean canEdit() {
        return false;
    }

    public Path getFolder() {
        throw new IllegalStateException("This quest file doesn't have a folder!");
    }

    public void load(UUID s) {
        throw new IllegalStateException("This method can only be called from client quest file!");
    }

    @Override
    public int getRelativeProgressFromChildren(PlayerData data) {
        int progress = 0;
        for (Chapter chapter : this.chapters) {
            progress += data.getRelativeProgress(chapter);
        }
        return QuestFile.getRelativeProgressFromChildren(progress, this.chapters.size());
    }

    @Override
    public void onCompleted(PlayerData data, List<ServerPlayerEntity> onlineMembers, List<ServerPlayerEntity> notifiedPlayers) {
        super.onCompleted(data, onlineMembers, notifiedPlayers);
        MinecraftForge.EVENT_BUS.post((Event)new ObjectCompletedEvent.FileEvent(data, this, onlineMembers, notifiedPlayers));
        if (!this.disableToast) {
            for (ServerPlayerEntity player : notifiedPlayers) {
                new MessageDisplayCompletionToast(this.id).sendTo(player);
            }
        }
    }

    @Override
    public void changeProgress(PlayerData data, ChangeProgress type) {
        for (Chapter chapter : this.chapters) {
            chapter.changeProgress(data, type);
        }
    }

    @Override
    public void deleteSelf() {
        this.invalid = true;
    }

    @Override
    public void deleteChildren() {
        for (Chapter chapter : this.chapters) {
            chapter.deleteChildren();
            chapter.invalid = true;
        }
        this.chapters.clear();
        for (RewardTable table : this.rewardTables) {
            table.deleteChildren();
            table.invalid = true;
        }
        this.rewardTables.clear();
    }

    @Nullable
    public QuestObjectBase getBase(int id) {
        if (id == 0) {
            return null;
        }
        if (id == 1) {
            return this;
        }
        QuestObjectBase object = (QuestObjectBase)this.map.get(id);
        return object == null || object.invalid ? null : object;
    }

    @Nullable
    public QuestObject get(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof QuestObject ? (QuestObject)object : null;
    }

    @Nullable
    public QuestObjectBase remove(int id) {
        QuestObjectBase object = (QuestObjectBase)this.map.remove(id);
        if (object != null) {
            if (object instanceof QuestObject) {
                QuestObject o = (QuestObject)object;
                for (Chapter chapter : this.chapters) {
                    for (Quest quest : chapter.quests) {
                        quest.dependencies.remove(o);
                    }
                }
            }
            object.invalid = true;
            this.refreshIDMap();
            return object;
        }
        return null;
    }

    @Nullable
    public Chapter getChapter(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof Chapter ? (Chapter)object : null;
    }

    @Nullable
    public Quest getQuest(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof Quest ? (Quest)object : null;
    }

    @Nullable
    public Task getTask(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof Task ? (Task)object : null;
    }

    @Nullable
    public Reward getReward(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof Reward ? (Reward)object : null;
    }

    @Nullable
    public RewardTable getRewardTable(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof RewardTable ? (RewardTable)object : null;
    }

    @Nullable
    public LootCrate getLootCrate(String id) {
        RewardTable table;
        if (!id.startsWith("#")) {
            for (RewardTable table2 : this.rewardTables) {
                if (table2.lootCrate == null || !table2.lootCrate.stringID.equals(id)) continue;
                return table2.lootCrate;
            }
        }
        return (table = this.getRewardTable(this.getID(id))) == null ? null : table.lootCrate;
    }

    @Nullable
    public RewardTable getRewardTable(String id) {
        LootCrate crate = this.getLootCrate(id);
        return crate != null ? crate.table : this.getRewardTable(this.getID(id));
    }

    public void refreshIDMap() {
        this.clearCachedData();
        this.map.clear();
        for (RewardTable table : this.rewardTables) {
            this.map.put(table.id, (Object)table);
        }
        for (Chapter chapter : this.chapters) {
            this.map.put(chapter.id, (Object)chapter);
            for (Quest quest : chapter.quests) {
                this.map.put(quest.id, (Object)quest);
                for (Task task : quest.tasks) {
                    this.map.put(task.id, (Object)task);
                }
                for (Reward reward : quest.rewards) {
                    this.map.put(reward.id, (Object)reward);
                }
            }
        }
        this.clearCachedData();
    }

    public QuestObjectBase create(QuestObjectType type, int parent, CompoundNBT extra) {
        switch (type) {
            case CHAPTER: {
                return new Chapter(this);
            }
            case QUEST: {
                Chapter chapter = this.getChapter(parent);
                if (chapter != null) {
                    return new Quest(chapter);
                }
                throw new IllegalArgumentException("Parent chapter not found!");
            }
            case TASK: {
                Quest quest = this.getQuest(parent);
                if (quest != null) {
                    Task task = TaskType.createTask(quest, extra.func_74779_i("type"));
                    if (task != null) {
                        return task;
                    }
                    throw new IllegalArgumentException("Unknown task type!");
                }
                throw new IllegalArgumentException("Parent quest not found!");
            }
            case REWARD: {
                Quest quest = this.getQuest(parent);
                if (quest != null) {
                    Reward reward = RewardType.createReward(quest, extra.func_74779_i("type"));
                    if (reward != null) {
                        return reward;
                    }
                    throw new IllegalArgumentException("Unknown reward type!");
                }
                throw new IllegalArgumentException("Parent quest not found!");
            }
            case REWARD_TABLE: {
                return new RewardTable(this);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    @Override
    public final void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74757_a("default_reward_team", this.defaultRewardTeam);
        nbt.func_74757_a("default_consume_items", this.defaultTeamConsumeItems);
        nbt.func_74778_a("default_autoclaim_rewards", this.defaultRewardAutoClaim.id);
        nbt.func_74778_a("default_quest_shape", this.defaultQuestShape.id);
        nbt.func_74757_a("default_quest_disable_jei", this.defaultQuestDisableJEI);
        ListNBT emergencyItemList = new ListNBT();
        for (ItemStack stack : this.emergencyItems) {
            CompoundSNBT nbt1 = new CompoundSNBT();
            NBTUtils.write(nbt1, "item", stack);
            emergencyItemList.add((Object)nbt1);
        }
        nbt.func_218657_a("emergency_items", (INBT)emergencyItemList);
        nbt.func_74768_a("emergency_items_cooldown", this.emergencyItemsCooldown);
        nbt.func_74757_a("drop_loot_crates", this.dropLootCrates);
        CompoundSNBT nbt1 = new CompoundSNBT();
        this.lootCrateNoDrop.writeData(nbt1);
        nbt.func_218657_a("loot_crate_no_drop", (INBT)nbt1);
        nbt.func_74757_a("disable_gui", this.disableGui);
    }

    @Override
    public final void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.defaultRewardTeam = nbt.func_74767_n("default_reward_team");
        this.defaultTeamConsumeItems = nbt.func_74767_n("default_consume_items");
        this.defaultRewardAutoClaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP_NO_DEFAULT.get(nbt.func_74779_i("default_autoclaim_rewards")));
        this.defaultQuestShape = (QuestShape)((Object)QuestShape.NAME_MAP.get(nbt.func_74779_i("default_quest_shape")));
        this.defaultQuestDisableJEI = nbt.func_74767_n("default_quest_disable_jei");
        this.emergencyItems.clear();
        ListNBT list = nbt.func_150295_c("emergency_items", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT nbt1 = list.func_150305_b(i);
            ItemStack stack = NBTUtils.read(nbt1, "item");
            if (stack.func_190926_b()) continue;
            this.emergencyItems.add(stack);
        }
        this.emergencyItemsCooldown = nbt.func_74762_e("emergency_items_cooldown");
        this.dropLootCrates = nbt.func_74767_n("drop_loot_crates");
        if (nbt.func_74764_b("loot_crate_no_drop")) {
            this.lootCrateNoDrop.readData(nbt.func_74775_l("loot_crate_no_drop"));
        }
        this.disableGui = nbt.func_74767_n("disable_gui");
    }

    public final void writeDataFull(Path folder) {
        CompoundSNBT fileNBT = new CompoundSNBT();
        fileNBT.func_74768_a("version", 8);
        fileNBT.func_74768_a("last_id", this.lastID);
        this.writeData(fileNBT);
        NBTUtils.writeSNBT(folder, "data", fileNBT);
        for (Chapter chapter : this.chapters) {
            CompoundSNBT chapterNBT = new CompoundSNBT();
            chapterNBT.func_74768_a("id", chapter.id);
            chapter.writeData(chapterNBT);
            ListNBT questList = new ListNBT();
            for (Quest quest : chapter.quests) {
                CompoundSNBT nbt3;
                ForgeRegistryEntry type;
                if (quest.invalid) continue;
                CompoundSNBT questNBT = new CompoundSNBT();
                quest.writeData(questNBT);
                questNBT.func_74768_a("id", quest.id);
                if (!quest.tasks.isEmpty()) {
                    ListNBT t = new ListNBT();
                    for (Task task : quest.tasks) {
                        type = task.getType();
                        nbt3 = new CompoundSNBT();
                        nbt3.func_74768_a("id", task.id);
                        nbt3.func_74778_a("type", type.getTypeForNBT());
                        task.writeData(nbt3);
                        t.add((Object)nbt3);
                    }
                    if (!t.isEmpty()) {
                        questNBT.func_218657_a("tasks", (INBT)t);
                    }
                }
                if (!quest.rewards.isEmpty()) {
                    ListNBT r = new ListNBT();
                    for (Reward reward : quest.rewards) {
                        type = reward.getType();
                        nbt3 = new CompoundSNBT();
                        nbt3.func_74768_a("id", reward.id);
                        nbt3.func_74778_a("type", type.getTypeForNBT());
                        reward.writeData(nbt3);
                        r.add((Object)nbt3);
                    }
                    if (!r.isEmpty()) {
                        questNBT.func_218657_a("rewards", (INBT)r);
                    }
                }
                questList.add((Object)questNBT);
            }
            chapterNBT.func_218657_a("quests", (INBT)questList);
            NBTUtils.writeSNBT(folder, "chapters/" + chapter.filename, chapterNBT);
        }
        for (RewardTable table : this.rewardTables) {
            CompoundSNBT tableNBT = new CompoundSNBT();
            tableNBT.func_74768_a("id", table.id);
            table.writeData(tableNBT);
            NBTUtils.writeSNBT(folder, "reward_tables/" + QuestFile.getCodeString(table), tableNBT);
        }
    }

    public final void readDataFull(Path folder) {
        this.clearCachedData();
        this.map.clear();
        this.chapters.clear();
        this.rewardTables.clear();
        Int2ObjectOpenHashMap dataCache = new Int2ObjectOpenHashMap();
        CompoundNBT fileNBT = NBTUtils.readSNBT(folder, "data");
        if (fileNBT != null) {
            this.fileVersion = fileNBT.func_74762_e("version");
            this.lastID = fileNBT.func_74762_e("last_id");
            this.map.put(1, (Object)this);
            dataCache.put(1, (Object)fileNBT);
        }
        try {
            Files.list(folder.resolve("chapters")).forEach(path -> {
                CompoundNBT chapterNBT = NBTUtils.readSNBT(path);
                if (chapterNBT != null) {
                    Chapter chapter = new Chapter(this);
                    chapter.orderIndex = this.chapters.size() + 1;
                    chapter.id = this.readID(chapterNBT.func_74762_e("id"));
                    this.map.put(chapter.id, (Object)chapter);
                    dataCache.put(chapter.id, (Object)chapterNBT);
                    this.chapters.add(chapter);
                    ListNBT questList = chapterNBT.func_150295_c("quests", 10);
                    for (int i = 0; i < questList.size(); ++i) {
                        CompoundNBT questNBT = questList.func_150305_b(i);
                        Quest quest = new Quest(chapter);
                        quest.id = this.readID(questNBT.func_74762_e("id"));
                        this.map.put(quest.id, (Object)quest);
                        dataCache.put(quest.id, (Object)questNBT);
                        chapter.quests.add(quest);
                        ListNBT taskList = questNBT.func_150295_c("tasks", 10);
                        for (int j = 0; j < taskList.size(); ++j) {
                            CompoundNBT taskNBT = taskList.func_150305_b(j);
                            Task task = TaskType.createTask(quest, taskNBT.func_74779_i("type"));
                            if (task == null) continue;
                            task.id = this.readID(taskNBT.func_74762_e("id"));
                            this.map.put(task.id, (Object)task);
                            dataCache.put(task.id, (Object)taskNBT);
                            quest.tasks.add(task);
                        }
                        ListNBT rewardList = questNBT.func_150295_c("rewards", 10);
                        for (int j = 0; j < rewardList.size(); ++j) {
                            CompoundNBT rewardNBT = rewardList.func_150305_b(j);
                            Reward reward = RewardType.createReward(quest, rewardNBT.func_74779_i("type"));
                            if (reward == null) continue;
                            reward.id = this.readID(rewardNBT.func_74762_e("id"));
                            this.map.put(reward.id, (Object)reward);
                            dataCache.put(reward.id, (Object)rewardNBT);
                            quest.rewards.add(reward);
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Files.list(folder.resolve("reward_tables")).forEach(path -> {
                CompoundNBT tableNBT = NBTUtils.readSNBT(path);
                if (tableNBT != null) {
                    RewardTable table = new RewardTable(this);
                    table.id = this.readID(tableNBT.func_74762_e("id"));
                    this.map.put(table.id, (Object)table);
                    dataCache.put(table.id, (Object)tableNBT);
                    this.rewardTables.add(table);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (QuestObjectBase object : this.map.values()) {
            CompoundNBT data = (CompoundNBT)dataCache.get(object.id);
            if (data == null) continue;
            object.readData(data);
        }
        this.chapters.sort(Comparator.comparingInt(o -> o.orderIndex));
        this.updateChapterIndices();
        for (Chapter chapter : this.chapters) {
            for (Quest quest : chapter.quests) {
                quest.verifyDependencies(true);
            }
        }
        for (QuestObjectBase object : this.getAllObjects()) {
            if (!(object instanceof CustomTask)) continue;
            MinecraftForge.EVENT_BUS.post((Event)new CustomTaskEvent((CustomTask)object));
        }
    }

    public void save() {
    }

    public boolean updateChapterIndices() {
        boolean changed = false;
        for (int i = 0; i < this.chapters.size(); ++i) {
            Chapter c = this.chapters.get(i);
            if (c.orderIndex == i + 1) continue;
            c.orderIndex = i + 1;
            changed = true;
        }
        return changed;
    }

    @Override
    public final void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        NetUtils.write(buffer, this.emergencyItems, PacketBuffer::func_150788_a);
        buffer.func_150787_b(this.emergencyItemsCooldown);
        buffer.writeBoolean(this.defaultRewardTeam);
        buffer.writeBoolean(this.defaultTeamConsumeItems);
        RewardAutoClaim.NAME_MAP_NO_DEFAULT.write(buffer, (Object)this.defaultRewardAutoClaim);
        QuestShape.NAME_MAP.write(buffer, (Object)this.defaultQuestShape);
        buffer.writeBoolean(this.defaultQuestDisableJEI);
        buffer.writeBoolean(this.dropLootCrates);
        this.lootCrateNoDrop.writeNetData(buffer);
        buffer.writeBoolean(this.disableGui);
    }

    @Override
    public final void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        NetUtils.read(buffer, this.emergencyItems, PacketBuffer::func_150791_c);
        this.emergencyItemsCooldown = buffer.func_150792_a();
        this.defaultRewardTeam = buffer.readBoolean();
        this.defaultTeamConsumeItems = buffer.readBoolean();
        this.defaultRewardAutoClaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP_NO_DEFAULT.read(buffer));
        this.defaultQuestShape = (QuestShape)((Object)QuestShape.NAME_MAP.read(buffer));
        this.defaultQuestDisableJEI = buffer.readBoolean();
        this.dropLootCrates = buffer.readBoolean();
        this.lootCrateNoDrop.readNetData(buffer);
        this.disableGui = buffer.readBoolean();
    }

    public final void writeNetDataFull(PacketBuffer buffer, UUID self) {
        int pos = buffer.writerIndex();
        this.writeNetData(buffer);
        buffer.func_150787_b(this.rewardTables.size());
        for (RewardTable table : this.rewardTables) {
            buffer.func_150787_b(table.id);
        }
        buffer.func_150787_b(this.chapters.size());
        ForgeRegistry<TaskType> taskTypes = TaskType.getRegistry();
        ForgeRegistry<RewardType> rewardTypes = RewardType.getRegistry();
        for (Chapter chapter : this.chapters) {
            buffer.func_150787_b(chapter.id);
            buffer.func_150787_b(chapter.quests.size());
            for (Quest quest : chapter.quests) {
                buffer.func_150787_b(quest.id);
                buffer.func_150787_b(quest.tasks.size());
                for (Task task : quest.tasks) {
                    buffer.func_150787_b(taskTypes.getID((IForgeRegistryEntry)task.getType()));
                    buffer.func_150787_b(task.id);
                }
                buffer.func_150787_b(quest.rewards.size());
                for (Reward reward : quest.rewards) {
                    buffer.func_150787_b(rewardTypes.getID((IForgeRegistryEntry)reward.getType()));
                    buffer.func_150787_b(reward.id);
                }
            }
        }
        for (RewardTable table : this.rewardTables) {
            table.writeNetData(buffer);
        }
        for (Chapter chapter : this.chapters) {
            chapter.writeNetData(buffer);
            for (Quest quest : chapter.quests) {
                quest.writeNetData(buffer);
                for (Task task : quest.tasks) {
                    task.writeNetData(buffer);
                }
                for (Reward reward : quest.rewards) {
                    reward.writeNetData(buffer);
                }
            }
        }
        PlayerData selfPlayerData = this.getData(self);
        buffer.func_150787_b(this.playerDataMap.size());
        for (PlayerData data : this.playerDataMap.values()) {
            NetUtils.writeUUID(buffer, data.uuid);
            data.write(buffer, data == selfPlayerData);
        }
        FTBQuests.LOGGER.debug("Wrote " + (buffer.writerIndex() - pos) + " bytes");
    }

    public final void readNetDataFull(PacketBuffer buffer, UUID self) {
        int pos = buffer.readerIndex();
        this.readNetData(buffer);
        this.chapters.clear();
        this.rewardTables.clear();
        int rtl = buffer.func_150792_a();
        for (int i = 0; i < rtl; ++i) {
            RewardTable table = new RewardTable(this);
            table.id = buffer.func_150792_a();
            this.rewardTables.add(table);
        }
        ForgeRegistry<TaskType> taskTypes = TaskType.getRegistry();
        ForgeRegistry<RewardType> rewardTypes = RewardType.getRegistry();
        int c = buffer.func_150792_a();
        for (int i = 0; i < c; ++i) {
            Chapter chapter = new Chapter(this);
            chapter.id = buffer.func_150792_a();
            this.chapters.add(chapter);
            int q = buffer.func_150792_a();
            for (int j = 0; j < q; ++j) {
                Quest quest = new Quest(chapter);
                quest.id = buffer.func_150792_a();
                chapter.quests.add(quest);
                int t = buffer.func_150792_a();
                for (int k = 0; k < t; ++k) {
                    TaskType type = (TaskType)taskTypes.getValue(buffer.func_150792_a());
                    Task task = type.provider.create(quest);
                    task.id = buffer.func_150792_a();
                    quest.tasks.add(task);
                }
                int r = buffer.func_150792_a();
                for (int k = 0; k < r; ++k) {
                    RewardType type = (RewardType)rewardTypes.getValue(buffer.func_150792_a());
                    Reward reward = type.provider.create(quest);
                    reward.id = buffer.func_150792_a();
                    quest.rewards.add(reward);
                }
            }
        }
        this.refreshIDMap();
        for (RewardTable table : this.rewardTables) {
            table.readNetData(buffer);
        }
        for (Chapter chapter : this.chapters) {
            chapter.readNetData(buffer);
            for (Quest quest : chapter.quests) {
                quest.readNetData(buffer);
                for (Task task : quest.tasks) {
                    task.readNetData(buffer);
                }
                for (Reward reward : quest.rewards) {
                    reward.readNetData(buffer);
                }
            }
        }
        for (QuestObjectBase object : this.getAllObjects()) {
            if (!(object instanceof CustomTask)) continue;
            MinecraftForge.EVENT_BUS.post((Event)new CustomTaskEvent((CustomTask)object));
        }
        int pds = buffer.func_150792_a();
        for (int i = 0; i < pds; ++i) {
            PlayerData data = new PlayerData(this, NetUtils.readUUID(buffer));
            this.addData(data);
            data.read(buffer, data.uuid.equals(self));
        }
        FTBQuests.LOGGER.debug("Read " + (buffer.readerIndex() - pos) + " bytes");
    }

    @Override
    public int getParentID() {
        return 0;
    }

    public PlayerData getData(UUID id) {
        return this.playerDataMap.computeIfAbsent(id, i -> new PlayerData(this, (UUID)i));
    }

    public PlayerData getData(Entity player) {
        return this.getData(player.func_110124_au());
    }

    public Collection<PlayerData> getAllData() {
        return this.playerDataMap.values();
    }

    public abstract void deleteObject(int var1);

    @Override
    public Icon getAltIcon() {
        return (Icon)ThemeProperties.MODPACK_ICON.get(this);
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.file", (Object[])new Object[0]);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addList("emergency_items", this.emergencyItems, (ConfigValue)new ConfigItemStack(false, false), (Object)ItemStack.field_190927_a);
        config.addInt("emergency_items_cooldown", this.emergencyItemsCooldown, v -> {
            this.emergencyItemsCooldown = v;
        }, 300, 0, Integer.MAX_VALUE);
        config.addBool("drop_loot_crates", this.dropLootCrates, v -> {
            this.dropLootCrates = v;
        }, false);
        config.addBool("disable_gui", this.disableGui, v -> {
            this.disableGui = v;
        }, false);
        ConfigGroup defaultsGroup = config.getGroup("defaults");
        defaultsGroup.addBool("reward_team", this.defaultRewardTeam, v -> {
            this.defaultRewardTeam = v;
        }, false);
        defaultsGroup.addBool("consume_items", this.defaultTeamConsumeItems, v -> {
            this.defaultTeamConsumeItems = v;
        }, false);
        defaultsGroup.addEnum("autoclaim_rewards", (Object)this.defaultRewardAutoClaim, v -> {
            this.defaultRewardAutoClaim = v;
        }, RewardAutoClaim.NAME_MAP_NO_DEFAULT);
        defaultsGroup.addEnum("quest_shape", (Object)this.defaultQuestShape, v -> {
            this.defaultQuestShape = v;
        }, QuestShape.NAME_MAP.withDefault((Object)QuestShape.CIRCLE));
        defaultsGroup.addBool("quest_disable_jei", this.defaultQuestDisableJEI, v -> {
            this.defaultQuestDisableJEI = v;
        }, false);
        ConfigGroup d = config.getGroup("loot_crate_no_drop");
        d.addInt("passive", this.lootCrateNoDrop.passive, v -> {
            this.lootCrateNoDrop.passive = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.loot.entitytype.passive");
        d.addInt("monster", this.lootCrateNoDrop.monster, v -> {
            this.lootCrateNoDrop.monster = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.loot.entitytype.monster");
        d.addInt("boss", this.lootCrateNoDrop.boss, v -> {
            this.lootCrateNoDrop.boss = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.loot.entitytype.boss");
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (Chapter chapter : this.chapters) {
            chapter.clearCachedData();
        }
        this.clearCachedProgress();
        MinecraftForge.EVENT_BUS.post((Event)new ClearFileCacheEvent(this));
    }

    public void clearCachedProgress() {
        for (PlayerData data : this.getAllData()) {
            data.clearCache();
        }
    }

    public int newID() {
        return this.readID(0);
    }

    public int readID(int id) {
        while (id == 0 || id == 1 || this.map.get(id) != null) {
            id = ++this.lastID;
        }
        return id;
    }

    public int getID(@Nullable Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        String id = o.toString();
        if (id.isEmpty()) {
            return 0;
        }
        if (id.charAt(0) == '*') {
            return 1;
        }
        try {
            return Long.valueOf(id.charAt(0) == '#' ? id.substring(1) : id).intValue();
        }
        catch (Exception ex) {
            for (QuestObjectBase b : this.map.values()) {
                if (!b.hasTag(id)) continue;
                return b.id;
            }
            return 0;
        }
    }

    @Nullable
    public LootCrate getRandomLootCrate(Entity entity, Random random) {
        int totalWeight = this.lootCrateNoDrop.getWeight(entity);
        for (RewardTable table : this.rewardTables) {
            if (table.lootCrate == null) continue;
            totalWeight += table.lootCrate.drops.getWeight(entity);
        }
        if (totalWeight <= 0) {
            return null;
        }
        int number = random.nextInt(totalWeight) + 1;
        int currentWeight = this.lootCrateNoDrop.getWeight(entity);
        if (currentWeight < number) {
            for (RewardTable table : this.rewardTables) {
                if (table.lootCrate == null || (currentWeight += table.lootCrate.drops.getWeight(entity)) < number) continue;
                return table.lootCrate;
            }
        }
        return null;
    }

    @Override
    public final int refreshJEI() {
        return FTBQuestsJEIHelper.QUESTS | FTBQuestsJEIHelper.LOOTCRATES;
    }

    public final Collection<QuestObjectBase> getAllObjects() {
        return this.map.values();
    }

    @Override
    public boolean isVisible(PlayerData data) {
        for (Chapter chapter : this.chapters) {
            if (!chapter.isVisible(data)) continue;
            return true;
        }
        return false;
    }

    public List<Chapter> getVisibleChapters(PlayerData data, boolean excludeEmpty) {
        ArrayList<Chapter> list = new ArrayList<Chapter>();
        for (Chapter chapter : this.chapters) {
            if (excludeEmpty && chapter.quests.isEmpty() || !chapter.isVisible(data)) continue;
            list.add(chapter);
        }
        return list;
    }

    public <T extends QuestObjectBase> List<T> collect(Class<T> clazz, Predicate<QuestObjectBase> filter) {
        ArrayList<QuestObjectBase> list = new ArrayList<QuestObjectBase>();
        for (QuestObjectBase base : this.getAllObjects()) {
            if (!filter.test(base)) continue;
            list.add(base);
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        return list;
    }

    public <T extends QuestObjectBase> List<T> collect(Class<T> clazz) {
        return this.collect(clazz, o -> clazz.isAssignableFrom(o.getClass()));
    }

    public QuestShape getDefaultQuestShape() {
        return this.defaultQuestShape == QuestShape.DEFAULT ? QuestShape.CIRCLE : this.defaultQuestShape;
    }

    public void addData(PlayerData data) {
        this.playerDataMap.put(data.uuid, data);
        for (Chapter chapter : this.chapters) {
            for (Quest quest : chapter.quests) {
                for (Task task : quest.tasks) {
                    data.createTaskData(task);
                }
            }
        }
    }
}

