/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.mods.ftbguilibrary.config.NameMap;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.icon.ImageIcon;
import java.util.Arrays;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class QuestShape
extends Icon {
    public static final QuestShape DEFAULT = new QuestShape("default").circularCheck();
    public static final QuestShape CIRCLE = new QuestShape("circle").circularCheck();
    public static final QuestShape SQUARE = new QuestShape("square");
    public static final QuestShape DIAMOND = new QuestShape("diamond").circularCheck();
    public static final QuestShape RSQUARE = new QuestShape("rsquare");
    public static final QuestShape PENTAGON = new QuestShape("pentagon").circularCheck();
    public static final QuestShape HEXAGON = new QuestShape("hexagon").circularCheck();
    public static final QuestShape OCTAGON = new QuestShape("octagon").circularCheck();
    public static final QuestShape HEART = new QuestShape("heart");
    public static final QuestShape GEAR = new QuestShape("gear").circularCheck();
    public static final NameMap<QuestShape> NAME_MAP = NameMap.of((Object)((Object)DEFAULT), Arrays.asList(DEFAULT, CIRCLE, SQUARE, DIAMOND, RSQUARE, PENTAGON, HEXAGON, OCTAGON, HEART, GEAR)).id(v -> v.id).baseNameKey("ftbquests.quest.shape").create();
    public final String id;
    public final ImageIcon background;
    public final ImageIcon outline;
    public final ImageIcon shape;
    public boolean circularCheck;

    public QuestShape(String i) {
        this.id = i;
        this.background = new ImageIcon(new ResourceLocation("ftbquests", "textures/shapes/" + this.id + "/background.png"));
        this.outline = new ImageIcon(new ResourceLocation("ftbquests", "textures/shapes/" + this.id + "/outline.png"));
        this.shape = new ImageIcon(new ResourceLocation("ftbquests", "textures/shapes/" + this.id + "/shape.png"));
        this.circularCheck = false;
    }

    public QuestShape circularCheck() {
        this.circularCheck = true;
        return this;
    }

    public String toString() {
        return "quest_shape:" + this.id;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(int x, int y, int w, int h) {
        this.background.draw(x, y, w, h);
        this.outline.draw(x, y, w, h);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        return o == this;
    }
}

