/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.loot;

import com.feed_the_beast.ftbquests.gui.GuiEditRewardTable;
import com.feed_the_beast.ftbquests.gui.GuiRewardTables;
import com.feed_the_beast.ftbquests.gui.quests.GuiQuests;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.net.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.icon.IconAnimation;
import com.feed_the_beast.mods.ftbguilibrary.icon.ItemIcon;
import com.feed_the_beast.mods.ftbguilibrary.utils.Bits;
import com.feed_the_beast.mods.ftbguilibrary.utils.ClientUtils;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class RewardTable
extends QuestObjectBase {
    public final QuestFile file;
    public final List<WeightedReward> rewards;
    public final Quest fakeQuest;
    public int emptyWeight;
    public int lootSize;
    public boolean hideTooltip;
    public boolean useTitle;
    public LootCrate lootCrate;

    public RewardTable(QuestFile f) {
        this.file = f;
        this.rewards = new ArrayList<WeightedReward>();
        this.fakeQuest = new Quest(new Chapter(this.file));
        this.emptyWeight = 0;
        this.lootSize = 1;
        this.hideTooltip = false;
        this.useTitle = false;
        this.lootCrate = null;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.REWARD_TABLE;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.file;
    }

    public int getTotalWeight(boolean includeEmpty) {
        int w = includeEmpty ? this.emptyWeight : 0;
        for (WeightedReward r : this.rewards) {
            w += r.weight;
        }
        return w;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        if (this.emptyWeight > 0) {
            nbt.func_74768_a("empty_weight", this.emptyWeight);
        }
        nbt.func_74768_a("loot_size", this.lootSize);
        if (this.hideTooltip) {
            nbt.func_74757_a("hide_tooltip", true);
        }
        if (this.useTitle) {
            nbt.func_74757_a("use_title", true);
        }
        ListNBT list = new ListNBT();
        for (WeightedReward reward : this.rewards) {
            CompoundNBT nbt1 = new CompoundNBT();
            reward.reward.writeData(nbt1);
            if (reward.reward.getType() != FTBQuestsRewards.ITEM) {
                nbt1.func_74778_a("type", reward.reward.getType().getTypeForNBT());
            }
            if (reward.weight > 1) {
                nbt1.func_74768_a("weight", reward.weight);
            }
            list.add((Object)nbt1);
        }
        nbt.func_218657_a("rewards", (INBT)list);
        if (this.lootCrate != null) {
            CompoundNBT nbt1 = new CompoundNBT();
            this.lootCrate.writeData(nbt1);
            nbt.func_218657_a("loot_crate", (INBT)nbt1);
        }
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.emptyWeight = nbt.func_74762_e("empty_weight");
        this.lootSize = nbt.func_74762_e("loot_size");
        this.hideTooltip = nbt.func_74767_n("hide_tooltip");
        this.useTitle = nbt.func_74767_n("use_title");
        this.rewards.clear();
        ListNBT list = nbt.func_150295_c("rewards", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT nbt1 = list.func_150305_b(i);
            Reward reward = RewardType.createReward(this.fakeQuest, nbt1.func_74779_i("type"));
            if (reward == null) continue;
            reward.readData(nbt1);
            this.rewards.add(new WeightedReward(reward, nbt1.func_74762_e("weight")));
        }
        this.lootCrate = null;
        if (nbt.func_74764_b("loot_crate")) {
            this.lootCrate = new LootCrate(this);
            this.lootCrate.readData(nbt.func_74775_l("loot_crate"));
        }
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_150787_b(this.emptyWeight);
        buffer.func_150787_b(this.lootSize);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (boolean)this.hideTooltip);
        flags = Bits.setFlag((int)flags, (int)2, (boolean)this.useTitle);
        flags = Bits.setFlag((int)flags, (int)4, (this.lootCrate != null ? 1 : 0) != 0);
        buffer.func_150787_b(flags);
        buffer.func_150787_b(this.rewards.size());
        for (WeightedReward reward : this.rewards) {
            buffer.func_150787_b(RewardType.getRegistry().getID((IForgeRegistryEntry)reward.reward.getType()));
            reward.reward.writeNetData(buffer);
            buffer.func_150787_b(reward.weight);
        }
        if (this.lootCrate != null) {
            this.lootCrate.writeNetData(buffer);
        }
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.emptyWeight = buffer.func_150792_a();
        this.lootSize = buffer.func_150792_a();
        int flags = buffer.func_150792_a();
        this.hideTooltip = Bits.getFlag((int)flags, (int)1);
        this.useTitle = Bits.getFlag((int)flags, (int)2);
        boolean hasCrate = Bits.getFlag((int)flags, (int)4);
        this.rewards.clear();
        int s = buffer.func_150792_a();
        for (int i = 0; i < s; ++i) {
            RewardType type = (RewardType)RewardType.getRegistry().getValue(buffer.func_150792_a());
            Reward reward = type.provider.create(this.fakeQuest);
            reward.readNetData(buffer);
            int w = buffer.func_150792_a();
            this.rewards.add(new WeightedReward(reward, w));
        }
        this.lootCrate = null;
        if (hasCrate) {
            this.lootCrate = new LootCrate(this);
            this.lootCrate.readNetData(buffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("empty_weight", this.emptyWeight, v -> {
            this.emptyWeight = v;
        }, 0, 0, Integer.MAX_VALUE);
        config.addInt("loot_size", this.lootSize, v -> {
            this.lootSize = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addBool("hide_tooltip", this.hideTooltip, v -> {
            this.hideTooltip = v;
        }, false);
        config.addBool("use_title", this.useTitle, v -> {
            this.useTitle = v;
        }, false);
        if (this.lootCrate != null) {
            this.lootCrate.getConfig(config.getGroup("loot_crate").setNameKey("item.ftbquests.lootcrate.name"));
        }
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (WeightedReward reward : this.rewards) {
            reward.reward.clearCachedData();
        }
    }

    @Override
    public void deleteSelf() {
        this.file.rewardTables.remove(this);
        super.deleteSelf();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void editedFromGUI() {
        GuiQuests gui = (GuiQuests)((Object)ClientUtils.getCurrentGuiAs(GuiQuests.class));
        if (gui != null && gui.getViewedQuest() != null) {
            gui.viewQuestPanel.refreshWidgets();
        } else {
            GuiRewardTables gui1 = (GuiRewardTables)((Object)ClientUtils.getCurrentGuiAs(GuiRewardTables.class));
            if (gui1 != null) {
                gui1.refreshWidgets();
            }
        }
    }

    @Override
    public void onCreated() {
        this.file.rewardTables.add(this);
    }

    @Override
    public String getPath() {
        return "reward_tables/" + RewardTable.getCodeString(this) + ".snbt";
    }

    @Override
    public Icon getAltIcon() {
        if (this.lootCrate != null) {
            return ItemIcon.getItemIcon((ItemStack)this.lootCrate.createStack());
        }
        if (this.rewards.isEmpty()) {
            return GuiIcons.DICE;
        }
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (WeightedReward reward : this.rewards) {
            icons.add(reward.reward.getIcon());
        }
        return IconAnimation.fromList(icons, (boolean)false);
    }

    @Override
    public String getAltTitle() {
        if (this.rewards.size() == 1) {
            return this.rewards.get((int)0).reward.getTitle();
        }
        return I18n.func_135052_a((String)"ftbquests.reward_table", (Object[])new Object[0]);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onEditButtonClicked(Runnable gui) {
        new GuiEditRewardTable(this, () -> new MessageEditObject(this).sendToServer()).openGui();
    }

    public void addMouseOverText(List<String> list, boolean includeWeight, boolean includeEmpty) {
        List<WeightedReward> rewards1;
        if (this.hideTooltip) {
            return;
        }
        int totalWeight = this.getTotalWeight(includeEmpty);
        if (includeWeight && includeEmpty && this.emptyWeight > 0) {
            list.add(TextFormatting.GRAY + "- " + I18n.func_135052_a((String)"ftbquests.reward_table.nothing", (Object[])new Object[0]) + TextFormatting.DARK_GRAY + " [" + WeightedReward.chanceString(this.emptyWeight, totalWeight) + "]");
        }
        if (this.rewards.size() > 1) {
            rewards1 = new ArrayList<WeightedReward>(this.rewards);
            rewards1.sort(null);
        } else {
            rewards1 = this.rewards;
        }
        for (int i = 0; i < rewards1.size(); ++i) {
            if (i == 10) {
                list.add(TextFormatting.GRAY + "- " + I18n.func_135052_a((String)"ftbquests.reward_table.and_more", (Object[])new Object[]{rewards1.size() - 10}));
                return;
            }
            WeightedReward r = rewards1.get(i);
            if (includeWeight) {
                list.add(TextFormatting.GRAY + "- " + r.reward.getTitle() + TextFormatting.DARK_GRAY + " [" + WeightedReward.chanceString(r.weight, totalWeight) + "]");
                continue;
            }
            list.add(TextFormatting.GRAY + "- " + r.reward.getTitle());
        }
    }

    @Override
    public int refreshJEI() {
        return FTBQuestsJEIHelper.LOOTCRATES;
    }
}

