/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftbquests.net.MessageDisplayItemRewardToast;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.feed_the_beast.ftbquests.util.NBTUtils;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.icon.ItemIcon;
import com.feed_the_beast.mods.ftbguilibrary.widget.WrappedIngredient;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemReward
extends Reward {
    public ItemStack item;
    public int randomBonus;
    public boolean onlyOne;

    public ItemReward(Quest quest, ItemStack is) {
        super(quest);
        this.item = is;
        this.randomBonus = 0;
        this.onlyOne = false;
    }

    public ItemReward(Quest quest) {
        this(quest, new ItemStack((IItemProvider)Items.field_151034_e));
    }

    @Override
    public RewardType getType() {
        return FTBQuestsRewards.ITEM;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        NBTUtils.write(nbt, "item", this.item);
        if (this.randomBonus > 0) {
            nbt.func_74768_a("random_bonus", this.randomBonus);
        }
        if (this.onlyOne) {
            nbt.func_74757_a("only_one", true);
        }
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.item = NBTUtils.read(nbt, "item");
        this.randomBonus = nbt.func_74762_e("random_bonus");
        this.onlyOne = nbt.func_74767_n("only_one");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_150788_a(this.item);
        buffer.func_150787_b(this.randomBonus);
        buffer.writeBoolean(this.onlyOne);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.item = buffer.func_150791_c();
        this.randomBonus = buffer.func_150792_a();
        this.onlyOne = buffer.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addItemStack("item", this.item, v -> {
            this.item = v;
        }, ItemStack.field_190927_a, false, false).setNameKey("ftbquests.reward.ftbquests.item");
        config.addInt("random_bonus", this.randomBonus, v -> {
            this.randomBonus = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.reward.random_bonus");
        config.addBool("only_one", this.onlyOne, v -> {
            this.onlyOne = v;
        }, false);
    }

    @Override
    public void claim(ServerPlayerEntity player, boolean notify) {
        if (this.onlyOne && player.field_71071_by.func_70431_c(this.item)) {
            return;
        }
        ItemStack stack1 = this.item.func_77946_l();
        stack1.func_190917_f(player.field_70170_p.field_73012_v.nextInt(this.randomBonus + 1));
        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack1);
        if (notify) {
            new MessageDisplayItemRewardToast(stack1).sendTo(player);
        }
    }

    @Override
    public ItemStack claimAutomated(TileEntity tileEntity, @Nullable ServerPlayerEntity player) {
        ItemStack stack1 = this.item.func_77946_l();
        stack1.func_190917_f(tileEntity.func_145831_w().field_73012_v.nextInt(this.randomBonus + 1));
        return stack1;
    }

    @Override
    public Icon getAltIcon() {
        if (this.item.func_190926_b()) {
            return super.getAltIcon();
        }
        return ItemIcon.getItemIcon((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)this.item, (int)1));
    }

    @Override
    public String getAltTitle() {
        return (this.item.func_190916_E() > 1 ? (this.randomBonus > 0 ? this.item.func_190916_E() + "-" + (this.item.func_190916_E() + this.randomBonus) + "x " : this.item.func_190916_E() + "x ") : "") + this.item.func_200301_q().func_150254_d();
    }

    @Override
    public boolean addTitleInMouseOverText() {
        return !this.getTitle().equals(this.getAltTitle());
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return new WrappedIngredient((Object)this.item).tooltip();
    }

    @Override
    public String getButtonText() {
        if (this.randomBonus > 0) {
            return this.item.func_190916_E() + "-" + (this.item.func_190916_E() + this.randomBonus);
        }
        return Integer.toString(this.item.func_190916_E());
    }
}

