/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.BooleanTaskData;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.icon.ItemIcon;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AdvancementTask
extends Task {
    public String advancement = "";
    public String criterion = "";

    public AdvancementTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.ADVANCEMENT;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("advancement", this.advancement);
        nbt.func_74778_a("criterion", this.criterion);
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.advancement = nbt.func_74779_i("advancement");
        this.criterion = nbt.func_74779_i("criterion");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_180714_a(this.advancement);
        buffer.func_180714_a(this.criterion);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.advancement = buffer.func_218666_n();
        this.criterion = buffer.func_218666_n();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("advancement", this.advancement, v -> {
            this.advancement = v;
        }, "").setNameKey("ftbquests.task.ftbquests.advancement");
        config.addString("criterion", this.criterion, v -> {
            this.criterion = v;
        }, "");
    }

    @Override
    public String getAltTitle() {
        Advancement a = Minecraft.func_71410_x().field_71439_g.field_71174_a.func_191982_f().func_194229_a().func_192084_a(new ResourceLocation(this.advancement));
        if (a != null && a.func_192068_c() != null) {
            return I18n.func_135052_a((String)"ftbquests.task.ftbquests.advancement", (Object[])new Object[0]) + ": " + TextFormatting.YELLOW + a.func_192068_c().func_192297_a().func_150254_d();
        }
        return super.getAltTitle();
    }

    @Override
    public Icon getAltIcon() {
        Advancement a = Minecraft.func_71410_x().field_71439_g.field_71174_a.func_191982_f().func_194229_a().func_192084_a(new ResourceLocation(this.advancement));
        return a == null || a.func_192068_c() == null ? super.getAltIcon() : ItemIcon.getItemIcon((ItemStack)a.func_192068_c().func_192298_b());
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 5;
    }

    @Override
    public TaskData createData(PlayerData data) {
        return new Data(this, data);
    }

    public static class Data
    extends BooleanTaskData<AdvancementTask> {
        private Data(AdvancementTask task, PlayerData data) {
            super(task, data);
        }

        @Override
        public boolean canSubmit(ServerPlayerEntity player) {
            if (((AdvancementTask)this.task).advancement.isEmpty()) {
                return false;
            }
            Advancement a = player.field_71133_b.func_191949_aK().func_192778_a(new ResourceLocation(((AdvancementTask)this.task).advancement));
            if (a == null) {
                return false;
            }
            AdvancementProgress progress = player.func_192039_O().func_192747_a(a);
            if (((AdvancementTask)this.task).criterion.isEmpty()) {
                return progress.func_192105_a();
            }
            CriterionProgress criterionProgress = progress.func_192106_c(((AdvancementTask)this.task).criterion);
            return criterionProgress != null && criterionProgress.func_192151_a();
        }
    }
}

