/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftbquests.net.MessageSubmitTask;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import java.util.function.Predicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CustomTask
extends Task {
    public static final Predicate<QuestObjectBase> PREDICATE = object -> object instanceof CustomTask;
    public Check check = null;
    public int checkTimer = 1;
    public long maxProgress = 1L;
    public boolean enableButton = false;

    public CustomTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.CUSTOM;
    }

    @Override
    public long getMaxProgress() {
        return this.maxProgress;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        if (this.enableButton && canClick) {
            button.playClickSound();
            new MessageSubmitTask(this.id).sendToServer();
        }
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return this.check == null ? 0 : this.checkTimer;
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_150787_b(this.checkTimer);
        buffer.func_179254_b(this.maxProgress);
        buffer.writeBoolean(this.enableButton);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.checkTimer = buffer.func_150792_a();
        this.maxProgress = buffer.func_179260_f();
        this.enableButton = buffer.readBoolean();
    }

    @Override
    public TaskData createData(PlayerData data) {
        return new Data(this, data);
    }

    public static class Data
    extends TaskData<CustomTask> {
        private Data(CustomTask task, PlayerData data) {
            super(task, data);
        }

        @Override
        public void submitTask(ServerPlayerEntity player, ItemStack item) {
            if (((CustomTask)this.task).check != null && !this.isComplete()) {
                ((CustomTask)this.task).check.check(this, player);
            }
        }
    }

    @FunctionalInterface
    public static interface Check {
        public void check(Data var1, ServerPlayerEntity var2);
    }
}

