/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.BooleanTaskData;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.NameMap;
import com.google.common.collect.Streams;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DimensionTask
extends Task {
    public String dimension = "minecraft:the_nether";

    public DimensionTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.DIMENSION;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("dimension", this.dimension);
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.dimension = nbt.func_74779_i("dimension");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_211400_a(this.dimension, Short.MAX_VALUE);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.dimension = buffer.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("dim", (Object)this.dimension, v -> {
            this.dimension = v;
        }, NameMap.of((Object)"minecraft:the_nether", Streams.stream((Iterable)DimensionType.func_212681_b()).map(d -> String.valueOf(d.getRegistryName())).collect(Collectors.toList())).create());
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.task.ftbquests.dimension", (Object[])new Object[0]) + ": " + TextFormatting.DARK_GREEN + this.dimension;
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    @Override
    public TaskData createData(PlayerData data) {
        return new Data(this, data);
    }

    public static class Data
    extends BooleanTaskData<DimensionTask> {
        private Data(DimensionTask task, PlayerData data) {
            super(task, data);
        }

        @Override
        public boolean canSubmit(ServerPlayerEntity player) {
            return ((DimensionTask)this.task).dimension.equals(String.valueOf(player.field_71093_bK.getRegistryName())) && !player.func_175149_v();
        }
    }
}

