/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftbquests.gui.quests.GuiValidItems;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.ftbquests.util.NBTUtils;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.Tristate;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.icon.IconAnimation;
import com.feed_the_beast.mods.ftbguilibrary.icon.ItemIcon;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemTask
extends Task
implements Predicate<ItemStack> {
    public ItemStack item = ItemStack.field_190927_a;
    public long count = 1L;
    public Tristate consumeItems = Tristate.DEFAULT;

    public ItemTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.ITEM;
    }

    @Override
    public long getMaxProgress() {
        return this.count;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        NBTUtils.write(nbt, "item", this.item);
        if (this.count > 1L) {
            nbt.func_74772_a("count", this.count);
        }
        if (this.consumeItems != Tristate.DEFAULT) {
            this.consumeItems.write(nbt, "consume_items");
        }
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.item = NBTUtils.read(nbt, "item");
        this.count = nbt.func_74763_f("count");
        if (this.count < 1L) {
            this.count = 1L;
        }
        this.consumeItems = Tristate.read((CompoundNBT)nbt, (String)"consume_items");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_150788_a(this.item);
        buffer.func_179254_b(this.count);
        Tristate.NAME_MAP.write(buffer, (Object)this.consumeItems);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.item = buffer.func_150791_c();
        this.count = buffer.func_179260_f();
        this.consumeItems = (Tristate)Tristate.NAME_MAP.read(buffer);
    }

    public List<ItemStack> getValidItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemFiltersAPI.getValidItems((ItemStack)this.item, list);
        return list;
    }

    @Override
    public Icon getAltIcon() {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (ItemStack stack : this.getValidItems()) {
            Icon icon = ItemIcon.getItemIcon((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
            if (icon.isEmpty()) continue;
            icons.add(icon);
        }
        if (icons.isEmpty()) {
            return super.getAltIcon();
        }
        return IconAnimation.fromList(icons, (boolean)false);
    }

    @Override
    public String getAltTitle() {
        if (this.count > 1L) {
            return this.count + "x " + this.item.func_200301_q().func_150254_d();
        }
        return this.item.func_200301_q().func_150254_d();
    }

    @Override
    public boolean test(ItemStack stack) {
        return ItemFiltersAPI.filter((ItemStack)this.item, (ItemStack)stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addItemStack("item", this.item, v -> {
            this.item = v;
        }, ItemStack.field_190927_a, true, false).setNameKey("ftbquests.task.ftbquests.item");
        config.addLong("count", this.count, v -> {
            this.count = v;
        }, 1L, 1L, Long.MAX_VALUE);
        config.addEnum("consume_items", (Object)this.consumeItems, v -> {
            this.consumeItems = v;
        }, Tristate.NAME_MAP);
    }

    @Override
    public boolean consumesResources() {
        return this.consumeItems.get(this.quest.chapter.file.defaultTeamConsumeItems);
    }

    @Override
    public boolean canInsertItem() {
        return this.consumesResources();
    }

    @Override
    public boolean submitItemsOnInventoryChange() {
        return !this.consumesResources();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        button.playClickSound();
        List<ItemStack> validItems = this.getValidItems();
        if (!this.consumesResources() && validItems.size() == 1 && ModList.get().isLoaded("jei")) {
            this.showJEIRecipe(validItems.get(0));
        } else {
            new GuiValidItems(this, validItems, canClick).openGui();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void showJEIRecipe(ItemStack stack) {
        FTBQuestsJEIHelper.showRecipes(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(List<String> list, @Nullable TaskData data) {
        if (this.consumesResources()) {
            list.add("");
            list.add(TextFormatting.YELLOW.toString() + TextFormatting.UNDERLINE + I18n.func_135052_a((String)"ftbquests.task.click_to_submit", (Object[])new Object[0]));
        } else if (this.getValidItems().size() > 1) {
            list.add("");
            list.add(TextFormatting.YELLOW.toString() + TextFormatting.UNDERLINE + I18n.func_135052_a((String)"ftbquests.task.ftbquests.item.view_items", (Object[])new Object[0]));
        } else if (ModList.get().isLoaded("jei")) {
            list.add("");
            list.add(TextFormatting.YELLOW.toString() + TextFormatting.UNDERLINE + I18n.func_135052_a((String)"ftbquests.task.ftbquests.item.click_recipe", (Object[])new Object[0]));
        }
    }

    @Override
    public TaskData createData(PlayerData data) {
        return new Data(this, data);
    }

    public static class Data
    extends TaskData<ItemTask> {
        private Data(ItemTask t, PlayerData data) {
            super(t, data);
        }

        public ItemStack insert(ItemStack stack, boolean simulate) {
            long add;
            if (!this.isComplete() && ((ItemTask)this.task).test(stack) && (add = Math.min((long)stack.func_190916_E(), ((ItemTask)this.task).count - this.progress)) > 0L) {
                if (!simulate && !this.data.file.getSide().isClient()) {
                    this.addProgress(add);
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)((int)((long)stack.func_190916_E() - add)));
            }
            return stack;
        }

        @Override
        public void submitTask(ServerPlayerEntity player, ItemStack item) {
            if (this.isComplete()) {
                return;
            }
            if (!((ItemTask)this.task).consumesResources()) {
                long count = 0L;
                for (ItemStack stack : player.field_71071_by.field_70462_a) {
                    if (stack.func_190926_b() || !((ItemTask)this.task).test(stack)) continue;
                    count += (long)stack.func_190916_E();
                }
                if ((count = Math.min(((ItemTask)this.task).count, count)) > this.progress) {
                    this.setProgress(count);
                    return;
                }
                return;
            }
            if (!item.func_190926_b()) {
                return;
            }
            boolean changed = false;
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack stack1;
                ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (stack == (stack1 = this.insert(stack, false))) continue;
                changed = true;
                player.field_71071_by.field_70462_a.set(i, (Object)(stack1.func_190926_b() ? ItemStack.field_190927_a : stack1));
            }
            if (changed) {
                player.field_71071_by.func_70296_d();
                player.field_71070_bA.func_75142_b();
            }
        }
    }
}

