/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.util;

import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.PlayerData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.task.Task;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class FTBQuestsInventoryListener
implements IContainerListener {
    public final ServerPlayerEntity player;

    public FTBQuestsInventoryListener(ServerPlayerEntity p) {
        this.player = p;
    }

    public static void detect(ServerPlayerEntity player, ItemStack item) {
        if (ServerQuestFile.INSTANCE == null) {
            return;
        }
        PlayerData data = ServerQuestFile.INSTANCE.getData((Entity)player);
        for (Chapter chapter : ServerQuestFile.INSTANCE.chapters) {
            for (Quest quest : chapter.quests) {
                if (!FTBQuestsInventoryListener.hasSubmitTasks(quest) || !data.canStartTasks(quest)) continue;
                for (Task task : quest.tasks) {
                    if (!task.submitItemsOnInventoryChange()) continue;
                    data.getTaskData(task).submitTask(player, item);
                }
            }
        }
    }

    private static boolean hasSubmitTasks(Quest quest) {
        for (Task task : quest.tasks) {
            if (!task.submitItemsOnInventoryChange()) continue;
            return true;
        }
        return false;
    }

    public void func_71110_a(Container container, NonNullList<ItemStack> itemsList) {
        FTBQuestsInventoryListener.detect(this.player, ItemStack.field_190927_a);
    }

    public void func_71111_a(Container container, int index, ItemStack stack) {
        if (!stack.func_190926_b() && container.func_75139_a((int)index).field_75224_c == this.player.field_71071_by) {
            FTBQuestsInventoryListener.detect(this.player, ItemStack.field_190927_a);
        }
    }

    public void func_71112_a(Container container, int id, int value) {
    }
}

