/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class NBTUtils {
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");

    public static String handleEscape(String string) {
        return SIMPLE_VALUE.matcher(string).matches() ? string : StringNBT.func_197654_a((String)string);
    }

    public static ItemStack read(CompoundNBT nbt, String key) {
        Item item;
        INBT nbt1 = nbt.func_74781_a(key);
        if (nbt1 instanceof CompoundNBT) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt1));
            if (!stack.func_190926_b()) {
                return stack;
            }
        } else if (nbt1 instanceof StringNBT && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt1.func_150285_a_()))) != null && item != Items.field_190931_a) {
            return new ItemStack((IItemProvider)item);
        }
        return ItemStack.field_190927_a;
    }

    public static void write(CompoundNBT nbt, String key, ItemStack stack) {
        if (!stack.func_190926_b()) {
            CompoundNBT nbt1 = stack.serializeNBT();
            if (nbt1.func_186856_d() == 2 && nbt1.func_74762_e("Count") == 1) {
                nbt.func_74778_a(key, nbt1.func_74779_i("id"));
            } else {
                nbt.func_218657_a(key, (INBT)nbt1);
            }
        }
    }

    @Nullable
    public static CompoundNBT readSNBT(Path base, @Nullable String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        return NBTUtils.readSNBT(base.resolve(path + ".snbt"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static CompoundNBT readSNBT(Path path) {
        File file = path.toFile();
        if (!file.exists()) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                s.append(line.trim());
            }
            CompoundNBT compoundNBT = JsonToNBT.func_180713_a((String)s.toString());
            return compoundNBT;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void writeSNBT(Path base, String path, CompoundNBT out) {
        File file = base.resolve(path + ".snbt").toFile();
        if (!file.exists()) {
            File p = file.getParentFile();
            if (!p.exists()) {
                p.mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));){
            SNBTBuilder builder = new SNBTBuilder();
            NBTUtils.append(builder, (INBT)out);
            builder.println();
            for (String s : builder.lines) {
                writer.println(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void append(SNBTBuilder builder, @Nullable INBT nbt) {
        if (nbt == null || nbt instanceof EndNBT) {
            builder.print("null");
        } else if (nbt instanceof CompoundNBT) {
            CompoundNBT compound = (CompoundNBT)nbt;
            if (compound.isEmpty()) {
                builder.print("{}");
                return;
            }
            builder.print("{");
            builder.println();
            builder.push();
            int index = 0;
            for (String key : compound.func_150296_c()) {
                builder.print(NBTUtils.handleEscape(key));
                builder.print(": ");
                NBTUtils.append(builder, compound.func_74781_a(key));
                if (++index != compound.func_186856_d()) {
                    builder.print(",");
                }
                builder.println();
            }
            builder.pop();
            builder.print("}");
        } else if (nbt instanceof CollectionNBT) {
            if (nbt instanceof ByteArrayNBT) {
                NBTUtils.appendCollection(builder, (CollectionNBT<? extends INBT>)((CollectionNBT)nbt), "B;");
            } else if (nbt instanceof IntArrayNBT) {
                NBTUtils.appendCollection(builder, (CollectionNBT<? extends INBT>)((CollectionNBT)nbt), "I;");
            } else if (nbt instanceof LongArrayNBT) {
                NBTUtils.appendCollection(builder, (CollectionNBT<? extends INBT>)((CollectionNBT)nbt), "L;");
            } else {
                NBTUtils.appendCollection(builder, (CollectionNBT<? extends INBT>)((CollectionNBT)nbt), "");
            }
        } else {
            builder.print(nbt.toString());
        }
    }

    private static void appendCollection(SNBTBuilder builder, CollectionNBT<? extends INBT> nbt, String opening) {
        if (nbt.isEmpty()) {
            builder.print("[");
            builder.print(opening);
            builder.print("]");
            return;
        }
        if (nbt.size() == 1) {
            builder.print("[");
            builder.print(opening);
            NBTUtils.append(builder, (INBT)nbt.get(0));
            builder.print("]");
            return;
        }
        builder.print("[");
        builder.print(opening);
        builder.println();
        builder.push();
        int index = 0;
        for (INBT value : nbt) {
            NBTUtils.append(builder, value);
            if (++index != nbt.size()) {
                builder.print(",");
            }
            builder.println();
        }
        builder.pop();
        builder.print("]");
    }

    public static void putVarLong(CompoundNBT nbt, String key, long value) {
        if (value <= 127L) {
            nbt.func_74774_a(key, (byte)value);
        } else if (value <= 32767L) {
            nbt.func_74777_a(key, (short)value);
        } else if (value <= Integer.MAX_VALUE) {
            nbt.func_74768_a(key, (int)value);
        } else {
            nbt.func_74772_a(key, value);
        }
    }

    private static class SNBTBuilder {
        private String indent = "";
        private final List<String> lines = new ArrayList<String>();
        private final StringBuilder line = new StringBuilder();

        private SNBTBuilder() {
        }

        private void print(Object string) {
            this.line.append(string);
        }

        private void println() {
            this.line.insert(0, this.indent);
            this.lines.add(this.line.toString());
            this.line.setLength(0);
        }

        private void push() {
            this.indent = this.indent + "\t";
        }

        private void pop() {
            this.indent = this.indent.substring(1);
        }
    }
}

