/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbultimine;

import com.feed_the_beast.mods.ftbultimine.BrokenItemHandler;
import com.feed_the_beast.mods.ftbultimine.FTBUltimineCommon;
import com.feed_the_beast.mods.ftbultimine.FTBUltimineConfig;
import com.feed_the_beast.mods.ftbultimine.FTBUltiminePlayerData;
import com.feed_the_beast.mods.ftbultimine.ItemCollection;
import com.feed_the_beast.mods.ftbultimine.client.FTBUltimineClient;
import com.feed_the_beast.mods.ftbultimine.net.FTBUltimineNet;
import com.feed_the_beast.mods.ftbultimine.net.SendShapePacket;
import com.feed_the_beast.mods.ftbultimine.shape.BlockMatcher;
import com.feed_the_beast.mods.ftbultimine.shape.EscapeTunnelShape;
import com.feed_the_beast.mods.ftbultimine.shape.MiningTunnelShape;
import com.feed_the_beast.mods.ftbultimine.shape.Shape;
import com.feed_the_beast.mods.ftbultimine.shape.ShapeContext;
import com.feed_the_beast.mods.ftbultimine.shape.ShapelessShape;
import com.feed_the_beast.mods.ftbultimine.shape.SmallSquareShape;
import com.feed_the_beast.mods.ftbultimine.shape.SmallTunnelShape;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod(value="ftbultimine")
public class FTBUltimine {
    public static FTBUltimine instance;
    public final FTBUltimineCommon proxy;
    private Map<UUID, FTBUltiminePlayerData> cachedDataMap;
    private boolean isBreakingBlock;
    private int tempBlockDroppedXp;
    private ItemCollection tempBlockDropsList;

    public FTBUltimine() {
        instance = this;
        FTBUltimineNet.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.proxy = (FTBUltimineCommon)DistExecutor.runForDist(() -> () -> new FTBUltimineClient(), () -> () -> new FTBUltimineCommon());
        FTBUltimineConfig.init();
        Shape.register(new ShapelessShape());
        Shape.register(new SmallTunnelShape());
        Shape.register(new SmallSquareShape());
        Shape.register(new MiningTunnelShape());
        Shape.register(new EscapeTunnelShape());
    }

    public FTBUltiminePlayerData get(PlayerEntity player) {
        return this.cachedDataMap.computeIfAbsent(player.func_110124_au(), FTBUltiminePlayerData::new);
    }

    @SubscribeEvent
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        this.cachedDataMap = new HashMap<UUID, FTBUltiminePlayerData>();
    }

    public void setKeyPressed(ServerPlayerEntity player, boolean pressed) {
        FTBUltiminePlayerData data = this.get((PlayerEntity)player);
        data.pressed = pressed;
        data.clearCache();
        if (!data.pressed) {
            FTBUltimineNet.MAIN.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SendShapePacket(Collections.emptyList()));
        }
    }

    public void modeChanged(ServerPlayerEntity player) {
        FTBUltiminePlayerData data = this.get((PlayerEntity)player);
        data.clearCache();
        data.shape = data.shape.next();
        player.func_146105_b((ITextComponent)new TranslationTextComponent("ftbultimine.shape_changed", new Object[]{new TranslationTextComponent("ftbultimine.shape." + data.shape.getName(), new Object[0])}), true);
    }

    private int getMaxBlocks(PlayerEntity player) {
        return FTBUltimineConfig.maxBlocks;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void blockBroken(BlockEvent.BreakEvent event) {
        if (this.isBreakingBlock) {
            return;
        }
        if (!(event.getPlayer() instanceof ServerPlayerEntity) || event.getPlayer() instanceof FakePlayer || event.getPlayer().func_110124_au() == null) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        if (player.func_71024_bL().func_75116_a() <= 0 && !player.func_184812_l_()) {
            return;
        }
        if (FTBUltimineConfig.toolBlacklist.contains(player.func_184614_ca().func_77973_b().getRegistryName())) {
            return;
        }
        FTBUltiminePlayerData data = this.get((PlayerEntity)player);
        if (!data.pressed) {
            return;
        }
        RayTraceResult result = FTBUltiminePlayerData.rayTrace(player);
        if (!(result instanceof BlockRayTraceResult) || result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        data.clearCache();
        data.updateBlocks(player, event.getPos(), ((BlockRayTraceResult)result).func_216354_b(), false, this.getMaxBlocks((PlayerEntity)player));
        if (data.cachedBlocks == null || data.cachedBlocks.isEmpty()) {
            return;
        }
        this.isBreakingBlock = true;
        this.tempBlockDropsList = new ItemCollection();
        this.tempBlockDroppedXp = 0;
        boolean hadItem = !player.func_184614_ca().func_190926_b();
        for (BlockPos p : data.cachedBlocks) {
            if (!player.field_71134_c.func_180237_b(p)) continue;
            if (!player.func_184812_l_()) {
                player.func_71020_j((float)(FTBUltimineConfig.exhaustionPerBlock * 0.005));
                if (player.func_71024_bL().func_75116_a() <= 0) break;
            }
            if (!hadItem || !player.func_184614_ca().func_190926_b()) continue;
            break;
        }
        this.isBreakingBlock = false;
        this.tempBlockDropsList.drop(player.field_70170_p, event.getPos());
        if (this.tempBlockDroppedXp > 0) {
            player.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(player.field_70170_p, (double)event.getPos().func_177958_n() + 0.5, (double)event.getPos().func_177956_o() + 0.5, (double)event.getPos().func_177952_p() + 0.5, this.tempBlockDroppedXp));
        }
        data.clearCache();
        FTBUltimineNet.MAIN.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SendShapePacket(Collections.emptyList()));
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void blockRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity) || event.getPlayer() instanceof FakePlayer || event.getPlayer().func_110124_au() == null) {
            return;
        }
        if (event.getPlayer().func_71024_bL().func_75116_a() <= 0 && !event.getPlayer().func_184812_l_()) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        RayTraceResult result = FTBUltiminePlayerData.rayTrace(player);
        if (!(result instanceof BlockRayTraceResult) || result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        FTBUltiminePlayerData data = this.get((PlayerEntity)player);
        data.clearCache();
        ShapeContext shapeContext = data.updateBlocks(player, event.getPos(), ((BlockRayTraceResult)result).func_216354_b(), false, this.getMaxBlocks((PlayerEntity)player));
        if (shapeContext == null || !data.pressed || data.cachedBlocks == null || data.cachedBlocks.isEmpty()) {
            return;
        }
        if (event.getItemStack().func_77973_b() instanceof HoeItem) {
            ResourceLocation dirtTag = new ResourceLocation("forge", "dirt");
            if (!player.field_70170_p.func_201670_d()) {
                boolean playSound = false;
                BrokenItemHandler brokenItemHandler = new BrokenItemHandler();
                for (int i = 0; i < Math.min(data.cachedBlocks.size(), FTBUltimineConfig.maxBlocks); ++i) {
                    BlockPos p = data.cachedBlocks.get(i);
                    BlockState state = player.field_70170_p.func_180495_p(p);
                    if (!state.func_177230_c().getTags().contains(dirtTag)) continue;
                    player.field_70170_p.func_180501_a(p, Blocks.field_150458_ak.func_176223_P(), 11);
                    playSound = true;
                    if (player.func_184812_l_()) continue;
                    player.func_184614_ca().func_222118_a(1, (LivingEntity)player, (Consumer)brokenItemHandler);
                    player.func_71020_j((float)(FTBUltimineConfig.exhaustionPerBlock * 0.005));
                    if (brokenItemHandler.isBroken || player.func_71024_bL().func_75116_a() <= 0) break;
                }
                if (playSound) {
                    player.field_70170_p.func_184133_a((PlayerEntity)player, event.getPos(), SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
            player.func_184609_a(event.getHand());
            event.setCanceled(true);
        } else if (shapeContext.matcher == BlockMatcher.BUSH) {
            ItemCollection itemCollection = new ItemCollection();
            for (BlockPos pos : data.cachedBlocks) {
                CropsBlock c;
                BlockState state = player.field_70170_p.func_180495_p(pos);
                if (!(state.func_177230_c() instanceof CropsBlock) || !(c = (CropsBlock)state.func_177230_c()).func_185525_y(state)) continue;
                if (player.field_70170_p.func_201670_d()) {
                    event.setCanceled(true);
                    player.func_184609_a(event.getHand());
                    continue;
                }
                List drops = Block.func_220077_a((BlockState)state, (ServerWorld)((ServerWorld)player.field_70170_p), (BlockPos)pos, (TileEntity)(state.hasTileEntity() ? player.field_70170_p.func_175625_s(pos) : null), (Entity)player, (ItemStack)ItemStack.field_190927_a);
                Item seedItem = c.func_185473_a((IBlockReader)player.field_70170_p, pos, state).func_77973_b();
                for (ItemStack stack : drops) {
                    if (stack.func_77973_b() == seedItem) {
                        stack.func_190918_g(1);
                    }
                    itemCollection.add(stack);
                }
                player.field_70170_p.func_180501_a(pos, c.func_185528_e(0), 3);
            }
            itemCollection.drop(player.field_70170_p, event.getFace() == null ? event.getPos() : event.getPos().func_177972_a(event.getFace()));
            player.func_184609_a(event.getHand());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.field_70170_p.func_201670_d()) {
            FTBUltiminePlayerData data = this.get(event.player);
            data.checkBlocks((ServerPlayerEntity)event.player, true, this.getMaxBlocks(event.player));
        }
    }

    @SubscribeEvent
    public void playerLoaded(PlayerEvent.LoadFromFile event) {
    }

    @SubscribeEvent
    public void playerSaved(PlayerEvent.SaveToFile event) {
    }

    @SubscribeEvent
    public void entityJoinedWorld(EntityJoinWorldEvent event) {
        if (this.isBreakingBlock && event.getEntity() instanceof ItemEntity) {
            this.tempBlockDropsList.add(((ItemEntity)event.getEntity()).func_92059_d());
            event.setCanceled(true);
        } else if (this.isBreakingBlock && event.getEntity() instanceof ExperienceOrbEntity) {
            this.tempBlockDroppedXp += ((ExperienceOrbEntity)event.getEntity()).func_70526_d();
            event.setCanceled(true);
        }
    }
}

