/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbultimine;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public class FTBUltimineConfig {
    public static int maxBlocks;
    public static double exhaustionPerBlock;
    public static boolean mergeStone;
    public static final HashSet<ResourceLocation> toolBlacklist;
    private static Pair<CommonConfig, ForgeConfigSpec> server;

    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().register(FTBUltimineConfig.class);
        server = new ForgeConfigSpec.Builder().configure(x$0 -> new CommonConfig((ForgeConfigSpec.Builder)x$0));
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, (ForgeConfigSpec)server.getRight());
    }

    @SubscribeEvent
    public static void reload(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == server.getRight()) {
            CommonConfig c = (CommonConfig)server.getLeft();
            maxBlocks = (Integer)c.maxBlocks.get();
            exhaustionPerBlock = (Double)c.exhaustionPerBlock.get();
            mergeStone = (Boolean)c.mergeStone.get();
            toolBlacklist.clear();
            for (String s : (List)c.toolBlacklist.get()) {
                toolBlacklist.add(new ResourceLocation(s));
            }
        }
    }

    static {
        toolBlacklist = new HashSet();
    }

    private static class CommonConfig {
        private final ForgeConfigSpec.IntValue maxBlocks;
        private final ForgeConfigSpec.DoubleValue exhaustionPerBlock;
        private final ForgeConfigSpec.BooleanValue mergeStone;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> toolBlacklist;

        private CommonConfig(ForgeConfigSpec.Builder builder) {
            this.maxBlocks = builder.comment("Max blocks you can mine at once").translation("ftbultimine.max_blocks").defineInRange("max_blocks", 64, 1, 32768);
            this.exhaustionPerBlock = builder.comment("Hunger multiplied for each block mined with ultimine").translation("ftbultimine.exhaustion_per_block").defineInRange("exhaustion_per_block", 20.0, 0.0, 10000.0);
            this.mergeStone = builder.comment("Doesn't stop at different types of stones").translation("ftbultimine.merge_stone").define("merge_stone", true);
            this.toolBlacklist = builder.comment("Tools that won't let you active ultimine when held").translation("ftbultimine.tool_blacklist").defineList("tool_blacklist", (List)Util.func_200696_a(new ArrayList(), l -> l.add("mininggadgets:mininggadget")), o -> true);
        }
    }
}

