/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbultimine.client;

import com.feed_the_beast.mods.ftbultimine.FTBUltimineCommon;
import com.feed_the_beast.mods.ftbultimine.client.CachedEdge;
import com.feed_the_beast.mods.ftbultimine.client.UltimineRenderTypes;
import com.feed_the_beast.mods.ftbultimine.net.FTBUltimineNet;
import com.feed_the_beast.mods.ftbultimine.net.KeyPressedPacket;
import com.feed_the_beast.mods.ftbultimine.net.ModeChangedPacket;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class FTBUltimineClient
extends FTBUltimineCommon {
    private KeyBinding keyBinding;
    private KeyBinding keyBindingSettings;
    private boolean pressed;
    private List<BlockPos> shapeBlocks = Collections.emptyList();
    private List<CachedEdge> cachedEdges = null;

    public FTBUltimineClient() {
        MinecraftForge.EVENT_BUS.addListener(this::renderInGame);
        MinecraftForge.EVENT_BUS.addListener(this::renderInfo);
        MinecraftForge.EVENT_BUS.addListener(this::clientTick);
        this.keyBinding = new KeyBinding("key.ftbultimine", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputMappings.Type.KEYSYM, 96, "key.categories.gameplay");
        this.keyBindingSettings = new KeyBinding("key.ftbultimine_settings", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.SHIFT, InputMappings.Type.KEYSYM, 96, "key.categories.gameplay");
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyBinding);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyBindingSettings);
    }

    @Override
    public void setShape(List<BlockPos> blocks) {
        this.shapeBlocks = blocks;
        this.cachedEdges = null;
        this.updateEdges();
    }

    private void renderInGame(RenderWorldLastEvent event) {
        if (!this.pressed || this.cachedEdges == null || this.cachedEdges.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ActiveRenderInfo activeRenderInfo = mc.func_175598_ae().field_217783_c;
        Vec3d projectedView = activeRenderInfo.func_216785_c();
        MatrixStack ms = event.getMatrixStack();
        ms.func_227860_a_();
        ms.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        Matrix4f matrix = ms.func_227866_c_().func_227870_a_();
        IVertexBuilder buffer = mc.func_228019_au_().func_228487_b_().getBuffer(UltimineRenderTypes.LINES_NORMAL);
        for (CachedEdge edge : this.cachedEdges) {
            buffer.func_227888_a_(matrix, edge.x1, edge.y1, edge.z1).func_225586_a_(255, 255, 255, 255).func_181675_d();
            buffer.func_227888_a_(matrix, edge.x2, edge.y2, edge.z2).func_225586_a_(255, 255, 255, 255).func_181675_d();
        }
        mc.func_228019_au_().func_228487_b_().func_228462_a_(UltimineRenderTypes.LINES_NORMAL);
        IVertexBuilder buffer2 = mc.func_228019_au_().func_228487_b_().getBuffer(UltimineRenderTypes.LINES_TRANSPARENT);
        for (CachedEdge edge : this.cachedEdges) {
            buffer2.func_227888_a_(matrix, edge.x1, edge.y1, edge.z1).func_225586_a_(255, 255, 255, 10).func_181675_d();
            buffer2.func_227888_a_(matrix, edge.x2, edge.y2, edge.z2).func_225586_a_(255, 255, 255, 10).func_181675_d();
        }
        mc.func_228019_au_().func_228487_b_().func_228462_a_(UltimineRenderTypes.LINES_TRANSPARENT);
        ms.func_227865_b_();
    }

    private void renderInfo(GuiScreenEvent event) {
    }

    private void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase != TickEvent.Phase.START || mc.field_71439_g == null) {
            return;
        }
        if (this.keyBindingSettings.func_151468_f()) {
            FTBUltimineNet.MAIN.sendToServer((Object)new ModeChangedPacket());
            return;
        }
        if (this.keyBinding.func_151468_f()) {
            if (!this.pressed) {
                this.pressed = true;
                FTBUltimineNet.MAIN.sendToServer((Object)new KeyPressedPacket(true));
            }
        } else if (this.pressed && !this.keyBinding.func_151470_d()) {
            this.pressed = false;
            FTBUltimineNet.MAIN.sendToServer((Object)new KeyPressedPacket(false));
        }
    }

    private void updateEdges() {
        if (this.cachedEdges != null) {
            return;
        }
        if (this.shapeBlocks.isEmpty()) {
            this.cachedEdges = Collections.emptyList();
            return;
        }
        BlockPos pos = this.shapeBlocks.get(0);
        double d = 0.005;
        VoxelShape shape = VoxelShapes.func_197873_a((double)(-d), (double)(-d), (double)(-d), (double)(1.0 + d), (double)(1.0 + d), (double)(1.0 + d));
        VoxelShape[] extraShapes = new VoxelShape[this.shapeBlocks.size() - 1];
        for (int i = 1; i < this.shapeBlocks.size(); ++i) {
            BlockPos p = this.shapeBlocks.get(i);
            extraShapes[i - 1] = shape.func_197751_a((double)(p.func_177958_n() - pos.func_177958_n()), (double)(p.func_177956_o() - pos.func_177956_o()), (double)(p.func_177952_p() - pos.func_177952_p()));
        }
        this.cachedEdges = new ArrayList<CachedEdge>();
        (extraShapes.length == 0 ? shape : VoxelShapes.func_216384_a((VoxelShape)shape, (VoxelShape[])extraShapes)).func_197754_a((x1, y1, z1, x2, y2, z2) -> {
            CachedEdge edge = new CachedEdge();
            edge.x1 = (float)(x1 + (double)pos.func_177958_n());
            edge.y1 = (float)(y1 + (double)pos.func_177956_o());
            edge.z1 = (float)(z1 + (double)pos.func_177952_p());
            edge.x2 = (float)(x2 + (double)pos.func_177958_n());
            edge.y2 = (float)(y2 + (double)pos.func_177956_o());
            edge.z2 = (float)(z2 + (double)pos.func_177952_p());
            this.cachedEdges.add(edge);
        });
    }
}

