/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbultimine.shape;

import com.feed_the_beast.mods.ftbultimine.shape.ShapeContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.BlockPos;

public abstract class Shape {
    private static final Map<String, Shape> MAP = new LinkedHashMap<String, Shape>();
    private static Shape defaultShape;

    public static void register(Shape shape) {
        MAP.put(shape.getName(), shape);
        if (shape.isDefault()) {
            defaultShape = shape;
        }
    }

    public static Shape get(String id) {
        if (id.isEmpty()) {
            return defaultShape;
        }
        return MAP.getOrDefault(id, defaultShape);
    }

    public abstract String getName();

    public abstract List<BlockPos> getBlocks(ShapeContext var1);

    public boolean isDefault() {
        return false;
    }

    public final Shape next() {
        ArrayList<Shape> list = new ArrayList<Shape>(MAP.values());
        return (Shape)list.get((list.indexOf(this) + 1) % list.size());
    }
}

