/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.net.MessageClaimChoiceReward;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import com.feed_the_beast.ftbquests.quest.reward.ChoiceReward;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;

public class GuiSelectChoiceReward
extends GuiButtonListBase {
    private final ChoiceReward choiceReward;

    public GuiSelectChoiceReward(ChoiceReward r) {
        this.choiceReward = r;
        this.setTitle(I18n.func_135052_a((String)"ftbquests.reward.ftbquests.choice", (Object[])new Object[0]));
        this.setBorder(1, 1, 1);
    }

    public void addButtons(Panel panel) {
        for (WeightedReward r : this.choiceReward.getTable().rewards) {
            panel.add((Widget)new ButtonChoiceReward(panel, r));
        }
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private class ButtonChoiceReward
    extends SimpleTextButton {
        private final WeightedReward weightedReward;

        private ButtonChoiceReward(Panel panel, WeightedReward r) {
            super(panel, r.reward.getTitle(), r.reward.getIcon());
            this.weightedReward = r;
        }

        public void addMouseOverText(List<String> list) {
            super.addMouseOverText(list);
            this.weightedReward.reward.addMouseOverText(list);
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            this.closeGui();
            new MessageClaimChoiceReward(((GuiSelectChoiceReward)GuiSelectChoiceReward.this).choiceReward.id, ((GuiSelectChoiceReward)GuiSelectChoiceReward.this).choiceReward.getTable().rewards.indexOf(this.weightedReward)).sendToServer();
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return this.weightedReward.reward.getIngredient();
        }
    }
}

