/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.config.IIteratingConfig;
import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.gui.GuiSelectQuestObject;
import com.feed_the_beast.ftbquests.gui.tree.ButtonChapter;
import com.feed_the_beast.ftbquests.gui.tree.PanelChapterHover;
import com.feed_the_beast.ftbquests.gui.tree.PanelChapters;
import com.feed_the_beast.ftbquests.gui.tree.PanelOtherButtonsBottom;
import com.feed_the_beast.ftbquests.gui.tree.PanelOtherButtonsTop;
import com.feed_the_beast.ftbquests.gui.tree.PanelQuests;
import com.feed_the_beast.ftbquests.gui.tree.PanelViewQuest;
import com.feed_the_beast.ftbquests.net.edit.MessageChangeProgress;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Movable;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.reward.RandomReward;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.theme.QuestTheme;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class GuiQuestTree
extends GuiBase {
    public final ClientQuestFile file;
    public double scrollWidth;
    public double scrollHeight;
    public int prevMouseX;
    public int prevMouseY;
    public int grabbed;
    public Chapter selectedChapter;
    public final List<Movable> selectedObjects;
    public final PanelChapters chapterPanel;
    public final PanelQuests questPanel;
    public final PanelOtherButtonsBottom otherButtonsBottomPanel;
    public final PanelOtherButtonsTop otherButtonsTopPanel;
    public final PanelChapterHover chapterHoverPanel;
    public final PanelViewQuest viewQuestPanel;
    public boolean movingObjects = false;
    public int zoom = 16;
    public long lastShiftPress = 0L;
    public static boolean grid = false;

    public GuiQuestTree(ClientQuestFile q) {
        this.file = q;
        this.selectedObjects = new ArrayList<Movable>();
        this.chapterPanel = new PanelChapters((Panel)this);
        this.selectedChapter = this.file.chapters.isEmpty() ? null : (Chapter)this.file.chapters.get(0);
        this.questPanel = new PanelQuests((Panel)this);
        this.otherButtonsBottomPanel = new PanelOtherButtonsBottom((Panel)this);
        this.otherButtonsTopPanel = new PanelOtherButtonsTop((Panel)this);
        this.chapterHoverPanel = new PanelChapterHover((Panel)this);
        this.viewQuestPanel = new PanelViewQuest(this);
        this.selectChapter(null);
    }

    @Nullable
    public Quest getViewedQuest() {
        return this.viewQuestPanel.quest;
    }

    public void addWidgets() {
        QuestTheme.currentObject = this.selectedChapter;
        this.add((Widget)this.chapterPanel);
        this.add((Widget)this.questPanel);
        this.add((Widget)this.otherButtonsBottomPanel);
        this.add((Widget)this.otherButtonsTopPanel);
        this.add((Widget)this.chapterHoverPanel);
        this.add((Widget)this.viewQuestPanel);
    }

    public void alignWidgets() {
        QuestTheme.currentObject = this.selectedChapter;
        this.otherButtonsBottomPanel.alignWidgets();
        this.otherButtonsTopPanel.alignWidgets();
        this.chapterPanel.alignWidgets();
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void onClosed() {
        this.selectedObjects.clear();
        super.onClosed();
    }

    public void selectChapter(@Nullable Chapter chapter) {
        if (this.selectedChapter != chapter) {
            this.closeQuest();
            this.selectedChapter = chapter;
            this.questPanel.refreshWidgets();
            this.questPanel.resetScroll();
        }
    }

    public void viewQuest(Quest quest) {
        if (this.viewQuestPanel.quest != quest) {
            this.viewQuestPanel.quest = quest;
            this.viewQuestPanel.refreshWidgets();
        }
    }

    public boolean onClosedByKey(int key) {
        if (super.onClosedByKey(key)) {
            if (this.getViewedQuest() != null) {
                this.closeQuest();
                return false;
            }
            return true;
        }
        return false;
    }

    public void onBack() {
        if (this.getViewedQuest() != null) {
            this.closeQuest();
        } else {
            super.onBack();
        }
    }

    public void closeQuest() {
        if (this.viewQuestPanel.quest != null) {
            this.viewQuestPanel.quest = null;
            this.viewQuestPanel.hidePanel = false;
            this.viewQuestPanel.refreshWidgets();
        }
    }

    public void toggleSelected(Movable movable) {
        if (this.viewQuestPanel.quest != null) {
            this.viewQuestPanel.quest = null;
            this.viewQuestPanel.refreshWidgets();
        }
        if (!this.selectedObjects.add(movable)) {
            this.selectedObjects.remove(movable);
        }
    }

    public static void addObjectMenuItems(List<ContextMenuItem> contextMenu, final IOpenableGui gui, final QuestObjectBase object) {
        ConfigGroup group = ConfigGroup.newGroup((String)"ftbquests");
        ConfigGroup g = object.createSubGroup(group);
        object.getConfig(g);
        if (!g.getValues().isEmpty()) {
            ArrayList<1> list = new ArrayList<1>();
            for (final ConfigValueInstance inst : g.getValues()) {
                if (!(inst.getValue() instanceof IIteratingConfig)) continue;
                String name = inst.getDisplayName().func_150254_d();
                if (!inst.getCanEdit()) {
                    name = TextFormatting.GRAY + name;
                }
                list.add(new ContextMenuItem(name, inst.getIcon(), null){

                    public void addMouseOverText(List<String> list) {
                        list.add(inst.getValue().getStringForGUI().func_150254_d());
                    }

                    public void onClicked(Panel panel, MouseButton button) {
                        inst.getValue().onClicked(gui, inst, button, () -> new MessageEditObject(object).sendToServer());
                    }

                    public void drawIcon(Theme theme, int x, int y, int w, int h) {
                        if (inst.getValue() instanceof ConfigBoolean) {
                            (inst.getValue().getBoolean() ? GuiIcons.ACCEPT : GuiIcons.ACCEPT_GRAY).draw(x, y, w, h);
                        } else {
                            super.drawIcon(theme, x, y, w, h);
                        }
                    }
                });
            }
            if (!list.isEmpty()) {
                list.sort(null);
                contextMenu.addAll(list);
                contextMenu.add(ContextMenuItem.SEPARATOR);
            }
        }
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.edit", (Object[])new Object[0]), (Icon)ThemeProperties.EDIT_ICON.get(), object::onEditButtonClicked));
        if (object instanceof RandomReward && !QuestObjectBase.isNull(((RandomReward)object).getTable())) {
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.reward_table.edit", (Object[])new Object[0]), (Icon)ThemeProperties.EDIT_ICON.get(), () -> ((RandomReward)object).getTable().onEditButtonClicked()));
        }
        ContextMenuItem delete = new ContextMenuItem(I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), (Icon)ThemeProperties.DELETE_ICON.get(), () -> ClientQuestFile.INSTANCE.deleteObject(object.id));
        if (!GuiQuestTree.isShiftKeyDown()) {
            delete.setYesNo(I18n.func_135052_a((String)"delete_item", (Object[])new Object[]{object.getTitle()}));
        }
        contextMenu.add(delete);
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.reset_progress", (Object[])new Object[0]), (Icon)ThemeProperties.RELOAD_ICON.get(), () -> new MessageChangeProgress(ClientQuestFile.INSTANCE.self.getTeamUID(), object.id, GuiQuestTree.isShiftKeyDown() ? ChangeProgress.RESET_DEPS : ChangeProgress.RESET).sendToServer()).setYesNo(I18n.func_135052_a((String)"ftbquests.gui.reset_progress_q", (Object[])new Object[0])));
        if (object instanceof QuestObject) {
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.complete_instantly", (Object[])new Object[0]), (Icon)ThemeProperties.CHECK_ICON.get(), () -> new MessageChangeProgress(ClientQuestFile.INSTANCE.self.getTeamUID(), object.id, GuiQuestTree.isShiftKeyDown() ? ChangeProgress.COMPLETE_DEPS : ChangeProgress.COMPLETE).sendToServer()).setYesNo(I18n.func_135052_a((String)"ftbquests.gui.complete_instantly_q", (Object[])new Object[0])));
        }
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.copy_id", (Object[])new Object[0]), (Icon)ThemeProperties.WIKI_ICON.get(), () -> GuiQuestTree.setClipboardString((String)QuestObjectBase.getCodeString(object))){

            public void addMouseOverText(List<String> list) {
                list.add(QuestObjectBase.getCodeString(object));
            }
        });
    }

    public static void displayError(ITextComponent error) {
        Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new SystemToast(SystemToast.Type.TUTORIAL_HINT, (ITextComponent)new TextComponentTranslation("ftbquests.gui.error", new Object[0]), error));
    }

    private boolean moveSelectedQuests(double x, double y) {
        for (Movable movable : this.selectedObjects) {
            if (movable.getChapter() != this.selectedChapter) continue;
            movable.move(this.selectedChapter, movable.getX() + x, movable.getY() + y);
        }
        return true;
    }

    public boolean keyPressed(int key, char keyChar) {
        if (super.keyPressed(key, keyChar)) {
            return true;
        }
        if (key == 15) {
            if (this.selectedChapter != null && this.file.chapters.size() > 1) {
                List<Chapter> visibleChapters;
                List<Chapter> list = visibleChapters = this.file.canEdit() ? this.file.chapters : this.file.getVisibleChapters(this.file.self, true);
                if (!visibleChapters.isEmpty()) {
                    this.selectChapter(visibleChapters.get(MathUtils.mod((int)(visibleChapters.indexOf(this.selectedChapter) + (GuiQuestTree.isShiftKeyDown() ? -1 : 1)), (int)visibleChapters.size())));
                }
            }
            return true;
        }
        if (key == 57) {
            this.questPanel.resetScroll();
            return true;
        }
        if (key == 19) {
            grid = !grid;
            return true;
        }
        if (keyChar >= '1' && keyChar <= '9') {
            int i = keyChar - 49;
            if (i < this.file.chapters.size()) {
                this.selectChapter((Chapter)this.file.chapters.get(i));
            }
            return true;
        }
        if (GuiQuestTree.isCtrlKeyDown() && this.selectedChapter != null && this.file.canEdit()) {
            double step = GuiQuestTree.isShiftKeyDown() ? 0.1 : 0.5;
            switch (key) {
                case 30: {
                    this.selectedObjects.addAll(this.selectedChapter.quests);
                    return true;
                }
                case 32: {
                    this.selectedObjects.clear();
                    return true;
                }
                case 208: {
                    return this.moveSelectedQuests(0.0, step);
                }
                case 200: {
                    return this.moveSelectedQuests(0.0, -step);
                }
                case 203: {
                    return this.moveSelectedQuests(-step, 0.0);
                }
                case 205: {
                    return this.moveSelectedQuests(step, 0.0);
                }
            }
        }
        if (key == 42) {
            long now = System.currentTimeMillis();
            if (this.lastShiftPress == 0L) {
                this.lastShiftPress = now;
            } else {
                if (now - this.lastShiftPress <= 400L) {
                    ConfigQuestObject c = new ConfigQuestObject((QuestFile)this.file, 0, QuestObjectType.CHAPTER.or(QuestObjectType.QUEST));
                    GuiSelectQuestObject gui = new GuiSelectQuestObject(c, (IOpenableGui)this, () -> {
                        QuestObjectBase o = this.file.getBase(c.getObject());
                        if (o instanceof Chapter) {
                            this.selectChapter((Chapter)o);
                        } else if (o instanceof Quest) {
                            this.zoom = 20;
                            this.selectChapter(((Quest)o).chapter);
                            this.viewQuestPanel.hidePanel = false;
                            this.viewQuest((Quest)o);
                        }
                    });
                    gui.focus();
                    gui.setTitle(I18n.func_135052_a((String)"gui.search_box", (Object[])new Object[0]));
                    gui.openGui();
                }
                this.lastShiftPress = 0L;
            }
        }
        return false;
    }

    public void tick() {
        List<Chapter> visible;
        if (this.selectedChapter != null && this.selectedChapter.invalid) {
            this.selectChapter(null);
        }
        if (this.selectedChapter == null && !(visible = this.file.getVisibleChapters(this.file.self, !this.file.canEdit())).isEmpty()) {
            this.selectChapter(visible.get(0));
        }
        super.tick();
    }

    public int getZoom() {
        return this.zoom;
    }

    public double getQuestButtonSize() {
        return (double)this.getZoom() * 3.0 / 2.0;
    }

    public double getQuestButtonSpacing() {
        return (double)this.getZoom() * (Double)ThemeProperties.QUEST_SPACING.get(this.selectedChapter) / 4.0;
    }

    public void addZoom(int up) {
        int z = this.zoom;
        this.zoom = MathHelper.func_76125_a((int)(this.zoom + up * 4), (int)4, (int)28);
        if (this.zoom != z) {
            this.grabbed = 0;
            double sx = this.questPanel.centerQuestX;
            double sy = this.questPanel.centerQuestY;
            this.questPanel.resetScroll();
            this.questPanel.scrollTo(sx, sy);
        }
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        QuestTheme.currentObject = this.selectedChapter;
        super.drawBackground(theme, x, y, w, h);
        int pw = 20;
        Color4I borderColor = (Color4I)ThemeProperties.WIDGET_BORDER.get(this.selectedChapter);
        Color4I backgroundColor = (Color4I)ThemeProperties.WIDGET_BACKGROUND.get(this.selectedChapter);
        borderColor.draw(x + pw - 1, y + 1, 1, h - 2);
        backgroundColor.draw(x + 1, y + 1, pw - 2, h - 2);
        borderColor.draw(x + w - pw, y + 1, 1, h - 2);
        backgroundColor.draw(x + w - pw + 1, y + 1, pw - 2, h - 2);
        if (this.grabbed != 0) {
            int mx = this.getMouseX();
            int my = this.getMouseY();
            if (this.scrollWidth > (double)this.questPanel.width) {
                this.questPanel.setScrollX(Math.max(Math.min(this.questPanel.getScrollX() + (double)(this.prevMouseX - mx), this.scrollWidth - (double)this.questPanel.width), 0.0));
            } else {
                this.questPanel.setScrollX((this.scrollWidth - (double)this.questPanel.width) / 2.0);
            }
            if (this.scrollHeight > (double)this.questPanel.height) {
                this.questPanel.setScrollY(Math.max(Math.min(this.questPanel.getScrollY() + (double)(this.prevMouseY - my), this.scrollHeight - (double)this.questPanel.height), 0.0));
            } else {
                this.questPanel.setScrollY((this.scrollHeight - (double)this.questPanel.height) / 2.0);
            }
            this.prevMouseX = mx;
            this.prevMouseY = my;
        }
    }

    public void drawForeground(Theme theme, int x, int y, int w, int h) {
        Color4I borderColor = (Color4I)ThemeProperties.WIDGET_BORDER.get(this.selectedChapter);
        GuiHelper.drawHollowRect((int)x, (int)y, (int)w, (int)h, (Color4I)borderColor, (boolean)false);
        super.drawForeground(theme, x, y, w, h);
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public boolean drawDefaultBackground() {
        return false;
    }

    public void open(@Nullable QuestObject object, boolean focus) {
        Chapter c;
        Chapter chapter = c = this.chapterHoverPanel.chapter == null ? null : this.chapterHoverPanel.chapter.chapter;
        if (object instanceof Chapter) {
            this.selectChapter((Chapter)object);
        } else if (object instanceof Quest) {
            this.viewQuestPanel.hidePanel = false;
            Quest q = (Quest)object;
            this.selectChapter(q.chapter);
            this.viewQuest(q);
            if (focus) {
                this.questPanel.scrollTo(q.x + 0.5, q.y + 0.5);
            }
        } else if (object instanceof Task) {
            this.viewQuestPanel.hidePanel = false;
            this.selectChapter(((Task)object).quest.chapter);
            this.viewQuest(((Task)object).quest);
        }
        this.openGui();
        if (c != null) {
            for (Widget widget : this.chapterPanel.widgets) {
                if (!(widget instanceof ButtonChapter) || c != ((ButtonChapter)widget).chapter) continue;
                this.chapterHoverPanel.chapter = (ButtonChapter)widget;
                this.chapterHoverPanel.refreshWidgets();
                this.chapterHoverPanel.updateMouseOver(this.getMouseX(), this.getMouseY());
                break;
            }
        }
    }

    public boolean handleClick(String scheme, String path) {
        if (scheme.isEmpty() && path.startsWith("#")) {
            this.open(this.file.get(this.file.getID(path)), true);
            return true;
        }
        return super.handleClick(scheme, path);
    }
}

