/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.gui.WrappedIngredient;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.net.MessageDisplayItemRewardToast;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.latmod.mods.itemfilters.item.ItemMissing;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemReward
extends Reward {
    public ItemStack item;
    public int count;
    public int randomBonus;
    public boolean onlyOne;

    public ItemReward(Quest quest, ItemStack is) {
        super(quest);
        this.item = is;
        this.count = 1;
        this.randomBonus = 0;
        this.onlyOne = false;
    }

    public ItemReward(Quest quest) {
        this(quest, new ItemStack(Items.field_151034_e));
    }

    @Override
    public RewardType getType() {
        return FTBQuestsRewards.ITEM;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74782_a("item", ItemMissing.write((ItemStack)this.item, (boolean)false));
        if (this.count > 1) {
            nbt.func_74768_a("count", this.count);
        }
        if (this.randomBonus > 0) {
            nbt.func_74768_a("random_bonus", this.randomBonus);
        }
        if (this.onlyOne) {
            nbt.func_74757_a("only_one", true);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.item = ItemMissing.read((NBTBase)nbt.func_74781_a("item"));
        this.count = nbt.func_74762_e("count");
        if (this.count == 0) {
            this.count = this.item.func_190916_E();
            this.item.func_190920_e(1);
        }
        this.randomBonus = nbt.func_74762_e("random_bonus");
        this.onlyOne = nbt.func_74767_n("only_one");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeItemStack(this.item);
        data.writeVarInt(this.count);
        data.writeVarInt(this.randomBonus);
        data.writeBoolean(this.onlyOne);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.item = data.readItemStack();
        this.count = data.readVarInt();
        this.randomBonus = data.readVarInt();
        this.onlyOne = data.readBoolean();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.add("item", (ConfigValue)new ConfigItemStack.SimpleStack(true, () -> this.item, v -> {
            this.item = v;
        }), (ConfigValue)new ConfigItemStack(ItemStack.field_190927_a)).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.ftbquests.item", new Object[0]));
        config.addInt("count", () -> this.count, v -> {
            this.count = v;
        }, 1, 1, 8192);
        config.addInt("random_bonus", () -> this.randomBonus, v -> {
            this.randomBonus = v;
        }, 0, 0, 8192).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.random_bonus", new Object[0]));
        config.addBool("only_one", () -> this.onlyOne, v -> {
            this.onlyOne = v;
        }, false);
    }

    @Override
    public void claim(EntityPlayerMP player, boolean notify) {
        int size;
        int s;
        if (this.onlyOne && player.field_71071_by.func_70431_c(this.item)) {
            return;
        }
        for (size = this.count + player.field_70170_p.field_73012_v.nextInt(this.randomBonus + 1); size > 0; size -= s) {
            s = Math.min(size, this.item.func_77976_d());
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)this.item, (int)s));
        }
        if (notify) {
            new MessageDisplayItemRewardToast(this.item, size).sendTo(player);
        }
    }

    @Override
    public boolean automatedClaimPre(TileEntity tileEntity, List<ItemStack> items, Random random, UUID playerId, @Nullable EntityPlayerMP player) {
        int s;
        for (int size = this.count + random.nextInt(this.randomBonus + 1); size > 0; size -= s) {
            s = Math.min(size, this.item.func_77976_d());
            items.add(ItemHandlerHelper.copyStackWithSize((ItemStack)this.item, (int)s));
        }
        return true;
    }

    @Override
    public void automatedClaimPost(TileEntity tileEntity, UUID playerId, @Nullable EntityPlayerMP player) {
    }

    @Override
    public Icon getAltIcon() {
        if (this.item.func_190926_b()) {
            return super.getAltIcon();
        }
        return ItemIcon.getItemIcon((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)this.item, (int)1));
    }

    @Override
    public String getAltTitle() {
        return (this.item.func_190916_E() > 1 ? (this.randomBonus > 0 ? this.item.func_190916_E() + "-" + (this.item.func_190916_E() + this.randomBonus) + "x " : this.item.func_190916_E() + "x ") : "") + this.item.func_82833_r();
    }

    @Override
    public boolean addTitleInMouseOverText() {
        return !this.getTitle().equals(this.getAltTitle());
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return new WrappedIngredient((Object)this.item).tooltip();
    }

    @Override
    public String getButtonText() {
        if (this.randomBonus > 0) {
            return this.count + "-" + (this.count + this.randomBonus);
        }
        return Integer.toString(this.count);
    }
}

