/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.tile;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigNull;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.tile.TileWithTeam;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileQuestChest
extends TileWithTeam
implements IItemHandler,
IConfigCallback {
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void openGui(EntityPlayerMP player) {
        if (!player.func_70093_af()) {
            if (this.isOwner((EntityPlayer)player)) {
                player.func_145747_a(StringUtils.color((ITextComponent)new TextComponentTranslation("tile.ftbquests.chest.deprecated", new Object[0]), (TextFormatting)TextFormatting.RED));
            }
            return;
        }
        boolean editor = FTBQuests.canEdit((EntityPlayer)player);
        ConfigGroup group0 = ConfigGroup.newGroup((String)"tile");
        group0.setDisplayName((ITextComponent)new TextComponentTranslation("tile.ftbquests.chest.name", new Object[0]));
        ConfigGroup group = group0.getGroup("ftbquests.chest");
        group.add("team", (ConfigValue)this.createTeamConfig(), (ConfigValue)ConfigNull.INSTANCE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.team", new Object[0])).setCanEdit(editor);
        if (editor) {
            group.addBool("indestructible", () -> this.indestructible, v -> {
                this.indestructible = v;
            }, false).setDisplayName((ITextComponent)new TextComponentTranslation("tile.ftbquests.screen.indestructible", new Object[0]));
        }
        FTBLibAPI.editServerConfig((EntityPlayerMP)player, (ConfigGroup)group0, (IConfigCallback)this);
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.insert(stack, simulate, null);
    }

    public ItemStack insert(ItemStack stack, boolean simulate, @Nullable EntityPlayer player) {
        QuestData data;
        QuestFile file = FTBQuests.PROXY.getQuestFile(this.field_145850_b);
        QuestData questData = data = file == null ? null : file.getData(this.team);
        if (data != null) {
            for (Chapter chapter : file.chapters) {
                for (Quest quest : chapter.quests) {
                    for (Task task : quest.tasks) {
                        if (!task.canInsertItem() || task.isComplete(data) || !task.quest.canStartTasks(data) || !(stack = data.getTaskData(task).insertItem(stack, false, simulate, player)).func_190926_b()) continue;
                        return ItemStack.field_190927_a;
                    }
                }
            }
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void func_70296_d() {
        this.sendDirtyUpdate();
    }

    public void onConfigSaved(ConfigGroup group, ICommandSender sender) {
        this.func_70296_d();
    }
}

