/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.itemfilters.item;

import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class ItemStackSerializer {
    public static ItemStack parseItemThrowingException(String input) throws Exception {
        if ((input = input.trim()).isEmpty() || input.equals("-") || input.equals("minecraft:air")) {
            return ItemStack.field_190927_a;
        }
        if (input.startsWith("{")) {
            NBTTagCompound nbt = JsonToNBT.func_180713_a((String)input);
            if (nbt.func_74771_c("Count") <= 0) {
                nbt.func_74774_a("Count", (byte)1);
            }
            return new ItemStack(nbt);
        }
        String[] s1 = input.split(" ", 4);
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(s1[0]));
        if (item == null) {
            throw new NullPointerException("Unknown item: " + s1[0]);
        }
        if (item == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        int stackSize = 1;
        int meta = 0;
        if (s1.length >= 2) {
            stackSize = MathHelper.func_82715_a((String)s1[1], (int)1);
        }
        if (s1.length >= 3) {
            meta = s1[2].charAt(0) == '*' ? Short.MAX_VALUE : MathHelper.func_82715_a((String)s1[2], (int)0);
        }
        ItemStack itemstack = new ItemStack(item, stackSize, meta);
        if (s1.length >= 4) {
            itemstack.func_77982_d(JsonToNBT.func_180713_a((String)s1[3]));
        }
        return itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack;
    }

    public static ItemStack parseItem(String input) {
        try {
            return ItemStackSerializer.parseItemThrowingException(input);
        }
        catch (Exception ex) {
            return ItemStack.field_190927_a;
        }
    }

    public static String toString(ItemStack stack) {
        if (stack.func_190926_b()) {
            return "minecraft:air";
        }
        NBTTagCompound nbt = stack.serializeNBT();
        if (nbt.func_74764_b("ForgeCaps")) {
            return nbt.toString();
        }
        StringBuilder builder = new StringBuilder(String.valueOf(Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())));
        int count = stack.func_190916_E();
        int meta = stack.func_77960_j();
        NBTTagCompound tag = stack.func_77978_p();
        if (count > 1 || meta != 0 || tag != null) {
            builder.append(' ');
            builder.append(count);
        }
        if (meta != 0 || tag != null) {
            builder.append(' ');
            builder.append(meta);
        }
        if (tag != null) {
            builder.append(' ');
            builder.append(tag);
        }
        return builder.toString();
    }

    public static NBTBase write(ItemStack stack, boolean forceCompound) {
        if (stack.func_190926_b()) {
            return forceCompound ? new NBTTagCompound() : new NBTTagString("");
        }
        NBTTagCompound nbt = stack.serializeNBT();
        if (!nbt.func_74764_b("ForgeCaps") && !nbt.func_74764_b("tag")) {
            if (!forceCompound) {
                return new NBTTagString(ItemStackSerializer.toString(stack));
            }
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74778_a("item", ItemStackSerializer.toString(stack));
            return nbt1;
        }
        if (nbt.func_74771_c("Count") == 1) {
            nbt.func_82580_o("Count");
        }
        if (nbt.func_74765_d("Damage") == 0) {
            nbt.func_82580_o("Damage");
        }
        return nbt;
    }

    public static ItemStack read(@Nullable NBTBase nbtBase) {
        ItemStack stack;
        if (nbtBase == null || nbtBase.func_82582_d()) {
            return ItemStack.field_190927_a;
        }
        if (nbtBase instanceof NBTTagString) {
            return ItemStackSerializer.parseItem(((NBTTagString)nbtBase).func_150285_a_());
        }
        if (!(nbtBase instanceof NBTTagCompound)) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound nbt = (NBTTagCompound)nbtBase;
        if (nbt.func_150297_b("item", 8)) {
            return ItemStackSerializer.parseItem(nbt.func_74779_i("item"));
        }
        if (!nbt.func_74764_b("Count")) {
            nbt.func_74774_a("Count", (byte)1);
        }
        return (stack = new ItemStack(nbt)).func_190926_b() ? ItemStack.field_190927_a : stack;
    }
}

