/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbultimine;

import com.feed_the_beast.mods.ftbultimine.FTBUltimineCommon;
import com.feed_the_beast.mods.ftbultimine.FTBUltimineConfig;
import com.feed_the_beast.mods.ftbultimine.FTBUltiminePlayerData;
import com.feed_the_beast.mods.ftbultimine.ItemCollection;
import com.feed_the_beast.mods.ftbultimine.hacks.CustomCheck;
import com.feed_the_beast.mods.ftbultimine.hacks.VersionHelper;
import com.feed_the_beast.mods.ftbultimine.hacks.VersionHelper10;
import com.feed_the_beast.mods.ftbultimine.hacks.VersionHelper12;
import com.feed_the_beast.mods.ftbultimine.net.FTBUltimineNet;
import com.feed_the_beast.mods.ftbultimine.net.SendShapePacket;
import com.feed_the_beast.mods.ftbultimine.shape.EscapeTunnelShape;
import com.feed_the_beast.mods.ftbultimine.shape.MiningTunnelShape;
import com.feed_the_beast.mods.ftbultimine.shape.Shape;
import com.feed_the_beast.mods.ftbultimine.shape.ShapelessShape;
import com.feed_the_beast.mods.ftbultimine.shape.SmallSquareShape;
import com.feed_the_beast.mods.ftbultimine.shape.SmallTunnelShape;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.MinecraftDummyContainer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod(modid="ftbultimine", name="FTB Ultimine", version="1.3.2", acceptableRemoteVersions="*", acceptedMinecraftVersions="*")
public class FTBUltimine {
    public static final String VERSION = "1.3.2";
    public static FTBUltimine instance;
    @SidedProxy(clientSide="com.feed_the_beast.mods.ftbultimine.client.FTBUltimineClient", serverSide="com.feed_the_beast.mods.ftbultimine.FTBUltimineCommon")
    public static FTBUltimineCommon proxy;
    public static CustomCheck customCheck;
    private Map<UUID, FTBUltiminePlayerData> cachedDataMap;
    private boolean isBreakingBlock;
    private int tempBlockDroppedXp;
    private ItemCollection tempBlockDropsList;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        instance = this;
        FTBUltimineNet.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        Shape.register(new ShapelessShape());
        Shape.register(new SmallTunnelShape());
        Shape.register(new SmallSquareShape());
        Shape.register(new MiningTunnelShape());
        Shape.register(new EscapeTunnelShape());
        proxy.preinit();
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent event) {
        Shape.postinit();
        MinecraftDummyContainer container = Loader.instance().getMinecraftModContainer();
        int mc = Integer.parseInt(container.getVersion().split("\\.")[1]);
        System.out.println("MC Version: " + mc);
        if (mc <= 10) {
            this.setVersionHelper10();
        } else {
            this.setVersionHelper12();
        }
    }

    private void setVersionHelper10() {
        System.out.println("FTB Ultimine is using 1.10 helper");
        VersionHelper.instance = new VersionHelper10();
    }

    private void setVersionHelper12() {
        System.out.println("FTB Ultimine is using 1.12 helper");
        VersionHelper.instance = new VersionHelper12();
    }

    public FTBUltiminePlayerData get(EntityPlayer player) {
        return this.cachedDataMap.computeIfAbsent(player.func_110124_au(), FTBUltiminePlayerData::new);
    }

    @Mod.EventHandler
    private void serverAboutToStart(FMLServerAboutToStartEvent event) {
        this.cachedDataMap = new HashMap<UUID, FTBUltiminePlayerData>();
    }

    public void setKeyPressed(EntityPlayerMP player, boolean pressed) {
        FTBUltiminePlayerData data = this.get((EntityPlayer)player);
        data.pressed = pressed;
        data.clearCache();
    }

    public void modeChanged(EntityPlayerMP player, boolean next) {
        FTBUltiminePlayerData data = this.get((EntityPlayer)player);
        data.clearCache();
        data.shape = next ? data.shape.next : data.shape.prev;
        VersionHelper.instance.statusMessage((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("ftbultimine.shape_changed", new Object[]{new TextComponentTranslation("ftbultimine.shape." + data.shape.getName(), new Object[0])}));
        FTBUltimineNet.MAIN.sendTo((IMessage)new SendShapePacket(data.shape.getName()), player);
    }

    @Nullable
    public static RayTraceResult rayTrace(EntityPlayer player) {
        double distance = VersionHelper.instance.getReachDistance(player);
        double dist = player.func_184812_l_() ? distance : distance - 0.5;
        Vec3d start = player.func_174824_e(1.0f);
        Vec3d look = player.func_70676_i(1.0f);
        Vec3d end = start.func_72441_c(look.field_72450_a * dist, look.field_72448_b * dist, look.field_72449_c * dist);
        return player.field_70170_p.func_72933_a(start, end);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void blockBroken(BlockEvent.BreakEvent event) {
        if (this.isBreakingBlock) {
            return;
        }
        if (!(event.getPlayer() instanceof EntityPlayerMP) || event.getPlayer() instanceof FakePlayer || event.getPlayer().func_110124_au() == null) {
            return;
        }
        if (event.getPlayer().func_71024_bL().func_75116_a() <= 0 && !event.getPlayer().func_184812_l_()) {
            return;
        }
        ItemStack heldItem = event.getPlayer().func_184614_ca();
        if (VersionHelper.instance.isEmpty(heldItem) ? !FTBUltimineConfig.allowHand : FTBUltimineConfig.toolBlacklist(heldItem.func_77973_b())) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getPlayer();
        FTBUltiminePlayerData data = this.get((EntityPlayer)player);
        if (!data.pressed || !FTBUltimineConfig.breakWhitelist(event.getState().func_177230_c())) {
            return;
        }
        int maxBlocks = FTBUltimineConfig.maxBlocks;
        if (customCheck != null && (maxBlocks = customCheck.getUltiminedBlocks(player, heldItem, maxBlocks)) <= 0) {
            return;
        }
        RayTraceResult result = FTBUltimine.rayTrace((EntityPlayer)player);
        if (result == null || result.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        data.clearCache();
        data.updateBlocks(player, event.getPos(), result.field_178784_b, maxBlocks);
        if (data.cachedBlocks == null || data.cachedBlocks.isEmpty()) {
            return;
        }
        this.isBreakingBlock = true;
        this.tempBlockDropsList = new ItemCollection();
        this.tempBlockDroppedXp = 0;
        boolean hadItem = !VersionHelper.instance.isEmpty(player.func_184614_ca());
        for (BlockPos blockPos : data.cachedBlocks) {
            if (!player.field_71134_c.func_180237_b(blockPos)) continue;
            if (!player.func_184812_l_()) {
                player.func_71020_j((float)(FTBUltimineConfig.exhaustionPerBlock * 0.005));
                if (player.func_71024_bL().func_75116_a() <= 0) break;
            }
            if (!hadItem || !VersionHelper.instance.isEmpty(player.func_184614_ca())) continue;
            break;
        }
        this.isBreakingBlock = false;
        List<ItemStack> c = this.tempBlockDropsList.collect();
        if (FTBUltimineConfig.dropItems == 2) {
            for (ItemStack stack : c) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
            }
            if (this.tempBlockDroppedXp > 0) {
                player.func_71023_q(this.tempBlockDroppedXp);
            }
        } else {
            BlockPos blockPos = FTBUltimineConfig.dropItems == 0 ? event.getPos() : player.func_180425_c().func_177984_a();
            for (ItemStack stack : c) {
                Block.func_180635_a((World)player.field_70170_p, (BlockPos)blockPos, (ItemStack)stack);
            }
            if (this.tempBlockDroppedXp > 0) {
                player.field_70170_p.func_72838_d((Entity)new EntityXPOrb(player.field_70170_p, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, this.tempBlockDroppedXp));
            }
        }
        data.clearCache();
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            FTBUltiminePlayerData data = this.get(event.player);
            FTBUltimineNet.MAIN.sendTo((IMessage)new SendShapePacket(data.shape.getName()), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void entityJoinedWorld(EntityJoinWorldEvent event) {
        if (this.isBreakingBlock && event.getEntity() instanceof EntityItem) {
            this.tempBlockDropsList.add(((EntityItem)event.getEntity()).func_92059_d());
            event.setCanceled(true);
        } else if (this.isBreakingBlock && event.getEntity() instanceof EntityXPOrb) {
            this.tempBlockDroppedXp += ((EntityXPOrb)event.getEntity()).func_70526_d();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (FTBUltimineConfig.twerkChance > 0.0 && event.phase == TickEvent.Phase.END && event.player instanceof EntityPlayerMP) {
            FTBUltiminePlayerData data = this.get(event.player);
            boolean sneaking = event.player.func_70093_af();
            if (data.prevSneaking != sneaking) {
                data.prevSneaking = sneaking;
                if (sneaking) {
                    int x0 = MathHelper.func_76128_c((double)event.player.field_70165_t);
                    int y0 = MathHelper.func_76128_c((double)event.player.field_70163_u);
                    int z0 = MathHelper.func_76128_c((double)event.player.field_70161_v);
                    for (int z = -FTBUltimineConfig.twerkRadius; z <= FTBUltimineConfig.twerkRadius; ++z) {
                        for (int x = -FTBUltimineConfig.twerkRadius; x <= FTBUltimineConfig.twerkRadius; ++x) {
                            for (int y = -1; y <= 1; ++y) {
                                BlockPos pos = new BlockPos(x0 + x, y0 + y, z0 + z);
                                IBlockState state = event.player.field_70170_p.func_180495_p(pos);
                                if (!FTBUltimineConfig.twerkWhitelist(state.func_177230_c()) || !((double)event.player.field_70170_p.field_73012_v.nextFloat() <= FTBUltimineConfig.twerkChance)) continue;
                                ((IGrowable)state.func_177230_c()).func_176474_b(event.player.field_70170_p, event.player.field_70170_p.field_73012_v, pos, state);
                                event.player.field_70170_p.func_175718_b(2005, pos, 0);
                            }
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("ftbultimine")) {
            ConfigManager.sync((String)"ftbultimine", (Config.Type)Config.Type.INSTANCE);
        }
    }

    static {
        customCheck = null;
    }
}

