/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.googlyeyes.common.core;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import me.ichun.mods.googlyeyes.common.GooglyEyes;
import me.ichun.mods.googlyeyes.common.layer.LayerGooglyEyes;
import me.ichun.mods.googlyeyes.common.model.ModelRendererDragonHook;
import me.ichun.mods.googlyeyes.common.tracker.GooglyTracker;
import me.ichun.mods.ichunutil.common.head.HeadInfo;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    protected WeakHashMap<LivingEntity, GooglyTracker> trackers = new WeakHashMap();

    @SubscribeEvent
    public void onWorldTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71441_e != null && !Minecraft.func_71410_x().func_147113_T()) {
            Iterator<Map.Entry<LivingEntity, GooglyTracker>> ite = this.trackers.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<LivingEntity, GooglyTracker> e = ite.next();
                GooglyTracker tracker = e.getValue();
                if (iChunUtil.eventHandlerClient.ticks - tracker.lastUpdateRequest > 10) {
                    ite.remove();
                    continue;
                }
                tracker.update();
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().func_201670_d()) {
            Iterator<Map.Entry<LivingEntity, GooglyTracker>> ite = this.trackers.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<LivingEntity, GooglyTracker> e = ite.next();
                GooglyTracker tracker = e.getValue();
                if (tracker.parent.func_130014_f_() != event.getWorld()) continue;
                ite.remove();
            }
        }
    }

    public GooglyTracker getGooglyTracker(LivingEntity living, HeadInfo<?> helper) {
        GooglyTracker tracker = this.trackers.get(living);
        if (tracker == null) {
            tracker = new GooglyTracker(living, helper);
            this.trackers.put(living, tracker);
        }
        return tracker;
    }

    public void addLayers() {
        LayerGooglyEyes layerGooglyEyes = new LayerGooglyEyes();
        HashSet addedRenderers = new HashSet();
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        if (!GooglyEyes.config.disabledGoogly.contains("minecraft:player") && !GooglyEyes.config.disabledGoogly.contains("player")) {
            Map skinMap = renderManager.getSkinMap();
            for (Map.Entry e : skinMap.entrySet()) {
                ((PlayerRenderer)e.getValue()).func_177094_a(layerGooglyEyes);
                addedRenderers.add(e.getValue());
            }
        }
        renderManager.field_78729_o.forEach((entityType, entityRenderer) -> {
            if (addedRenderers.contains(entityRenderer)) {
                return;
            }
            ResourceLocation rl = entityType.getRegistryName();
            for (String s : GooglyEyes.config.disabledGoogly) {
                ResourceLocation disabled = new ResourceLocation(s);
                if (!disabled.equals((Object)rl)) continue;
                return;
            }
            if (entityRenderer instanceof LivingRenderer) {
                LivingRenderer renderer = (LivingRenderer)entityRenderer;
                renderer.func_177094_a((LayerRenderer)layerGooglyEyes);
            } else if (entityRenderer instanceof EnderDragonRenderer) {
                EnderDragonRenderer dragonRenderer = (EnderDragonRenderer)entityRenderer;
                dragonRenderer.field_229058_m_.field_78221_a.func_78792_a((ModelRenderer)new ModelRendererDragonHook(dragonRenderer.field_229058_m_));
            }
        });
    }
}

