/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.googlyeyes.common.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.ichun.mods.googlyeyes.common.GooglyEyes;
import me.ichun.mods.googlyeyes.common.model.ModelGooglyEye;
import me.ichun.mods.googlyeyes.common.tracker.GooglyTracker;
import me.ichun.mods.ichunutil.common.head.HeadHandler;
import me.ichun.mods.ichunutil.common.head.HeadInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class ModelRendererDragonHook
extends ModelRenderer {
    private static final ResourceLocation TEX_GOOGLY_EYE = new ResourceLocation("googlyeyes", "textures/model/modelgooglyeye.png");
    private static final RenderType RENDER_TYPE = RenderType.func_228638_b_((ResourceLocation)TEX_GOOGLY_EYE);
    private static final RenderType RENDER_TYPE_EYES = RenderType.func_228652_i_((ResourceLocation)TEX_GOOGLY_EYE);
    private static final RenderType RENDER_TYPE_RESET = RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("textures/entity/enderdragon/dragon_eyes.png"));
    private final ModelGooglyEye modelGooglyEye = new ModelGooglyEye();
    public EnderDragonRenderer.EnderDragonModel parentModel;
    public int renderCount;
    public float lastPartialTick;

    public ModelRendererDragonHook(EnderDragonRenderer.EnderDragonModel model) {
        super((Model)model);
        this.parentModel = model;
    }

    public void func_228309_a_(MatrixStack stack, IVertexBuilder bufferInUnused, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        boolean render;
        if (this.parentModel.field_229064_A_ == null) {
            return;
        }
        if (this.lastPartialTick != this.parentModel.field_78223_m) {
            this.lastPartialTick = this.parentModel.field_78223_m;
            this.renderCount = 0;
        }
        ++this.renderCount;
        boolean bl = render = this.renderCount == 3;
        if (this.renderCount == 2 && this.parentModel.field_229064_A_.field_70995_bG <= 0) {
            render = true;
        }
        if (!render) {
            return;
        }
        HeadInfo helper = HeadHandler.getHelper(this.parentModel.field_229064_A_.getClass());
        if (helper == null || helper.noFaceInfo.booleanValue()) {
            return;
        }
        helper.headModel = new ModelRenderer[]{this.parentModel.field_78221_a};
        GooglyTracker tracker = GooglyEyes.eventHandler.getGooglyTracker((LivingEntity)this.parentModel.field_229064_A_, helper);
        tracker.setLastUpdateRequest();
        if (!tracker.shouldRender()) {
            return;
        }
        tracker.requireUpdate();
        EnderDragonEntity living = this.parentModel.field_229064_A_;
        int eyeCount = helper.getEyeCount((LivingEntity)living);
        for (int i = 0; i < eyeCount; ++i) {
            float eyeScale = helper.getEyeScale((LivingEntity)living, stack, this.lastPartialTick, i);
            if (eyeScale <= 0.0f) continue;
            stack.func_227860_a_();
            float[] eyes = helper.getEyeOffsetFromJoint((LivingEntity)living, stack, this.lastPartialTick, i);
            stack.func_227861_a_((double)(-(eyes[0] + helper.getEyeSideOffset((LivingEntity)living, stack, this.lastPartialTick, i))), (double)(-eyes[1]), (double)(-eyes[2]));
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(helper.getEyeRotation((LivingEntity)living, stack, this.lastPartialTick, i)));
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(helper.getEyeTopRotation((LivingEntity)living, stack, this.lastPartialTick, i)));
            stack.func_227862_a_(eyeScale, eyeScale, eyeScale * 0.5f);
            IRenderTypeBuffer.Impl bufferIn = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            IVertexBuilder buffer = bufferIn.getBuffer(RENDER_TYPE);
            int overlay = LivingRenderer.func_229117_c_((LivingEntity)living, (float)0.0f);
            float[] irisColours = helper.getIrisColours((LivingEntity)living, stack, this.lastPartialTick, i);
            this.modelGooglyEye.renderIris(stack, buffer, packedLightIn, overlay, irisColours[0], irisColours[1], irisColours[2], 1.0f);
            float[] pupilColours = helper.getPupilColours((LivingEntity)living, stack, this.lastPartialTick, i);
            float pupilScale = helper.getPupilScale((LivingEntity)living, stack, this.lastPartialTick, i);
            stack.func_227860_a_();
            stack.func_227862_a_(pupilScale, pupilScale, 1.0f);
            this.modelGooglyEye.movePupil(tracker.eyes[i].prevDeltaX + (tracker.eyes[i].deltaX - tracker.eyes[i].prevDeltaX) * this.lastPartialTick, tracker.eyes[i].prevDeltaY + (tracker.eyes[i].deltaY - tracker.eyes[i].prevDeltaY) * this.lastPartialTick, pupilScale);
            this.modelGooglyEye.renderPupil(stack, buffer, packedLightIn, overlay, pupilColours[0], pupilColours[1], pupilColours[2], 1.0f);
            stack.func_227865_b_();
            if (helper.doesEyeGlow((LivingEntity)living, i)) {
                buffer = bufferIn.getBuffer(RENDER_TYPE_EYES);
                this.modelGooglyEye.renderIris(stack, buffer, packedLightIn, overlay, irisColours[0], irisColours[1], irisColours[2], 1.0f);
                stack.func_227860_a_();
                stack.func_227862_a_(pupilScale, pupilScale, 1.0f);
                this.modelGooglyEye.renderPupil(stack, buffer, packedLightIn, overlay, pupilColours[0], pupilColours[1], pupilColours[2], 1.0f);
                stack.func_227865_b_();
            }
            bufferIn.getBuffer(RENDER_TYPE_RESET);
            stack.func_227865_b_();
        }
    }
}

