/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.googlyeyes.common.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.ichun.mods.googlyeyes.common.GooglyEyes;
import me.ichun.mods.googlyeyes.common.model.ModelGooglyEye;
import me.ichun.mods.googlyeyes.common.tracker.GooglyTracker;
import me.ichun.mods.ichunutil.client.head.HeadBase;
import me.ichun.mods.ichunutil.client.head.HeadHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public class LayerGooglyEyes<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    private static final ResourceLocation TEX_GOOGLY_EYE = new ResourceLocation("googlyeyes", "textures/model/modelgooglyeye.png");
    private static final RenderType RENDER_TYPE = RenderType.func_228638_b_((ResourceLocation)TEX_GOOGLY_EYE);
    private static final RenderType RENDER_TYPE_EYES = RenderType.func_228652_i_((ResourceLocation)TEX_GOOGLY_EYE);
    private final ModelGooglyEye modelGooglyEye = new ModelGooglyEye();

    public LayerGooglyEyes() {
        super((IEntityRenderer)Minecraft.func_71410_x().func_175598_ae().field_178637_m);
    }

    public void render(MatrixStack stack, IRenderTypeBuffer bufferIn, int packedLightIn, LivingEntity living, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        HeadBase helper = HeadHandler.getHelperBase(living.getClass());
        if (helper != null) {
            EntityRenderer render = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)living);
            if (!(render instanceof LivingRenderer)) {
                return;
            }
            LivingRenderer renderer = (LivingRenderer)render;
            helper.setHeadModel(renderer);
            if (helper.headModel == null) {
                return;
            }
            GooglyTracker tracker = GooglyEyes.eventHandler.getGooglyTracker(living, helper);
            if (!tracker.shouldRender()) {
                return;
            }
            tracker.requireUpdate();
            int eyeCount = helper.getEyeCount(living);
            for (int i = 0; i < eyeCount; ++i) {
                float eyeScale;
                if (living.func_82150_aj() && helper.affectedByInvisibility(living, i) || (eyeScale = helper.getEyeScale(living, stack, partialTicks, i) + helper.maxEyeSizeGrowth(living, i)) <= 0.0f) continue;
                stack.func_227860_a_();
                helper.preChildEntHeadRenderCalls(living, stack, renderer);
                float[] joint = helper.getHeadJointOffset(living, stack, partialTicks, i);
                stack.func_227861_a_((double)(-joint[0]), (double)(-joint[1]), (double)(-joint[2]));
                stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(helper.getHeadRoll(living, stack, partialTicks, i)));
                stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(helper.getHeadYaw(living, stack, partialTicks, i)));
                stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(helper.getHeadPitch(living, stack, partialTicks, i)));
                float[] eyes = helper.getEyeOffsetFromJoint(living, stack, partialTicks, i);
                stack.func_227861_a_((double)(-(eyes[0] + helper.getEyeSideOffset(living, stack, partialTicks, i))), (double)(-eyes[1]), (double)(-eyes[2]));
                stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(helper.getEyeRotation(living, stack, partialTicks, i)));
                stack.func_227862_a_(eyeScale, eyeScale, eyeScale * 0.5f);
                IVertexBuilder buffer = bufferIn.getBuffer(RENDER_TYPE);
                int overlay = LivingRenderer.func_229117_c_((LivingEntity)living, (float)0.0f);
                float[] irisColours = helper.getIrisColours(living, stack, partialTicks, i);
                this.modelGooglyEye.renderIris(stack, buffer, packedLightIn, overlay, irisColours[0], irisColours[1], irisColours[2], 1.0f);
                float[] pupilColours = helper.getPupilColours(living, stack, partialTicks, i);
                float pupilScale = helper.getPupilScale(living, stack, partialTicks, i);
                stack.func_227860_a_();
                stack.func_227862_a_(pupilScale, pupilScale, 1.0f);
                this.modelGooglyEye.movePupil(tracker.eyes[i].prevDeltaX + (tracker.eyes[i].deltaX - tracker.eyes[i].prevDeltaX) * partialTicks, tracker.eyes[i].prevDeltaY + (tracker.eyes[i].deltaY - tracker.eyes[i].prevDeltaY) * partialTicks, pupilScale);
                this.modelGooglyEye.renderPupil(stack, buffer, packedLightIn, overlay, pupilColours[0], pupilColours[1], pupilColours[2], 1.0f);
                stack.func_227865_b_();
                if (helper.doesEyeGlow(living, i)) {
                    buffer = bufferIn.getBuffer(RENDER_TYPE_EYES);
                    this.modelGooglyEye.renderIris(stack, buffer, packedLightIn, overlay, irisColours[0], irisColours[1], irisColours[2], 1.0f);
                    stack.func_227860_a_();
                    stack.func_227862_a_(pupilScale, pupilScale, 1.0f);
                    this.modelGooglyEye.renderPupil(stack, buffer, packedLightIn, overlay, pupilColours[0], pupilColours[1], pupilColours[2], 1.0f);
                    stack.func_227865_b_();
                }
                stack.func_227865_b_();
            }
        }
    }
}

