/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.googlyeyes.common.tracker;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import javax.annotation.Nonnull;
import me.ichun.mods.googlyeyes.common.GooglyEyes;
import me.ichun.mods.ichunutil.client.head.HeadBase;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;

public class GooglyTracker {
    public final LivingEntity parent;
    public final HeadBase helper;
    public final Random rand;
    public final float renderChance;
    public boolean shouldUpdate = true;
    public int lastUpdateRequest;
    public double motionX;
    public double motionY;
    public double motionZ;
    public EyeInfo[] eyes;

    public GooglyTracker(@Nonnull LivingEntity parent, @Nonnull HeadBase helper) {
        this.parent = parent;
        this.helper = helper;
        this.rand = new Random(Math.abs(parent.hashCode()) * 8134);
        this.renderChance = this.rand.nextFloat();
        this.eyes = new EyeInfo[helper.getEyeCount(parent)];
        for (int i = 0; i < this.eyes.length; ++i) {
            this.eyes[i] = new EyeInfo();
        }
        this.update();
    }

    public void update() {
        if (!this.shouldUpdate || !this.shouldRender()) {
            return;
        }
        this.shouldUpdate = false;
        this.motionX = this.parent.func_226277_ct_() - this.parent.field_70169_q;
        this.motionY = this.parent.func_226278_cu_() - this.parent.field_70167_r;
        this.motionZ = this.parent.func_226281_cx_() - this.parent.field_70166_s;
        for (int i = 0; i < this.eyes.length; ++i) {
            this.eyes[i].update(i, this, this.motionX, this.motionY, this.motionZ);
        }
    }

    public void requireUpdate() {
        this.shouldUpdate = true;
        this.lastUpdateRequest = iChunUtil.eventHandlerClient.ticks;
    }

    public boolean shouldRender() {
        String name = this.parent.func_200200_C_().func_150261_e();
        for (String s : GooglyEyes.config.nameOverride) {
            if (!s.equals(name)) continue;
            return true;
        }
        if (GooglyEyes.config.entityOverrideChanceParsed.containsKey(this.parent.func_200600_R().getRegistryName())) {
            return this.renderChance < (float)GooglyEyes.config.entityOverrideChanceParsed.get(this.parent.func_200600_R().getRegistryName()).intValue() / 100.0f;
        }
        return this.renderChance < (float)GooglyEyes.config.googlyEyeChance / 100.0f;
    }

    public class EyeInfo {
        public float prevRotationYaw;
        public float rotationYaw;
        public float prevRotationPitch;
        public float rotationPitch;
        public float prevRotationRoll;
        public float rotationRoll;
        public float prevDeltaX;
        public float prevDeltaY = -1.0f;
        public float deltaX;
        public float deltaY = -1.0f;
        public float momentumX;
        public float momentumY;

        public void update(int eye, GooglyTracker parent, double motionX, double motionY, double motionZ) {
            float randFloat;
            float newMo;
            this.prevRotationYaw = this.rotationYaw;
            this.prevRotationPitch = this.rotationPitch;
            this.prevRotationRoll = this.rotationRoll;
            MatrixStack stack = new MatrixStack();
            this.rotationYaw = GooglyTracker.this.helper.getHeadYaw(parent.parent, stack, 1.0f, eye);
            this.rotationPitch = GooglyTracker.this.helper.getHeadPitch(parent.parent, stack, 1.0f, eye);
            this.rotationRoll = GooglyTracker.this.helper.getHeadRoll(parent.parent, stack, 1.0f, eye);
            this.prevDeltaX = this.deltaX;
            this.prevDeltaY = this.deltaY;
            float yawDiff = this.rotationYaw - this.prevRotationYaw;
            float pitchDiff = this.rotationPitch - this.prevRotationPitch;
            float rollDiff = this.rotationRoll - this.prevRotationRoll;
            this.momentumY = (float)((double)this.momentumY + (motionY * 1.5 + (motionX + motionZ) * GooglyTracker.this.rand.nextGaussian() * 0.75 + (double)(pitchDiff / 45.0f) + (double)(yawDiff / 180.0f) + (double)rollDiff * GooglyTracker.this.rand.nextGaussian() * (double)0.05f));
            this.momentumX = (float)((double)this.momentumX - ((motionX + motionZ) * GooglyTracker.this.rand.nextGaussian() * (double)0.4f + (double)(yawDiff / 45.0f) + (double)rollDiff * GooglyTracker.this.rand.nextGaussian() * (double)0.05f));
            float momentumLoss = 0.9f;
            float newDeltaX = this.deltaX + this.momentumX;
            float newDeltaY = this.deltaY + this.momentumY;
            if (newDeltaX < -1.0f || newDeltaX > 1.0f) {
                newMo = this.momentumX * -momentumLoss;
                randFloat = 0.8f + GooglyTracker.this.rand.nextFloat() * 0.2f;
                this.momentumX = newMo * randFloat;
                this.momentumY += newMo * randFloat * (GooglyTracker.this.rand.nextFloat() > 0.5f ? 1.0f : -1.0f);
            }
            if (newDeltaY < -1.0f || newDeltaY > 1.0f) {
                newMo = this.momentumY * -momentumLoss;
                randFloat = 0.8f + GooglyTracker.this.rand.nextFloat() * 0.2f;
                this.momentumY = newMo * randFloat;
                this.momentumX += newMo * (1.0f - randFloat) * (GooglyTracker.this.rand.nextFloat() > 0.5f ? 1.0f : -1.0f);
            } else {
                this.momentumY -= MathHelper.func_76131_a((float)(1.0f + this.deltaY), (float)0.0f, (float)0.1999f);
            }
            this.momentumX *= 0.95f;
            this.deltaX *= 0.95f;
            if (Math.abs(this.momentumX) < 0.03f) {
                this.momentumX = 0.0f;
            }
            if (Math.abs(this.deltaX) < 0.03f) {
                this.deltaX = 0.0f;
            }
            float maxMomentum = 1.3f;
            this.momentumX = MathHelper.func_76131_a((float)this.momentumX, (float)(-maxMomentum), (float)maxMomentum);
            this.momentumY = MathHelper.func_76131_a((float)this.momentumY, (float)(-maxMomentum), (float)maxMomentum);
            this.deltaX += this.momentumX;
            this.deltaY += this.momentumY;
            this.deltaX = MathHelper.func_76131_a((float)this.deltaX, (float)-1.0f, (float)1.0f);
            this.deltaY = MathHelper.func_76131_a((float)this.deltaY, (float)-1.0f, (float)1.0f);
        }
    }
}

