/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.block;

import com.silvaniastudios.graffiti.client.gui.GuiDisplayArt;
import com.silvaniastudios.graffiti.drawables.CompleteGraffitiObject;
import com.silvaniastudios.graffiti.items.BasicPenItem;
import com.silvaniastudios.graffiti.items.CanvasEditorItem;
import com.silvaniastudios.graffiti.items.DrawingItem;
import com.silvaniastudios.graffiti.tileentity.GraffitiTileEntityTypes;
import com.silvaniastudios.graffiti.tileentity.TileEntityGraffiti;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GraffitiBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;

    public GraffitiBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return GraffitiTileEntityTypes.GRAFFITI.func_200968_a();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = VoxelShapes.func_197880_a();
        if (worldIn.func_175625_s(pos) instanceof TileEntityGraffiti) {
            TileEntityGraffiti te = (TileEntityGraffiti)worldIn.func_175625_s(pos);
            if (context.getEntity() != null && context.getEntity() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)context.getEntity();
                for (Direction dir : Direction.values()) {
                    if (te.getGraffitiForFace(dir) == null || player.func_184172_bi().func_176734_d() == dir) continue;
                    VoxelShape faceShape = VoxelShapes.func_197880_a();
                    double offset = te.getGraffitiForFace(dir).getAlignment() * 16.0;
                    BlockState stateBehind = te.func_145831_w().func_180495_p(te.func_174877_v().func_177972_a(dir));
                    VoxelShape voxelShape = stateBehind.func_196952_d((IBlockReader)te.func_145831_w(), te.func_174877_v().func_177972_a(dir));
                    if (te.getGraffitiForFace(dir).isOffsetIntoBlock() && !voxelShape.func_197766_b()) {
                        AxisAlignedBB shapeBehind = voxelShape.func_197752_a();
                        double minX = 0.0;
                        double minY = 0.0;
                        double minZ = 0.0;
                        double maxX = 1.0;
                        double maxY = 1.0;
                        double maxZ = 1.0;
                        if (dir == Direction.NORTH) {
                            minX = this.constrain(shapeBehind.field_72340_a * 16.0);
                            minY = this.constrain(shapeBehind.field_72338_b * 16.0);
                            minZ = shapeBehind.field_72334_f * 16.0 - 16.0;
                            maxX = this.constrain(shapeBehind.field_72336_d * 16.0);
                            maxY = this.constrain(shapeBehind.field_72337_e * 16.0);
                            maxZ = minZ + offset;
                        }
                        if (dir == Direction.SOUTH) {
                            minX = this.constrain(shapeBehind.field_72340_a * 16.0);
                            minY = this.constrain(shapeBehind.field_72338_b * 16.0);
                            minZ = shapeBehind.field_72339_c * 16.0 + 16.0;
                            maxX = this.constrain(shapeBehind.field_72336_d * 16.0);
                            maxY = this.constrain(shapeBehind.field_72337_e * 16.0);
                            maxZ = minZ + offset;
                        }
                        if (dir == Direction.EAST) {
                            minX = shapeBehind.field_72340_a * 16.0 + 16.0;
                            minY = this.constrain(shapeBehind.field_72338_b * 16.0);
                            minZ = this.constrain(shapeBehind.field_72339_c * 16.0);
                            maxX = minX - offset;
                            maxY = this.constrain(shapeBehind.field_72337_e * 16.0);
                            maxZ = this.constrain(shapeBehind.field_72334_f * 16.0);
                        }
                        if (dir == Direction.WEST) {
                            minX = shapeBehind.field_72336_d * 16.0 - 16.0;
                            minY = this.constrain(shapeBehind.field_72338_b * 16.0);
                            minZ = this.constrain(shapeBehind.field_72339_c * 16.0);
                            maxX = minX + offset;
                            maxY = this.constrain(shapeBehind.field_72337_e * 16.0);
                            maxZ = this.constrain(shapeBehind.field_72334_f * 16.0);
                        }
                        if (dir == Direction.UP) {
                            minX = this.constrain(shapeBehind.field_72340_a * 16.0);
                            minY = shapeBehind.field_72338_b * 16.0 + 16.0;
                            minZ = this.constrain(shapeBehind.field_72339_c * 16.0);
                            maxX = this.constrain(shapeBehind.field_72336_d * 16.0);
                            maxY = minY - offset;
                            maxZ = this.constrain(shapeBehind.field_72334_f * 16.0);
                        }
                        if (dir == Direction.DOWN) {
                            minX = this.constrain(shapeBehind.field_72340_a * 16.0);
                            minY = shapeBehind.field_72337_e * 16.0 - 16.0;
                            minZ = this.constrain(shapeBehind.field_72339_c * 16.0);
                            maxX = this.constrain(shapeBehind.field_72336_d * 16.0);
                            maxY = minY + offset;
                            maxZ = this.constrain(shapeBehind.field_72334_f * 16.0);
                        }
                        faceShape = Block.func_208617_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
                    } else {
                        if (dir == Direction.NORTH) {
                            faceShape = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)offset);
                        }
                        if (dir == Direction.EAST) {
                            faceShape = Block.func_208617_a((double)(16.0 - offset), (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
                        }
                        if (dir == Direction.SOUTH) {
                            faceShape = Block.func_208617_a((double)0.0, (double)0.0, (double)(16.0 - offset), (double)16.0, (double)16.0, (double)16.0);
                        }
                        if (dir == Direction.WEST) {
                            faceShape = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)offset, (double)16.0, (double)16.0);
                        }
                        if (dir == Direction.UP) {
                            faceShape = Block.func_208617_a((double)0.0, (double)(16.0 - offset), (double)0.0, (double)16.0, (double)16.0, (double)16.0);
                        }
                        if (dir == Direction.DOWN) {
                            faceShape = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)offset, (double)16.0);
                        }
                    }
                    shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)faceShape);
                }
                return shape;
            }
        }
        shape = state.func_177229_b((IProperty)FACING) == Direction.NORTH ? Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.25) : (state.func_177229_b((IProperty)FACING) == Direction.EAST ? Block.func_208617_a((double)15.75, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0) : (state.func_177229_b((IProperty)FACING) == Direction.SOUTH ? Block.func_208617_a((double)0.0, (double)0.0, (double)15.75, (double)16.0, (double)16.0, (double)16.0) : (state.func_177229_b((IProperty)FACING) == Direction.WEST ? Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.25, (double)16.0, (double)16.0) : (state.func_177229_b((IProperty)FACING) == Direction.UP ? Block.func_208617_a((double)0.0, (double)15.75, (double)0.0, (double)16.0, (double)16.0, (double)16.0) : Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.25, (double)16.0)))));
        return shape;
    }

    private double constrain(double in) {
        if (in < 0.0) {
            return 0.0;
        }
        if (in > 16.0) {
            return 16.0;
        }
        return in;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntityGraffiti tile;
        CompleteGraffitiObject graffiti;
        if (player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof DrawingItem || player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof CanvasEditorItem) {
            return ActionResultType.FAIL;
        }
        Direction face = hit.func_216354_b();
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntityGraffiti && (graffiti = (tile = (TileEntityGraffiti)te).getGraffitiForFace(face)) != null) {
            int actionId = graffiti.getRightClickAction();
            if (actionId == 0) {
                BlockPos behindPos = pos.func_177972_a((Direction)state.func_177229_b((IProperty)FACING));
                BlockState behindState = worldIn.func_180495_p(behindPos);
                return behindState.func_177230_c().func_225533_a_(behindState, worldIn, behindPos, player, handIn, hit);
            }
            if (actionId == 1) {
                return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
            }
            if (worldIn.field_72995_K) {
                this.processClientActivations(graffiti, actionId);
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processClientActivations(CompleteGraffitiObject graffiti, int actionId) {
        Minecraft mc = Minecraft.func_71410_x();
        if (actionId == 2) {
            mc.func_147108_a((Screen)new GuiDisplayArt(graffiti));
        }
        if (actionId == 3) {
            mc.func_147108_a((Screen)new ConfirmOpenLinkScreen(p_213064_1_ -> {
                if (p_213064_1_) {
                    Util.func_110647_a().func_195640_a(graffiti.getUrl());
                }
                mc.func_147108_a(null);
            }, graffiti.getUrl(), true));
        }
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        Item item = player.func_184586_b(Hand.OFF_HAND).func_77973_b();
        if (item instanceof BasicPenItem) {
            BasicPenItem pen = (BasicPenItem)item;
            BlockRayTraceResult result = pen.rayTrace(worldIn, player);
            pen.onItemUseSensitive(new ItemUseContext(player, Hand.OFF_HAND, result), Hand.OFF_HAND);
        }
    }
}

