/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.silvaniastudios.graffiti.client.RenderHelper;
import com.silvaniastudios.graffiti.drawables.CompleteGraffitiObject;
import com.silvaniastudios.graffiti.drawables.TextDrawable;
import com.silvaniastudios.graffiti.tileentity.TileEntityGraffiti;
import java.awt.Color;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;

public class GraffitiRenderer
extends TileEntityRenderer<TileEntityGraffiti> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("forge:textures/white.png");

    public GraffitiRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileEntityGraffiti te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        for (Direction dir : Direction.values()) {
            if (te.getGraffitiForFace(dir) == null) continue;
            this.drawGraffitiSided(te, te.getGraffitiForFace(dir), dir, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
        }
    }

    public void drawGraffitiSided(TileEntityGraffiti te, CompleteGraffitiObject graffiti, Direction dir, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        TextDrawable text;
        BlockState stateBehind;
        VoxelShape voxelShape;
        IVertexBuilder vertexBuilderBlockQuads = buffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)TEXTURE));
        FontRenderer fontrenderer = this.field_228858_b_.func_147548_a();
        float offset = (float)graffiti.getAlignment();
        if (graffiti.isOffsetIntoBlock() && !(voxelShape = (stateBehind = te.func_145831_w().func_180495_p(te.func_174877_v().func_177972_a(dir))).func_196952_d((IBlockReader)te.func_145831_w(), te.func_174877_v().func_177972_a(dir))).func_197766_b()) {
            AxisAlignedBB shapeBehind = voxelShape.func_197752_a();
            if (dir == Direction.NORTH) {
                offset = (float)(shapeBehind.field_72334_f - 1.0 + graffiti.getAlignment());
            }
            if (dir == Direction.EAST) {
                offset = (float)(1.0 - shapeBehind.field_72340_a - 1.0 + graffiti.getAlignment());
            }
            if (dir == Direction.SOUTH) {
                offset = (float)(1.0 - shapeBehind.field_72339_c - 1.0 + graffiti.getAlignment());
            }
            if (dir == Direction.WEST) {
                offset = (float)(shapeBehind.field_72336_d - 1.0 + graffiti.getAlignment());
            }
            if (dir == Direction.UP) {
                offset = (float)(graffiti.getAlignment() - shapeBehind.field_72338_b);
            }
            if (dir == Direction.DOWN) {
                offset = (float)(graffiti.getAlignment() - (1.0 - shapeBehind.field_72337_e));
            }
        }
        if (graffiti.pixelGrid != null) {
            float p = 1.0f / (float)graffiti.pixelGrid.getSize();
            for (int i = 0; i < graffiti.pixelGrid.getSize(); ++i) {
                for (int j = 0; j < graffiti.pixelGrid.getSize(); ++j) {
                    int rgb = graffiti.pixelGrid.getPixelRGB(j, i);
                    if (rgb == 0) continue;
                    Color col = new Color(rgb);
                    RenderHelper.renderSinglePixel(dir, matrixStack, combinedLightIn, vertexBuilderBlockQuads, (float)j * p, (float)i * p, new Color(col.getRed(), col.getGreen(), col.getBlue(), graffiti.pixelGrid.getTransparency()), offset, graffiti.pixelGrid.getSize());
                }
            }
        }
        if (dir == Direction.NORTH) {
            for (int i = 0; i < graffiti.textList.size(); ++i) {
                text = graffiti.textList.get(i);
                RenderHelper.renderTextNorthSouth(text, matrixStack, fontrenderer, buffer, combinedLightIn, offset, true);
            }
        }
        if (dir == Direction.EAST) {
            for (int i = 0; i < graffiti.textList.size(); ++i) {
                text = graffiti.textList.get(i);
                RenderHelper.renderTextEastWest(text, matrixStack, fontrenderer, buffer, combinedLightIn, offset, true);
            }
        }
        if (dir == Direction.SOUTH) {
            for (int i = 0; i < graffiti.textList.size(); ++i) {
                text = graffiti.textList.get(i);
                RenderHelper.renderTextNorthSouth(text, matrixStack, fontrenderer, buffer, combinedLightIn, offset, false);
            }
        }
        if (dir == Direction.WEST) {
            for (int i = 0; i < graffiti.textList.size(); ++i) {
                text = graffiti.textList.get(i);
                RenderHelper.renderTextEastWest(text, matrixStack, fontrenderer, buffer, combinedLightIn, offset, false);
            }
        }
        if (dir == Direction.UP) {
            for (int i = 0; i < graffiti.textList.size(); ++i) {
                text = graffiti.textList.get(i);
                RenderHelper.renderTextUpDown(text, matrixStack, fontrenderer, buffer, combinedLightIn, offset, true);
            }
        }
        if (dir == Direction.DOWN) {
            for (int i = 0; i < graffiti.textList.size(); ++i) {
                text = graffiti.textList.get(i);
                RenderHelper.renderTextUpDown(text, matrixStack, fontrenderer, buffer, combinedLightIn, offset, false);
            }
        }
    }
}

