/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.silvaniastudios.graffiti.drawables.TextDrawable;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class RenderHelper {
    private static ResourceLocation rloc = new ResourceLocation("forge:white");
    private static TextureAtlasSprite tex = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(rloc);

    public static void renderSinglePixel(Direction dir, MatrixStack matrixStack, int light, IVertexBuilder buffer, float x, float y, Color col, float depth, float size) {
        float p = 1.0f / size;
        if (dir == Direction.NORTH) {
            RenderHelper.renderPlainQuad(dir, matrixStack, light, buffer, col, 1.0f - Math.abs(-1.0f + x), 1.0f - Math.abs(-(y + p)), depth, 1.0f - Math.abs(-1.0f + (x + p)), 1.0f - Math.abs(-(y + p)), depth, 1.0f - Math.abs(-1.0f + (x + p)), 1.0f - Math.abs(-y), depth, 1.0f - Math.abs(-1.0f + x), 1.0f - Math.abs(-y), depth);
        }
        if (dir == Direction.EAST) {
            RenderHelper.renderPlainQuad(dir, matrixStack, light, buffer, col, 1.0f - depth, 1.0f - Math.abs(-(y + p)), 1.0f - Math.abs(-1.0f + x), 1.0f - depth, 1.0f - Math.abs(-(y + p)), 1.0f - Math.abs(-1.0f + (x + p)), 1.0f - depth, 1.0f - Math.abs(-y), 1.0f - Math.abs(-1.0f + (x + p)), 1.0f - depth, 1.0f - Math.abs(-y), 1.0f - Math.abs(-1.0f + x));
        }
        if (dir == Direction.SOUTH) {
            RenderHelper.renderPlainQuad(dir, matrixStack, light, buffer, col, 1.0f - Math.abs(-x), 1.0f - Math.abs(-(y + p)), 1.0f - depth, 1.0f - Math.abs(-(x + p)), 1.0f - Math.abs(-(y + p)), 1.0f - depth, 1.0f - Math.abs(-(x + p)), 1.0f - Math.abs(-y), 1.0f - depth, 1.0f - Math.abs(-x), 1.0f - Math.abs(-y), 1.0f - depth);
        }
        if (dir == Direction.WEST) {
            RenderHelper.renderPlainQuad(dir, matrixStack, light, buffer, col, depth, 1.0f - Math.abs(-(y + p)), 1.0f - Math.abs(-x), depth, 1.0f - Math.abs(-(y + p)), 1.0f - Math.abs(-(x + p)), depth, 1.0f - Math.abs(-y), 1.0f - Math.abs(-(x + p)), depth, 1.0f - Math.abs(-y), 1.0f - Math.abs(-x));
        }
        if (dir == Direction.DOWN) {
            RenderHelper.renderPlainQuad(dir.func_176734_d(), matrixStack, light, buffer, col, 1.0f - Math.abs(-x), depth, 1.0f - Math.abs(-(y + p)), 1.0f - Math.abs(-(x + p)), depth, 1.0f - Math.abs(-(y + p)), 1.0f - Math.abs(-(x + p)), depth, 1.0f - Math.abs(-y), 1.0f - Math.abs(-x), depth, 1.0f - Math.abs(-y));
        }
        if (dir == Direction.UP) {
            RenderHelper.renderPlainQuad(dir.func_176734_d(), matrixStack, light, buffer, col, 1.0f - Math.abs(1.0f - x), 1.0f - depth, 1.0f - Math.abs(-(y + p)), 1.0f - Math.abs(1.0f - (x + p)), 1.0f - depth, 1.0f - Math.abs(-(y + p)), 1.0f - Math.abs(1.0f - (x + p)), 1.0f - depth, 1.0f - Math.abs(-y), 1.0f - Math.abs(1.0f - x), 1.0f - depth, 1.0f - Math.abs(-y));
        }
    }

    public static void renderPlainQuad(Direction dir, MatrixStack matrixStack, int light, IVertexBuilder buffer, Color col, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        float minU = tex.func_94209_e();
        float maxU = tex.func_94212_f();
        float minV = tex.func_94206_g();
        float maxV = tex.func_94210_h();
        Matrix4f matrixPos = matrixStack.func_227866_c_().func_227870_a_();
        Matrix3f matrixNormal = matrixStack.func_227866_c_().func_227872_b_();
        Vector3f normalVector = dir.func_229386_k_();
        buffer.func_227888_a_(matrixPos, x1, y1, z1).func_225586_a_(col.getRed(), col.getGreen(), col.getBlue(), col.getAlpha()).func_225583_a_(minU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(matrixNormal, normalVector.func_195899_a(), normalVector.func_195900_b(), normalVector.func_195902_c()).func_181675_d();
        buffer.func_227888_a_(matrixPos, x2, y2, z2).func_225586_a_(col.getRed(), col.getGreen(), col.getBlue(), col.getAlpha()).func_225583_a_(minU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(matrixNormal, normalVector.func_195899_a(), normalVector.func_195900_b(), normalVector.func_195902_c()).func_181675_d();
        buffer.func_227888_a_(matrixPos, x3, y3, z3).func_225586_a_(col.getRed(), col.getGreen(), col.getBlue(), col.getAlpha()).func_225583_a_(maxU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(matrixNormal, normalVector.func_195899_a(), normalVector.func_195900_b(), normalVector.func_195902_c()).func_181675_d();
        buffer.func_227888_a_(matrixPos, x4, y4, z4).func_225586_a_(col.getRed(), col.getGreen(), col.getBlue(), col.getAlpha()).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(matrixNormal, normalVector.func_195899_a(), normalVector.func_195900_b(), normalVector.func_195902_c()).func_181675_d();
    }

    public static void renderTextNorthSouth(TextDrawable text, MatrixStack matrixStack, FontRenderer font, IRenderTypeBuffer buffer, int combinedLightIn, float offset, boolean north) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        if (north) {
            matrixStack.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_((float)text.getRotation()));
            matrixStack.func_227861_a_(0.0, 0.0, -0.5 + (double)offset);
            matrixStack.func_227862_a_(0.015625f, -0.015625f, 0.015625f);
        } else {
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)text.getRotation()));
            matrixStack.func_227861_a_(0.0, 0.0, 0.5 - (double)offset);
            matrixStack.func_227862_a_(-0.015625f, -0.015625f, 0.015625f);
        }
        matrixStack.func_227862_a_(text.scale(), text.scale(), text.scale());
        font.func_228079_a_(text.getDrawableText(), (float)(text.xPos() - 32), (float)(Math.abs(64 - text.yPos()) - 32), text.getCol(), false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, combinedLightIn);
        matrixStack.func_227865_b_();
    }

    public static void renderTextEastWest(TextDrawable text, MatrixStack matrixStack, FontRenderer font, IRenderTypeBuffer buffer, int combinedLightIn, float offset, boolean east) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(90.0f));
        if (east) {
            matrixStack.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_((float)text.getRotation()));
            matrixStack.func_227861_a_(0.0, 0.0, -0.5 + (double)offset);
            matrixStack.func_227862_a_(0.015625f, -0.015625f, 0.015625f);
        } else {
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)text.getRotation()));
            matrixStack.func_227861_a_(0.0, 0.0, 0.5 - (double)offset);
            matrixStack.func_227862_a_(-0.015625f, -0.015625f, 0.015625f);
        }
        matrixStack.func_227862_a_(text.scale(), text.scale(), text.scale());
        font.func_228079_a_(text.getDrawableText(), (float)(text.xPos() - 32), (float)(Math.abs(64 - text.yPos()) - 32), text.getCol(), false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, combinedLightIn);
        matrixStack.func_227865_b_();
    }

    public static void renderTextUpDown(TextDrawable text, MatrixStack matrixStack, FontRenderer font, IRenderTypeBuffer buffer, int combinedLightIn, float offset, boolean up) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(90.0f));
        if (up) {
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)text.getRotation()));
            matrixStack.func_227861_a_(0.0, 0.0, 0.5 - (double)offset);
            matrixStack.func_227862_a_(-0.015625f, -0.015625f, 0.015625f);
        } else {
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)text.getRotation()));
            matrixStack.func_227861_a_(0.0, 0.0, -0.5 + (double)offset);
            matrixStack.func_227862_a_(0.015625f, -0.015625f, 0.015625f);
        }
        matrixStack.func_227862_a_(text.scale(), text.scale(), text.scale());
        font.func_228079_a_(text.getDrawableText(), (float)(text.xPos() - 32), (float)(Math.abs(64 - text.yPos()) - 32), text.getCol(), false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, combinedLightIn);
        matrixStack.func_227865_b_();
    }
}

