/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.client.gui;

import com.silvaniastudios.graffiti.drawables.CompleteGraffitiObject;
import com.silvaniastudios.graffiti.drawables.PixelGridDrawable;
import com.silvaniastudios.graffiti.drawables.TextDrawable;
import com.silvaniastudios.graffiti.tileentity.ContainerGraffiti;
import com.silvaniastudios.graffiti.tileentity.TileEntityGraffiti;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.opengl.GL11;

public class GuiCanvasEditorBase
extends ContainerScreen<ContainerGraffiti> {
    protected TileEntityGraffiti tileEntity;
    protected CompleteGraffitiObject graffiti;
    private static final ResourceLocation TEXTURE = new ResourceLocation("graffiti", "textures/gui/canvas_editor.png");

    public GuiCanvasEditorBase(ContainerGraffiti container, PlayerInventory inv, ITextComponent text) {
        super((Container)container, inv, text);
        this.tileEntity = container.te;
        this.graffiti = container.graffiti;
        this.field_146999_f = 256;
        this.field_147000_g = 248;
    }

    public void render(int x, int y, float partialTick) {
        this.renderBackground();
        super.render(x, y, partialTick);
        this.func_191948_b(x, y);
    }

    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        super.init();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        this.blit(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void drawCenteredString(FontRenderer p_drawCenteredString_1_, String p_drawCenteredString_2_, int p_drawCenteredString_3_, int p_drawCenteredString_4_, int p_drawCenteredString_5_) {
        p_drawCenteredString_1_.func_211126_b(p_drawCenteredString_2_, (float)(p_drawCenteredString_3_ - p_drawCenteredString_1_.func_78256_a(p_drawCenteredString_2_) / 2), (float)p_drawCenteredString_4_, p_drawCenteredString_5_);
    }

    public void drawGraffiti(CompleteGraffitiObject graffiti, boolean drawGrid, boolean drawText) {
        int texture;
        int startX = (this.width - this.field_146999_f) / 2 + 8;
        int startY = (this.height - this.field_147000_g) / 2 + 8;
        int n = texture = graffiti.pixelGrid == null ? 0 : graffiti.pixelGrid.getSize();
        if (graffiti.pixelGrid != null) {
            if (graffiti.pixelGrid.getSize() == 16) {
                texture = 0;
            }
            if (graffiti.pixelGrid.getSize() == 128) {
                texture = 96;
            }
        }
        this.blit(startX, startY, 8 + texture, 8, 32, 128);
        this.blit(startX + 32, startY, 8 + texture, 8, 32, 128);
        this.blit(startX + 64, startY, 8 + texture, 8, 32, 128);
        this.blit(startX + 96, startY, 8 + texture, 8, 32, 128);
        PixelGridDrawable grid = graffiti.pixelGrid;
        if (drawGrid && grid != null && grid.getSize() > 0) {
            int size = 8;
            if (grid.getSize() == 32) {
                size = 4;
            } else if (grid.getSize() == 64) {
                size = 2;
            } else if (grid.getSize() == 128) {
                size = 1;
            }
            for (int i = 0; i < grid.getSize(); ++i) {
                for (int j = 0; j < grid.getSize(); ++j) {
                    this.fillGradient(startX + j * size, startY + i * size, startX + j * size + size, startY + i * size + size, grid.getPixelRGB(j, i), grid.getPixelRGB(j, i));
                }
            }
        }
        if (drawText) {
            for (int i = 0; i < graffiti.textList.size(); ++i) {
                TextDrawable text = graffiti.textList.get(i);
                GL11.glPushMatrix();
                GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
                this.font.func_211126_b(text.getDrawableText(), (float)((startX + text.xPos() * 2) / 2), (float)((startY + Math.abs(text.yPos() * 2 - 128)) / 2), text.getCol());
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                GL11.glPopMatrix();
            }
        }
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        this.blit(startX + 128, startY - 1, 136, 7, 116, 130);
    }
}

