/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.client.gui;

import com.silvaniastudios.graffiti.client.gui.widget.ColorDisplayWidget;
import com.silvaniastudios.graffiti.client.gui.widget.ColorGridWidget;
import com.silvaniastudios.graffiti.network.GraffitiPacketHandler;
import com.silvaniastudios.graffiti.network.PenCustomColourPacket;
import com.silvaniastudios.graffiti.network.SetPenColourPacket;
import com.silvaniastudios.graffiti.util.EnumColours;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class GuiColourPicker
extends Screen {
    private ItemStack penIS;
    private int xSize = 256;
    private int ySize = 240;
    ColorGridWidget grid;
    boolean draggingGrid = false;
    boolean draggingSlider = false;
    Slider rCol;
    Slider gCol;
    Slider bCol;
    Button toggleWriting;
    Button saveColour;
    boolean savingColour = false;
    boolean writingMode = true;
    EnumColours[] presetColours = new EnumColours[]{EnumColours.BLACK, EnumColours.BLOOD_RED, EnumColours.BROWN, EnumColours.DEEP_PURPLE, EnumColours.DARK_BLUE, EnumColours.DARK_AQUA, EnumColours.LEAF_GREEN, EnumColours.DARK_GRAY, EnumColours.DARK_RED, EnumColours.ORANGE, EnumColours.DARK_PURPLE, EnumColours.ROYAL_BLUE, EnumColours.SKY_BLUE, EnumColours.DARK_GREEN, EnumColours.GRAY, EnumColours.RED, EnumColours.GOLD, EnumColours.LIGHT_PURPLE, EnumColours.BLUE, EnumColours.AQUA, EnumColours.GREEN, EnumColours.WHITE, EnumColours.PINK, EnumColours.YELLOW, EnumColours.BABY_PINK, EnumColours.PASTEL_BLUE, EnumColours.ICE_BLUE, EnumColours.MINT_GREEN};
    int[] customColours = new int[21];
    private static final ResourceLocation TEXTURE = new ResourceLocation("graffiti", "textures/gui/colour_picker.png");
    int sliderRLast = 0;
    int sliderGLast = 0;
    int sliderBLast = 0;

    public GuiColourPicker(ItemStack pen) {
        super((ITextComponent)new TranslationTextComponent("graffiti.colour_picker", new Object[0]));
        this.penIS = pen;
    }

    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        int startX = this.width / 2 - this.xSize / 2;
        int startY = this.height / 2 - this.ySize / 2;
        this.grid = new ColorGridWidget(startX + 7, startY + 7, 4, new ColorDisplayWidget(startX + 163, startY + 7, 86, 34));
        this.rCol = this.initSlider(startX + 7, startY + 141, "Red: ");
        this.gCol = this.initSlider(startX + 7, startY + 165, "Green: ");
        this.bCol = this.initSlider(startX + 7, startY + 189, "Blue: ");
        if (this.penIS.func_77942_o()) {
            CompoundNBT penTag = this.penIS.func_77978_p();
            if (penTag.func_74764_b("customColours")) {
                this.customColours = penTag.func_74759_k("customColours");
            }
            if (penTag.func_74764_b("colour")) {
                this.grid.setColour(penTag.func_74762_e("colour"));
            }
            if (penTag.func_74764_b("writing")) {
                this.writingMode = penTag.func_74767_n("writing");
            }
        }
        this.toggleWriting = new Button(startX + 7, startY + 213, 119, 20, this.writingMode ? "Mode: Writing" : "Mode: Drawing", p_214266_1_ -> {
            this.writingMode = !this.writingMode;
            this.toggleWriting.setMessage(this.writingMode ? "Mode: Writing" : "Mode: Drawing");
        });
        this.saveColour = new Button(startX + 130, startY + 213, 119, 20, "Save Colour", p_214266_1_ -> {
            this.saveColour.setMessage("Choose colour slot...");
            this.savingColour = true;
            this.saveColour.active = false;
        });
        this.addButton((Widget)this.rCol);
        this.addButton((Widget)this.gCol);
        this.addButton((Widget)this.bCol);
        this.addButton((Widget)this.toggleWriting);
        this.addButton((Widget)this.saveColour);
        this.updateSlidersFromColour();
    }

    private Slider initSlider(int x, int y, String name) {
        Slider slider = new Slider(x + 10, y, 220, 20, name, "", 0.0, 255.0, 0.0, false, true, p_214266_1_ -> this.colourUpdate());
        this.addButton((Widget)new Button(x, y, 10, 20, "-", p_214266_1_ -> {
            slider.setValue((double)(slider.getValueInt() - 1));
            slider.updateSlider();
            this.colourUpdate();
        }));
        this.addButton((Widget)new Button(x + 230, y, 10, 20, "+", p_214266_1_ -> {
            slider.setValue((double)(slider.getValueInt() + 1));
            slider.updateSlider();
            this.colourUpdate();
        }));
        return slider;
    }

    private void colourUpdate() {
        this.grid.setColour(new Color(this.rCol.getValueInt(), this.gCol.getValueInt(), this.bCol.getValueInt()).getRGB());
    }

    public void onClose() {
        this.minecraft.func_147108_a((Screen)null);
        GraffitiPacketHandler.INSTANCE.sendToServer((Object)new SetPenColourPacket(this.grid.getColor(), this.writingMode));
    }

    public void renderBackground(int rb_1_) {
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int startX = this.width / 2 - this.xSize / 2;
        int startY = this.height / 2 - this.ySize / 2;
        this.blit(startX, startY, 0, 0, this.xSize, this.ySize);
    }

    public void render(int x, int y, float partialTick) {
        int slot;
        int col;
        int slot2;
        int j;
        int i;
        this.renderBackground();
        int startX = this.width / 2 - this.xSize / 2;
        int startY = this.height / 2 - this.ySize / 2;
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 4; ++j) {
                slot2 = i + j * 7;
                col = this.presetColours[slot2].getMCCol();
                this.fillGradient(startX + 165 + i * 12, startY + 46 + j * 12, startX + 175 + i * 12, startY + 56 + j * 12, col, col);
            }
        }
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 3; ++j) {
                slot2 = i + j * 7;
                col = this.customColours[slot2];
                this.fillGradient(startX + 165 + i * 12, startY + 102 + j * 12, startX + 175 + i * 12, startY + 112 + j * 12, col, col);
            }
        }
        this.grid.render(x, y, partialTick);
        if (x >= startX + 164 && x <= startX + 248 && y >= startY + 45 && y <= startY + 137 && (slot = this.getColourSlot(x, y)) != -1) {
            if (slot <= 27) {
                ArrayList<String> list = new ArrayList<String>();
                Color c = this.presetColours[slot].getCol();
                list.add(this.presetColours[slot].name);
                list.add("Red: " + c.getRed());
                list.add("Green: " + c.getGreen());
                list.add("Blue: " + c.getBlue());
                this.renderTooltip(list, x, y);
            } else {
                ArrayList<String> list = new ArrayList<String>();
                Color c = new Color(this.customColours[slot - 28]);
                list.add("Red: " + c.getRed());
                list.add("Green: " + c.getGreen());
                list.add("Blue: " + c.getBlue());
                this.renderTooltip(list, x, y);
            }
        }
        if (this.draggingGrid) {
            this.updateSlidersFromGrid();
        }
        if (this.draggingSlider) {
            this.grid.setColour(new Color(this.rCol.getValueInt(), this.gCol.getValueInt(), this.bCol.getValueInt()).getRGB());
        }
        super.render(x, y, partialTick);
    }

    private void updateSlidersFromGrid() {
        Color gridCol = this.grid.getSlidersColor();
        this.rCol.setValue((double)gridCol.getRed());
        this.gCol.setValue((double)gridCol.getGreen());
        this.bCol.setValue((double)gridCol.getBlue());
        this.rCol.updateSlider();
        this.gCol.updateSlider();
        this.bCol.updateSlider();
    }

    private void updateSlidersFromColour() {
        Color gridCol = new Color(this.grid.getColor());
        this.rCol.setValue((double)gridCol.getRed());
        this.gCol.setValue((double)gridCol.getGreen());
        this.bCol.setValue((double)gridCol.getBlue());
        this.rCol.updateSlider();
        this.gCol.updateSlider();
        this.bCol.updateSlider();
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.grid.releaseMouse();
        this.rCol.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        this.gCol.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        this.bCol.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        if (this.draggingGrid) {
            this.draggingGrid = false;
        }
        if (this.draggingSlider) {
            this.draggingSlider = false;
        }
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int slot;
        if (this.grid.mouseClicked(mouseX, mouseY, button)) {
            this.draggingGrid = true;
        }
        int startX = this.width / 2 - this.xSize / 2;
        int startY = this.height / 2 - this.ySize / 2;
        if (mouseX >= (double)(startX + 17) && mouseX <= (double)(startX + 237) && (mouseY >= (double)(startY + 141) && mouseY <= (double)(startY + 161) || mouseY >= (double)(startY + 165) && mouseY <= (double)(startY + 185) || mouseY >= (double)(startY + 189) && mouseY <= (double)(startY + 209))) {
            this.draggingSlider = true;
        }
        if (mouseX >= (double)(startX + 164) && mouseX <= (double)(startX + 248) && mouseY >= (double)(startY + 45) && mouseY <= (double)(startY + 137) && (slot = this.getColourSlot(mouseX, mouseY)) != -1) {
            if (slot <= 27) {
                this.grid.setColour(this.presetColours[slot].getMCCol());
                this.updateSlidersFromColour();
            } else if (this.savingColour) {
                this.customColours[slot - 28] = this.grid.getColor();
                this.savingColour = false;
                this.saveColour.active = true;
                this.saveColour.setMessage("Save Colour");
                GraffitiPacketHandler.INSTANCE.sendToServer((Object)new PenCustomColourPacket(this.grid.getColor(), slot - 28));
            } else if (this.customColours[slot - 28] != 0) {
                this.grid.setColour(this.customColours[slot - 28]);
                this.updateSlidersFromColour();
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private int getColourSlot(double mouseX, double mouseY) {
        int rX = (int)Math.floor(mouseX - (double)(this.width / 2 - this.xSize / 2 + 164));
        int rY = (int)Math.floor(mouseY - (double)(this.height / 2 - this.ySize / 2 + 45));
        int slotX = 0;
        int slotY = 0;
        for (int varX = rX; varX > 12; varX -= 12) {
            ++slotX;
        }
        if (rY > 47) {
            if (rY < 56) {
                return -1;
            }
            rY -= 56;
            slotY = 4;
        }
        for (int varY = rY; varY > 12; varY -= 12) {
            ++slotY;
        }
        return slotX + slotY * 7;
    }

    public boolean keyPressed(int keyID, int p_keyPressed_2_, int p_keyPressed_3_) {
        this.grid.keyPressed(keyID, p_keyPressed_2_, p_keyPressed_3_);
        return super.keyPressed(keyID, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void drawCenteredString(FontRenderer p_drawCenteredString_1_, String p_drawCenteredString_2_, int p_drawCenteredString_3_, int p_drawCenteredString_4_, int p_drawCenteredString_5_) {
        p_drawCenteredString_1_.func_211126_b(p_drawCenteredString_2_, (float)(p_drawCenteredString_3_ - p_drawCenteredString_1_.func_78256_a(p_drawCenteredString_2_) / 2), (float)p_drawCenteredString_4_, p_drawCenteredString_5_);
    }
}

