/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.client.gui;

import com.silvaniastudios.graffiti.drawables.CompleteGraffitiObject;
import com.silvaniastudios.graffiti.drawables.PixelGridDrawable;
import com.silvaniastudios.graffiti.drawables.TextDrawable;
import java.awt.Color;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.opengl.GL11;

public class GuiDisplayArt
extends Screen {
    private CompleteGraffitiObject graffiti;
    private int xSize = 256;
    private int ySize = 256;
    private static final ResourceLocation TEXTURE = new ResourceLocation("graffiti", "textures/gui/drawing.png");

    public GuiDisplayArt(CompleteGraffitiObject graffiti) {
        super((ITextComponent)new TranslationTextComponent("graffiti.display", new Object[0]));
        this.graffiti = graffiti;
    }

    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
    }

    public void renderBackground(int rb_1_) {
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int startX = this.width / 2 - this.xSize / 2;
        int startY = this.height / 2 - this.ySize / 2;
        this.blit(startX - 10, startY - 10, 0, 0, 10, 10);
        this.blit(startX, startY - 10, 10, 0, 128, 10);
        this.blit(startX + 128, startY - 10, 10, 0, 128, 10);
        this.blit(startX + this.xSize, startY - 10, 246, 0, 10, 10);
        this.blit(startX - 10, startY, 0, 10, 10, 128);
        this.blit(startX - 10, startY + 128, 0, 10, 10, 128);
        this.blit(startX + this.xSize, startY, 246, 10, 10, 128);
        this.blit(startX + this.xSize, startY + 128, 246, 10, 10, 128);
        this.blit(startX - 10, startY + this.ySize, 0, 140, 10, 10);
        this.blit(startX, startY + this.ySize, 10, 140, 128, 10);
        this.blit(startX + 128, startY + this.ySize, 10, 140, 128, 10);
        this.blit(startX + this.xSize, startY + this.ySize, 246, 140, 10, 10);
        int bg = new Color(64, 64, 64, this.graffiti.getBackgroundTransparency()).getRGB();
        this.fillGradient(startX, startY, startX + 256, startY + 256, bg, bg);
        this.drawGraffiti();
    }

    public void render(int x, int y, float partialTick) {
        this.renderBackground();
        super.render(x, y, partialTick);
    }

    public void drawGraffiti() {
        int startX = this.width / 2 - this.xSize / 2;
        int startY = this.height / 2 - this.ySize / 2;
        PixelGridDrawable grid = this.graffiti.pixelGrid;
        if (grid != null && grid.getSize() > 0) {
            int size = 16;
            if (grid.getSize() == 32) {
                size = 8;
            } else if (grid.getSize() == 64) {
                size = 4;
            } else if (grid.getSize() == 128) {
                size = 2;
            }
            for (int i = 0; i < grid.getSize(); ++i) {
                for (int j = 0; j < grid.getSize(); ++j) {
                    this.fillGradient(startX + j * size, startY + i * size, startX + j * size + size, startY + i * size + size, grid.getPixelRGB(j, i), grid.getPixelRGB(j, i));
                }
            }
        }
        for (int i = 0; i < this.graffiti.textList.size(); ++i) {
            TextDrawable text = this.graffiti.textList.get(i);
            float scale = 4.0f;
            GL11.glPushMatrix();
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            this.font.func_211126_b(text.getDrawableText(), ((float)startX + (float)text.xPos() * scale) / scale, ((float)startY + Math.abs((float)text.yPos() * scale - 256.0f)) / scale, text.getCol());
            GL11.glScaled((double)(1.0f / scale), (double)(1.0f / scale), (double)(1.0f / scale));
            GL11.glPopMatrix();
        }
    }
}

