/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.client.gui;

import com.silvaniastudios.graffiti.drawables.CompleteGraffitiObject;
import com.silvaniastudios.graffiti.drawables.PixelGridDrawable;
import com.silvaniastudios.graffiti.drawables.TextDrawable;
import com.silvaniastudios.graffiti.network.GraffitiPacketHandler;
import com.silvaniastudios.graffiti.network.WriteTextFromPenPacket;
import com.silvaniastudios.graffiti.tileentity.TileEntityGraffiti;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.opengl.GL11;

public class GuiWriteText
extends Screen {
    private TileEntityGraffiti tileEntity;
    private CompleteGraffitiObject graffiti;
    private int x;
    private int y;
    private int col;
    private boolean bold = false;
    private boolean italic = false;
    private boolean underline = false;
    private boolean strikethrough = false;
    private float scale = 1.0f;
    private int rotation;
    private String typedText = "";
    private int xSize = 256;
    private int ySize = 150;
    private static final ResourceLocation TEXTURE = new ResourceLocation("graffiti", "textures/gui/drawing.png");

    public GuiWriteText(TileEntityGraffiti tileEntity, CompleteGraffitiObject graffiti, int posX, int posY, int colour, int rot) {
        super((ITextComponent)new TranslationTextComponent("graffiti.write", new Object[0]));
        this.x = posX;
        this.y = posY;
        this.col = colour;
        this.rotation = rot;
        this.tileEntity = tileEntity;
        this.graffiti = graffiti;
    }

    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.addButton((Widget)new Button(this.width / 2 + 16, this.height / 2 - 65, 20, 20, "-", p_214266_1_ -> {
            if (this.x > 0) {
                --this.x;
            }
        }));
        this.addButton((Widget)new Button(this.width / 2 + 101, this.height / 2 - 65, 20, 20, "+", p_214266_1_ -> {
            if (this.x < 64) {
                ++this.x;
            }
        }));
        this.addButton((Widget)new Button(this.width / 2 + 16, this.height / 2 - 41, 20, 20, "-", p_214266_1_ -> {
            if (this.y < 64) {
                ++this.y;
            }
        }));
        this.addButton((Widget)new Button(this.width / 2 + 101, this.height / 2 - 41, 20, 20, "+", p_214266_1_ -> {
            if (this.y > 0) {
                --this.y;
            }
        }));
        this.addButton((Widget)new Button(this.width / 2 + 16, this.height / 2 - 3, 50, 20, "Bold", p_214266_1_ -> {
            this.bold = !this.bold;
            ((Widget)this.buttons.get(4)).setMessage(this.bold ? "\u00a7lBold" : "Bold");
        }));
        this.addButton((Widget)new Button(this.width / 2 + 71, this.height / 2 - 3, 50, 20, "Italic", p_214266_1_ -> {
            this.italic = !this.italic;
            ((Widget)this.buttons.get(5)).setMessage(this.italic ? "\u00a7oItalic" : "Italic");
        }));
        this.addButton((Widget)new Button(this.width / 2 + 16, this.height / 2 + 21, 105, 20, "Underline", p_214266_1_ -> {
            this.underline = !this.underline;
            ((Widget)this.buttons.get(6)).setMessage(this.underline ? "\u00a7nUnderline Enabled" : "Underline Disabled");
        }));
        this.addButton((Widget)new Button(this.width / 2 + 16, this.height / 2 + 45, 105, 20, "Strikeout", p_214266_1_ -> {
            this.strikethrough = !this.strikethrough;
            ((Widget)this.buttons.get(7)).setMessage(this.strikethrough ? "\u00a7mStrikeout Enabled" : "Strikeout Disabled");
        }));
    }

    public void onClose() {
        this.tileEntity.func_70296_d();
        this.minecraft.func_147108_a((Screen)null);
        if (!this.typedText.isEmpty()) {
            GraffitiPacketHandler.INSTANCE.sendToServer((Object)new WriteTextFromPenPacket(this.typedText, this.tileEntity.func_174877_v(), (short)this.x, (short)this.y, this.scale, this.col, (short)this.rotation, this.buildFormatString(), 0, this.graffiti.getSide().func_176745_a()));
        }
    }

    public String buildFormatString() {
        String b = this.bold ? "\u00a7l" : "";
        String i = this.italic ? "\u00a7o" : "";
        String u = this.underline ? "\u00a7n" : "";
        String s = this.strikethrough ? "\u00a7m" : "";
        return b + i + u + s;
    }

    public void renderBackground(int rb_1_) {
        int texture;
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int i = (this.width - this.xSize) / 2;
        int j = (this.height - this.ySize) / 2;
        this.blit(i, j, 0, 0, this.xSize, this.ySize);
        int startX = this.width / 2 - this.xSize / 2 + 11;
        int startY = this.height / 2 - this.ySize / 2 + 11;
        int n = texture = this.graffiti.pixelGrid == null ? 0 : this.graffiti.pixelGrid.getSize();
        if (this.graffiti.pixelGrid != null) {
            if (this.graffiti.pixelGrid.getSize() == 16) {
                texture = 0;
            }
            if (this.graffiti.pixelGrid.getSize() == 128) {
                texture = 96;
            }
        }
        this.blit(startX, startY, 11 + texture, 11, 32, 128);
        this.blit(startX + 32, startY, 11 + texture, 11, 32, 128);
        this.blit(startX + 64, startY, 11 + texture, 11, 32, 128);
        this.blit(startX + 96, startY, 11 + texture, 11, 32, 128);
        this.drawGraffiti();
    }

    public void render(int x, int y, float partialTick) {
        this.renderBackground();
        this.drawCenteredString(this.font, "X: " + this.x, this.width / 2 + 69, this.height / 2 - 59, 0x404040);
        this.drawCenteredString(this.font, "Y: " + Math.abs(this.y - 64), this.width / 2 + 69, this.height / 2 - 35, 0x404040);
        GL11.glPushMatrix();
        GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
        this.font.func_211126_b(this.buildFormatString() + this.typedText, (float)((this.width / 2 - this.xSize / 2 + 12 + this.x * 2) / 2), (float)((this.height / 2 - this.ySize / 2 + 12 + Math.abs(this.y * 2 - 128)) / 2), this.col);
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        GL11.glPopMatrix();
        super.render(x, y, partialTick);
    }

    public void drawCenteredString(FontRenderer p_drawCenteredString_1_, String p_drawCenteredString_2_, int p_drawCenteredString_3_, int p_drawCenteredString_4_, int p_drawCenteredString_5_) {
        p_drawCenteredString_1_.func_211126_b(p_drawCenteredString_2_, (float)(p_drawCenteredString_3_ - p_drawCenteredString_1_.func_78256_a(p_drawCenteredString_2_) / 2), (float)p_drawCenteredString_4_, p_drawCenteredString_5_);
    }

    public boolean charTyped(char c, int p_charTyped_2_) {
        if (this.typedText.length() < 45) {
            this.typedText = this.typedText + c;
        }
        return true;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 259 && !this.typedText.isEmpty()) {
            this.typedText = this.typedText.substring(0, this.typedText.length() - 1);
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void drawGraffiti() {
        int startX = this.width / 2 - this.xSize / 2 + 11;
        int startY = this.height / 2 - this.ySize / 2 + 11;
        PixelGridDrawable grid = this.graffiti.pixelGrid;
        if (grid != null && grid.getSize() > 0) {
            int size = 8;
            if (grid.getSize() == 32) {
                size = 4;
            } else if (grid.getSize() == 64) {
                size = 2;
            } else if (grid.getSize() == 128) {
                size = 1;
            }
            for (int i = 0; i < grid.getSize(); ++i) {
                for (int j = 0; j < grid.getSize(); ++j) {
                    this.fillGradient(startX + j * size, startY + i * size, startX + j * size + size, startY + i * size + size, grid.getPixelRGB(j, i), grid.getPixelRGB(j, i));
                }
            }
        }
        for (int i = 0; i < this.graffiti.textList.size(); ++i) {
            TextDrawable text = this.graffiti.textList.get(i);
            GL11.glPushMatrix();
            GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
            this.font.func_211126_b(text.getDrawableText(), (float)((startX + text.xPos() * 2) / 2), (float)((startY + Math.abs(text.yPos() * 2 - 128)) / 2), text.getCol());
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            GL11.glPopMatrix();
        }
    }
}

