/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.client.gui.submenu;

import com.silvaniastudios.graffiti.client.gui.GuiCanvasEditorBase;
import com.silvaniastudios.graffiti.client.gui.submenu.GuiCanvasEditorMain;
import com.silvaniastudios.graffiti.items.BasicPenItem;
import com.silvaniastudios.graffiti.network.GraffitiPacketHandler;
import com.silvaniastudios.graffiti.network.WriteTextPacket;
import com.silvaniastudios.graffiti.tileentity.ContainerGraffiti;
import java.util.ArrayList;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;
import org.lwjgl.opengl.GL11;

public class CreateTextMenu
extends GuiCanvasEditorBase {
    ArrayList<ItemStack> penList;
    Button penLeftBtn;
    Button penRightBtn;
    Button showHideText;
    Button showHidePixels;
    Button saveContinueBtn;
    Button saveCloseBtn;
    Button cancelBtn;
    Button increaseXBtn;
    Button decreaseXBtn;
    Button increaseYBtn;
    Button decreaseYBtn;
    Button boldBtn;
    Button italicBtn;
    Button underlineBtn;
    Button strikeBtn;
    Slider posXSlider;
    Slider posYSlider;
    int buttonOffset;
    int selectedPen = -1;
    private TextFieldWidget typedText;
    private boolean bold = false;
    private boolean italic = false;
    private boolean underline = false;
    private boolean strikethrough = false;
    private boolean showText = true;
    private boolean showPixels = true;
    private static final ResourceLocation TEXTURE = new ResourceLocation("graffiti", "textures/gui/create_text.png");

    public CreateTextMenu(ContainerGraffiti container, PlayerInventory inv, ITextComponent text) {
        super(container, inv, text);
        this.field_147000_g = 238;
    }

    @Override
    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.penList = this.getPens();
        this.initButtons();
        if (this.penList.size() > 12) {
            this.addButton((Widget)this.penLeftBtn);
            this.addButton((Widget)this.penRightBtn);
        }
        this.addButton((Widget)this.increaseXBtn);
        this.addButton((Widget)this.decreaseXBtn);
        this.addButton((Widget)this.increaseYBtn);
        this.addButton((Widget)this.decreaseYBtn);
        this.addButton((Widget)this.boldBtn);
        this.addButton((Widget)this.italicBtn);
        this.addButton((Widget)this.underlineBtn);
        this.addButton((Widget)this.strikeBtn);
        this.addButton((Widget)this.posXSlider);
        this.addButton((Widget)this.posYSlider);
        this.addButton((Widget)this.showHideText);
        this.addButton((Widget)this.showHidePixels);
        this.addButton((Widget)this.saveContinueBtn);
        this.addButton((Widget)this.saveCloseBtn);
        this.addButton((Widget)this.cancelBtn);
        super.init();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        if (this.penList.size() > 0) {
            int startPoint = 8;
            if (this.penList.size() >= 13) {
                startPoint = 21;
            }
            for (int i = 0; i < this.penList.size(); ++i) {
                if (i >= 12) continue;
                this.minecraft.func_175599_af().func_180450_b(this.penList.get(i + this.buttonOffset), startPoint + i * 18, 142);
                if (mouseX <= startX + startPoint + i * 18 || mouseX >= startX + startPoint + 18 + i * 18 || mouseY <= startY + 142 || mouseY >= startY + 160) continue;
                this.fillGradient(startPoint + i * 18, 142, startPoint + 16 + i * 18, 158, -2130706433, -2130706433);
            }
        }
        if (this.penList.isEmpty()) {
            this.drawCenteredString(this.font, "You need at least one pen in your", 128, 140, 0x404040);
            this.drawCenteredString(this.font, "inventory to add new text", 128, 148, 0x404040);
        }
        if (this.selectedPen >= 0 && !this.typedText.func_146179_b().isEmpty()) {
            BasicPenItem pen = (BasicPenItem)this.penList.get(this.selectedPen).func_77973_b();
            GL11.glPushMatrix();
            GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
            this.font.func_211126_b(this.buildFormatString() + this.typedText.func_146179_b(), (float)(4 + (int)Math.floor(this.posXSlider.getValue())), (float)(4 + (int)Math.floor(this.posYSlider.getValue())), pen.getColor(this.penList.get(this.selectedPen)).getRGB());
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            GL11.glPopMatrix();
            this.saveContinueBtn.active = true;
            this.saveCloseBtn.active = true;
        } else {
            this.saveContinueBtn.active = false;
            this.saveCloseBtn.active = false;
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int x = (this.width - this.field_146999_f) / 2;
        int y = (this.height - this.field_147000_g) / 2;
        this.blit(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.penList.size() > 0) {
            int i;
            if (this.penList.size() < 13) {
                for (i = 0; i < this.penList.size(); ++i) {
                    this.blit(x + 7 + i * 18, y + 141, 0, 238, 18, 18);
                    if (this.selectedPen != i) continue;
                    this.blit(x + 7 + i * 18, y + 141, 18, 238, 18, 18);
                }
            } else {
                for (i = 0; i < 12; ++i) {
                    this.blit(x + 20 + i * 18, y + 141, 0, 238, 18, 18);
                    if (this.selectedPen - this.buttonOffset != i) continue;
                    this.blit(x + 20 + i * 18, y + 141, 18, 238, 18, 18);
                }
            }
        }
        if (this.selectedPen >= 0) {
            BasicPenItem pen = (BasicPenItem)this.penList.get(this.selectedPen).func_77973_b();
            this.fillGradient(x + 8, y + 164, x + 40, y + 230, pen.getColor(this.penList.get(this.selectedPen)).getRGB(), pen.getColor(this.penList.get(this.selectedPen)).getRGB());
        }
        this.drawGraffiti(this.graffiti, this.showPixels, this.showText);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        int slotClicked = this.getClickedSlotId(startX, startY, mouseX, mouseY);
        if (slotClicked >= 0) {
            this.selectedPen = slotClicked;
            BasicPenItem pen = (BasicPenItem)this.penList.get(this.selectedPen).func_77973_b();
            this.typedText.func_146193_g(pen.getColor(this.penList.get(this.selectedPen)).getRGB());
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private int getClickedSlotId(int startX, int startY, double mouseX, double mouseY) {
        if (this.penList.size() > 0) {
            int startPoint = 8;
            if (this.penList.size() >= 13) {
                startPoint = 21;
            }
            for (int i = 0; i < this.penList.size(); ++i) {
                if (i >= 12 || !(mouseX > (double)(startX + startPoint + i * 18)) || !(mouseX < (double)(startX + startPoint + 18 + i * 18)) || !(mouseY > (double)(startY + 142)) || !(mouseY < (double)(startY + 160))) continue;
                return i + this.buttonOffset;
            }
        }
        return -1;
    }

    private ArrayList<ItemStack> getPens() {
        ArrayList<ItemStack> pens = new ArrayList<ItemStack>();
        for (int i = 0; i < this.field_213127_e.func_70302_i_(); ++i) {
            ItemStack slotStack = this.field_213127_e.func_70301_a(i);
            if (!(slotStack.func_77973_b() instanceof BasicPenItem)) continue;
            pens.add(slotStack);
        }
        return pens;
    }

    private void initButtons() {
        int startX = this.width / 2 - this.field_146999_f / 2;
        int startY = this.height / 2 - this.field_147000_g / 2;
        if (this.penList.size() > 12) {
            this.penLeftBtn = new Button(startX + 7, startY + 140, 13, 20, "<", p_214266_1_ -> {
                if (this.buttonOffset > 0) {
                    --this.buttonOffset;
                }
            });
            this.penRightBtn = new Button(startX + 236, startY + 140, 13, 20, ">", p_214266_1_ -> {
                if (this.buttonOffset < this.penList.size() - 12) {
                    ++this.buttonOffset;
                }
            });
        }
        this.decreaseXBtn = new Button(startX + 141, startY + 7, 10, 20, "-", p_214266_1_ -> {
            this.posXSlider.setValue(this.posXSlider.getValue() > 0.0 ? this.posXSlider.getValue() - 1.0 : 0.0);
            this.posXSlider.updateSlider();
        });
        this.posXSlider = new Slider(startX + 151, startY + 7, 88, 20, "X: ", "", 0.0, 64.0, 0.0, false, true, p_214266_1_ -> {});
        this.increaseXBtn = new Button(startX + 239, startY + 7, 10, 20, "+", p_214266_1_ -> {
            this.posXSlider.setValue(this.posXSlider.getValue() < 64.0 ? this.posXSlider.getValue() + 1.0 : 64.0);
            this.posXSlider.updateSlider();
        });
        this.decreaseYBtn = new Button(startX + 141, startY + 31, 10, 20, "-", p_214266_1_ -> {
            this.posYSlider.setValue(this.posYSlider.getValue() > 0.0 ? this.posYSlider.getValue() - 1.0 : 0.0);
            this.posYSlider.updateSlider();
        });
        this.posYSlider = new Slider(startX + 151, startY + 31, 88, 20, "Y: ", "", 0.0, 64.0, 0.0, false, true, p_214266_1_ -> {});
        this.increaseYBtn = new Button(startX + 239, startY + 31, 10, 20, "+", p_214266_1_ -> {
            this.posYSlider.setValue(this.posYSlider.getValue() < 64.0 ? this.posYSlider.getValue() + 1.0 : 64.0);
            this.posYSlider.updateSlider();
        });
        this.showHideText = new Button(startX + 141, startY + 55, 108, 20, "Hide Text", p_214266_1_ -> {
            this.showText = !this.showText;
            this.showHideText.setMessage(this.showText ? "Hide Text" : "Show Text");
        });
        this.showHidePixels = new Button(startX + 141, startY + 79, 108, 20, "Hide Art", p_214266_1_ -> {
            this.showPixels = !this.showPixels;
            this.showHidePixels.setMessage(this.showPixels ? "Hide Art" : "Show Art");
        });
        this.boldBtn = new Button(startX + 45, startY + 183, 48, 20, "Bold", p_214266_1_ -> {
            this.bold = !this.bold;
            this.boldBtn.setMessage(this.bold ? "\u00a7lBold" : "Bold");
        });
        this.italicBtn = new Button(startX + 97, startY + 183, 48, 20, "Italic", p_214266_1_ -> {
            this.italic = !this.italic;
            this.italicBtn.setMessage(this.italic ? "\u00a7l\u00a7oItalic" : "Italic");
        });
        this.underlineBtn = new Button(startX + 149, startY + 183, 48, 20, "Underline", p_214266_1_ -> {
            this.underline = !this.underline;
            this.underlineBtn.setMessage(this.underline ? "\u00a7l\u00a7nUnderline" : "Underline");
        });
        this.strikeBtn = new Button(startX + 201, startY + 183, 48, 20, "Strikeout", p_214266_1_ -> {
            this.strikethrough = !this.strikethrough;
            this.strikeBtn.setMessage(this.strikethrough ? "\u00a7l\u00a7mStrikeout" : "Strikeout");
        });
        this.cancelBtn = new Button(startX + 45, startY + 211, 40, 20, "Cancel", p_214266_1_ -> this.minecraft.func_147108_a((Screen)new GuiCanvasEditorMain((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title)));
        this.saveContinueBtn = new Button(startX + 89, startY + 211, 78, 20, "Save & Close", p_214266_1_ -> {
            this.sendPacket();
            this.minecraft.func_147108_a((Screen)new GuiCanvasEditorMain((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title));
        });
        this.saveCloseBtn = new Button(startX + 171, startY + 211, 78, 20, "Save", p_214266_1_ -> {
            this.sendPacket();
            this.minecraft.func_147108_a((Screen)new CreateTextMenu((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title));
        });
        this.typedText = new TextFieldWidget(this.font, startX + 45, startY + 163, 204, 16, "");
        this.typedText.func_146205_d(false);
        this.typedText.changeFocus(true);
        this.typedText.func_146193_g(-1);
        this.typedText.func_146185_a(true);
        this.typedText.func_146203_f(45);
        this.children.add(this.typedText);
        this.func_212928_a((IGuiEventListener)this.typedText);
    }

    @Override
    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        super.render(p_render_1_, p_render_2_, p_render_3_);
        this.typedText.render(p_render_1_, p_render_2_, p_render_3_);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.minecraft.field_71439_g.func_71053_j();
        }
        return !this.typedText.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) && !this.typedText.func_212955_f() ? super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : true;
    }

    private void sendPacket() {
        if (this.selectedPen >= 0) {
            BasicPenItem pen = (BasicPenItem)this.penList.get(this.selectedPen).func_77973_b();
            GraffitiPacketHandler.INSTANCE.sendToServer((Object)new WriteTextPacket(this.typedText.func_146179_b(), (short)this.posXSlider.getValueInt(), (short)Math.abs(this.posYSlider.getValueInt() - 64), 1.0f, pen.getColor(this.penList.get(this.selectedPen)).getRGB(), 0, this.buildFormatString(), 0, -1, false));
        }
    }

    public String buildFormatString() {
        String b = this.bold ? "\u00a7l" : "";
        String i = this.italic ? "\u00a7o" : "";
        String u = this.underline ? "\u00a7n" : "";
        String s = this.strikethrough ? "\u00a7m" : "";
        return b + i + u + s;
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.posXSlider.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        this.posYSlider.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }
}

