/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.client.gui.submenu;

import com.silvaniastudios.graffiti.client.gui.GuiCanvasEditorBase;
import com.silvaniastudios.graffiti.client.gui.submenu.GuiCanvasEditorMain;
import com.silvaniastudios.graffiti.network.GraffitiPacketHandler;
import com.silvaniastudios.graffiti.network.SetPositionPacket;
import com.silvaniastudios.graffiti.tileentity.ContainerGraffiti;
import java.util.ArrayList;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class EditPositionMenu
extends GuiCanvasEditorBase {
    Button alignNormal;
    Button alignOffset;
    Button offsetIncreaseBtn;
    Button offsetDecreaseBtn;
    Button resetDefaultBtn;
    Button resetZeroBtn;
    Button saveBtn;
    Button discardBtn;
    Slider offsetSldr;
    boolean inBlockOffset = false;
    private static final ResourceLocation TEXTURE = new ResourceLocation("graffiti", "textures/gui/widgets.png");

    public EditPositionMenu(ContainerGraffiti container, PlayerInventory inv, ITextComponent text) {
        super(container, inv, text);
        this.field_146999_f = 218;
        this.field_147000_g = 121;
    }

    @Override
    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.initButtons();
        this.addButton((Widget)this.alignNormal);
        this.addButton((Widget)this.alignOffset);
        this.addButton((Widget)this.offsetIncreaseBtn);
        this.addButton((Widget)this.offsetDecreaseBtn);
        this.addButton((Widget)this.resetDefaultBtn);
        this.addButton((Widget)this.resetZeroBtn);
        this.addButton((Widget)this.saveBtn);
        this.addButton((Widget)this.discardBtn);
        this.addButton((Widget)this.offsetSldr);
        super.init();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawCenteredString(this.font, "Set positioning options", this.field_146999_f / 2, 7, 0x404040);
    }

    @Override
    public void render(int mouseX, int mouseY, float p_render_3_) {
        ArrayList<String> list;
        super.render(mouseX, mouseY, p_render_3_);
        if (this.alignNormal.isHovered()) {
            list = new ArrayList<String>();
            list.add("Align the graffiti so an offset of zero would be the edge of a full-sized block");
            this.renderTooltip(list, mouseX, mouseY);
        }
        if (this.alignOffset.isHovered()) {
            list = new ArrayList();
            list.add("Align the graffiti so an offset of zero would leave it flush with the block behind it");
            list.add("Useful when graffiti is placed on non-full cubes, such as chests.");
            this.renderTooltip(list, mouseX, mouseY);
        }
        if (this.resetZeroBtn.isHovered()) {
            list = new ArrayList();
            list.add("Reset offset to zero");
            list.add("May cause Z-fighting with blocks behind the graffiti.");
            this.renderTooltip(list, mouseX, mouseY);
        }
        if (this.resetDefaultBtn.isHovered()) {
            list = new ArrayList();
            list.add("Reset offset to default setting (1/64th away from block)");
            this.renderTooltip(list, mouseX, mouseY);
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        this.blit(i, j, 0, 93, this.field_146999_f, this.field_147000_g);
    }

    private void initButtons() {
        int startX = this.width / 2 - this.field_146999_f / 2;
        int startY = this.height / 2 - this.field_147000_g / 2;
        this.alignNormal = new Button(startX + 7, startY + 18, 100, 20, "Normal Alignment", p_214266_1_ -> {
            this.inBlockOffset = false;
            this.alignNormal.active = false;
            this.alignOffset.active = true;
        });
        this.alignOffset = new Button(startX + 111, startY + 18, 100, 20, "In-Block Offset", p_214266_1_ -> {
            this.inBlockOffset = true;
            this.alignNormal.active = true;
            this.alignOffset.active = false;
        });
        this.offsetSldr = new Slider(startX + 17, startY + 42, 184, 20, "Offset: ", "", -0.25, 0.25, 0.0, true, true, p_214266_1_ -> {});
        this.offsetSldr.precision = 7;
        this.offsetDecreaseBtn = new Button(startX + 7, startY + 42, 10, 20, "-", p_214266_1_ -> {
            this.offsetSldr.setValue(this.offsetSldr.getValue() - 0.0078125);
            this.offsetSldr.updateSlider();
        });
        this.offsetIncreaseBtn = new Button(startX + 201, startY + 42, 10, 20, "+", p_214266_1_ -> {
            this.offsetSldr.setValue(this.offsetSldr.getValue() + 0.0078125);
            this.offsetSldr.updateSlider();
        });
        this.resetZeroBtn = new Button(startX + 7, startY + 66, 100, 20, "Reset to Zero", p_214266_1_ -> {
            this.offsetSldr.setValue(0.0);
            this.offsetSldr.updateSlider();
        });
        this.resetDefaultBtn = new Button(startX + 111, startY + 66, 100, 20, "Reset to Default", p_214266_1_ -> {
            this.offsetSldr.setValue(0.015625);
            this.offsetSldr.updateSlider();
        });
        this.discardBtn = new Button(startX + 7, startY + 94, 100, 20, "Discard Changes", p_214266_1_ -> this.minecraft.func_147108_a((Screen)new GuiCanvasEditorMain((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title)));
        this.saveBtn = new Button(startX + 111, startY + 94, 100, 20, "Save Changes", p_214266_1_ -> {
            GraffitiPacketHandler.INSTANCE.sendToServer((Object)new SetPositionPacket(this.inBlockOffset, this.offsetSldr.getValue()));
            this.minecraft.func_147108_a((Screen)new GuiCanvasEditorMain((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title));
        });
        this.offsetSldr.setValue(this.graffiti.getAlignment());
        this.offsetSldr.updateSlider();
        this.alignNormal.active = this.graffiti.isOffsetIntoBlock();
        this.alignOffset.active = !this.graffiti.isOffsetIntoBlock();
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.offsetSldr.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }
}

