/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.client.gui.submenu;

import com.silvaniastudios.graffiti.client.gui.GuiCanvasEditorBase;
import com.silvaniastudios.graffiti.client.gui.submenu.GuiCanvasEditorMain;
import com.silvaniastudios.graffiti.drawables.PixelGridDrawable;
import com.silvaniastudios.graffiti.tileentity.ContainerGraffiti;
import com.silvaniastudios.graffiti.util.FileExport;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class ExportJsonScreen
extends GuiCanvasEditorBase {
    PixelGridDrawable grid;
    Button exportBtn;
    Button cancelBtn;
    private TextFieldWidget name;
    ArrayList<String> fileNames = new ArrayList();
    boolean fileNameTaken = false;

    public ExportJsonScreen(ContainerGraffiti container, PlayerInventory inv, ITextComponent text) {
        super(container, inv, text);
        this.grid = this.graffiti.pixelGrid;
        this.field_147000_g = 196;
        File[] files = new File("./graffiti/").listFiles();
        for (int i = 0; i < files.length; ++i) {
            this.fileNames.add(files[i].getName());
        }
    }

    private void initButtons() {
        int startX = this.width / 2 - this.field_146999_f / 2;
        int startY = this.height / 2 - this.field_147000_g / 2;
        this.name = new TextFieldWidget(this.font, startX + 7, startY + 141, 242, 16, "");
        this.name.func_146205_d(false);
        this.name.changeFocus(true);
        this.name.func_146193_g(-1);
        this.name.func_146185_a(true);
        this.name.func_146203_f(50);
        this.children.add(this.name);
        this.func_212928_a((IGuiEventListener)this.name);
        LocalDateTime dateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy_HH-mm-ss");
        this.name.func_146180_a(this.field_213127_e.field_70458_d.func_145748_c_().getString() + "_" + dateTime.format(formatter));
        this.cancelBtn = new Button(startX + 7, startY + 161, 110, 20, "Cancel", p_214266_1_ -> this.minecraft.func_147108_a((Screen)new GuiCanvasEditorMain((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title)));
        this.exportBtn = new Button(startX + 139, startY + 161, 110, 20, "Export", p_214266_1_ -> {
            this.field_213127_e.field_70458_d.func_145747_a((ITextComponent)FileExport.createFile(this.name.func_146179_b(), this.graffiti, this.field_213127_e.field_70458_d.func_200200_C_().getString()));
            this.minecraft.func_147108_a((Screen)new GuiCanvasEditorMain((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title));
        });
        this.exportBtn.active = false;
    }

    @Override
    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.initButtons();
        this.addButton((Widget)this.cancelBtn);
        this.addButton((Widget)this.exportBtn);
        super.init();
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        this.blit(i, j + 189, 0, 249, this.field_146999_f, 7);
        this.drawGraffiti(this.graffiti, true, true);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawCenteredString(this.font, "Pixel Grid", 195, 8, 0x404040);
        if (this.exportBtn.isHovered() && this.fileNameTaken) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("File already exists with this name.");
            list.add("Please choose a new name, or delete the old file and reload GUI.");
            this.renderTooltip(list, mouseX, mouseY);
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float p_render_3_) {
        super.render(mouseX, mouseY, p_render_3_);
        this.fileNameTaken = this.fileNames.contains(this.name.func_146179_b() + ".json");
        this.exportBtn.active = !this.name.func_146179_b().isEmpty() && !this.fileNameTaken;
        this.name.render(mouseX, mouseY, p_render_3_);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.minecraft.field_71439_g.func_71053_j();
        }
        return !this.name.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) && !this.name.func_212955_f() ? super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : true;
    }
}

