/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.client.gui.submenu;

import com.silvaniastudios.graffiti.client.gui.GuiCanvasEditorBase;
import com.silvaniastudios.graffiti.client.gui.submenu.ConfirmDeleteMenu;
import com.silvaniastudios.graffiti.client.gui.submenu.CreatePixelGrid;
import com.silvaniastudios.graffiti.client.gui.submenu.EditPositionMenu;
import com.silvaniastudios.graffiti.client.gui.submenu.ExportJsonScreen;
import com.silvaniastudios.graffiti.client.gui.submenu.ImportListMenu;
import com.silvaniastudios.graffiti.client.gui.submenu.PixelGridMenu;
import com.silvaniastudios.graffiti.client.gui.submenu.RightClickActionMenu;
import com.silvaniastudios.graffiti.client.gui.submenu.TextMenu;
import com.silvaniastudios.graffiti.network.GraffitiPacketHandler;
import com.silvaniastudios.graffiti.network.LockEditPacket;
import com.silvaniastudios.graffiti.tileentity.ContainerGraffiti;
import com.silvaniastudios.graffiti.util.GraffitiUtils;
import java.util.ArrayList;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiCanvasEditorMain
extends GuiCanvasEditorBase {
    boolean locked;
    Button gridBtn;
    Button textBtn;
    Button shapesBtn;
    Button positionBtn;
    Button rightClickBtn;
    Button lockedBtn;
    Button deleteBtn;
    Button importBtn;
    Button exportBtn;

    public GuiCanvasEditorMain(ContainerGraffiti container, PlayerInventory inv, ITextComponent text) {
        super(container, inv, text);
        this.locked = this.tileEntity.isLocked();
    }

    private void initButtons() {
        int startX = this.width / 2 - this.field_146999_f / 2;
        int startY = this.height / 2 - this.field_147000_g / 2;
        this.gridBtn = new Button(startX + 144, startY + 7, 105, 20, "Pixel Grid", p_214266_1_ -> {
            if (this.graffiti.pixelGrid == null || this.graffiti.pixelGrid.getSize() == 0) {
                this.minecraft.func_147108_a((Screen)new CreatePixelGrid((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title));
            } else {
                this.minecraft.func_147108_a((Screen)new PixelGridMenu((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title));
            }
        });
        this.textBtn = new Button(startX + 144, startY + 31, 105, 20, "Text", p_214266_1_ -> this.minecraft.func_147108_a((Screen)new TextMenu((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title)));
        this.shapesBtn = new Button(startX + 144, startY + 55, 105, 20, "Shapes", p_214266_1_ -> {});
        this.positionBtn = new Button(startX + 144, startY + 79, 105, 20, "Position", p_214266_1_ -> this.minecraft.func_147108_a((Screen)new EditPositionMenu((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title)));
        this.rightClickBtn = new Button(startX + 144, startY + 103, 105, 20, "Right-Click Action", p_214266_1_ -> this.minecraft.func_147108_a((Screen)new RightClickActionMenu((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title)));
        this.lockedBtn = new Button(startX + 144, startY + 127, 105, 20, "Locked: " + this.locked, p_214266_1_ -> {
            this.locked = !this.locked;
            this.lockedBtn.setMessage("Locked: " + this.locked);
            GraffitiPacketHandler.INSTANCE.sendToServer((Object)new LockEditPacket(this.locked));
        });
        this.importBtn = new Button(startX + 144, startY + 173, 105, 20, "Import", p_214266_1_ -> this.minecraft.func_147108_a((Screen)new ImportListMenu((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title)));
        this.exportBtn = new Button(startX + 144, startY + 197, 105, 20, "Export", p_214266_1_ -> this.minecraft.func_147108_a((Screen)new ExportJsonScreen((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title)));
        this.deleteBtn = new Button(startX + 144, startY + 221, 105, 20, "\u00a74\u00a7lDelete", p_214266_1_ -> this.minecraft.func_147108_a((Screen)new ConfirmDeleteMenu((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title)));
        this.shapesBtn.active = false;
    }

    @Override
    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.initButtons();
        this.addButton((Widget)this.gridBtn);
        this.addButton((Widget)this.textBtn);
        this.addButton((Widget)this.shapesBtn);
        this.addButton((Widget)this.positionBtn);
        this.addButton((Widget)this.rightClickBtn);
        this.addButton((Widget)this.lockedBtn);
        this.addButton((Widget)this.importBtn);
        this.addButton((Widget)this.exportBtn);
        this.addButton((Widget)this.deleteBtn);
        super.init();
    }

    public void onClose() {
        this.tileEntity.func_70296_d();
        this.minecraft.func_147108_a((Screen)null);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.drawGraffiti(this.graffiti, true, true);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.graffiti.pixelGrid != null && this.graffiti.pixelGrid.getSize() > 0) {
            this.font.func_211126_b("Pixel Grid: " + this.graffiti.pixelGrid.getSize() + "x" + this.graffiti.pixelGrid.getSize(), 7.0f, 141.0f, 0x404040);
        } else {
            this.font.func_211126_b("No Pixel Grid", 7.0f, 141.0f, 0x404040);
        }
        this.font.func_211126_b("Texts: " + this.graffiti.textList.size(), 7.0f, 153.0f, 0x404040);
        this.font.func_211126_b("Shapes: ", 7.0f, 165.0f, 0x404040);
        this.font.func_211126_b("Position: ", 7.0f, 177.0f, 0x404040);
        this.font.func_211126_b("Type: " + (this.graffiti.isOffsetIntoBlock() ? "In-Block Offset" : "Normal Alignment"), 11.0f, 187.0f, 0x404040);
        this.font.func_211126_b("Offset: " + Math.round(this.graffiti.getAlignment() * 1000000.0) / 1000000L, 11.0f, 197.0f, 0x404040);
        this.font.func_211126_b("Right-click: ", 7.0f, 209.0f, 0x404040);
        this.font.func_211126_b("Action: " + GraffitiUtils.rightClickActionString(this.graffiti.getRightClickAction()), 11.0f, 219.0f, 0x404040);
        if (this.graffiti.getRightClickAction() == 2) {
            this.font.func_211126_b("BG Transparency: " + this.graffiti.getBackgroundTransparency(), 11.0f, 229.0f, 0x404040);
        }
        if (this.graffiti.getRightClickAction() == 3) {
            String url = this.graffiti.getUrl();
            if (url.contains("http://")) {
                url = url.substring(7);
            } else if (url.contains("https://")) {
                url = url.substring(8);
            }
            if (url.contains("www.")) {
                url = url.substring(4);
            }
            if (url.length() > 20) {
                this.font.func_211126_b("URL: " + url.substring(0, 18) + "...", 11.0f, 229.0f, 0x404040);
            } else {
                this.font.func_211126_b("URL: " + url, 11.0f, 229.0f, 0x404040);
            }
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float p_render_3_) {
        ArrayList<String> list;
        super.render(mouseX, mouseY, p_render_3_);
        int startX = this.width / 2 - this.field_146999_f / 2;
        int startY = this.height / 2 - this.field_147000_g / 2;
        if (this.graffiti.getRightClickAction() == 3 && !this.graffiti.getUrl().isEmpty() && mouseX >= startX + 11 && mouseX <= startX + 140 && mouseY >= startY + 229 && mouseY <= startY + 237) {
            this.renderTooltip(this.graffiti.getUrl(), mouseX, mouseY);
        }
        if (this.gridBtn.isHovered()) {
            list = new ArrayList<String>();
            list.add("Add/Edit/Remove pixel grid");
            list.add("Blocks without a pixel grid will have less performance impact");
            list.add("Grids can be 16x - 128x");
            this.renderTooltip(list, mouseX, mouseY);
        }
        if (this.textBtn.isHovered()) {
            this.renderTooltip("Add/Edit/Remove text", mouseX, mouseY);
        }
        if (this.shapesBtn.isHovered()) {
            list = new ArrayList();
            list.add("Add/Edit/Remove shapes");
            list.add("(Coming in 1.4!)");
            this.renderTooltip(list, mouseX, mouseY);
        }
        if (this.positionBtn.isHovered()) {
            list = new ArrayList();
            list.add("Realign the position of the Graffiti");
            list.add("0: Graffiti is rendered inside its own blockspace, slightly indented.");
            list.add("1: Graffiti is offset into the blockspace it's mounted to, making it flush with surrounding blocks");
            list.add("2: Graffiti will attempt to align further into a block (Not yet implemeted!)");
            this.renderTooltip(list, mouseX, mouseY);
        }
        if (this.rightClickBtn.isHovered()) {
            list = new ArrayList();
            list.add("Edit Right-click action");
            list.add("This changes what happens when a player right-clicks your art");
            this.renderTooltip(list, mouseX, mouseY);
        }
        if (this.lockedBtn.isHovered()) {
            list = new ArrayList();
            list.add("Lock editing");
            list.add("Disables all editing for the block");
            list.add("Only the owner or OP can unlock it again");
            this.renderTooltip(list, mouseX, mouseY);
        }
        if (this.importBtn.isHovered()) {
            list = new ArrayList();
            list.add("Import art from JSON");
            list.add("Art can be saved as an external file and imported into other worlds, or shared online.");
            this.renderTooltip(list, mouseX, mouseY);
        }
        if (this.exportBtn.isHovered()) {
            list = new ArrayList();
            list.add("Export art to JSON");
            list.add("Art can be saved as an external file and imported into other worlds, or shared online.");
            this.renderTooltip(list, mouseX, mouseY);
        }
    }
}

