/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.graffiti.client.gui.submenu;

import com.silvaniastudios.graffiti.client.gui.GuiCanvasEditorBase;
import com.silvaniastudios.graffiti.client.gui.submenu.ImportListMenu;
import com.silvaniastudios.graffiti.drawables.CompleteGraffitiObject;
import com.silvaniastudios.graffiti.drawables.PixelGridDrawable;
import com.silvaniastudios.graffiti.drawables.TextDrawable;
import com.silvaniastudios.graffiti.tileentity.ContainerGraffiti;
import com.silvaniastudios.graffiti.util.FileImport;
import com.silvaniastudios.graffiti.util.ImportedJsonObject;
import java.util.ArrayList;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.opengl.GL11;

public class ImportJsonScreen
extends GuiCanvasEditorBase {
    ImportedJsonObject json;
    Button backBtn;
    Button addDataBtn;
    Button confirmBtn;
    Button clearDataBtn;

    public ImportJsonScreen(ImportedJsonObject json, ContainerGraffiti container, PlayerInventory inv, ITextComponent text) {
        super(container, inv, text);
        this.json = json;
    }

    private void initButtons() {
        int startX = this.width / 2 - this.field_146999_f / 2;
        int startY = this.height / 2 - this.field_147000_g / 2;
        this.backBtn = new Button(startX + 141, startY + 7, 108, 20, "Back", p_214266_1_ -> this.minecraft.func_147108_a((Screen)new ImportListMenu((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title)));
        this.addDataBtn = new Button(startX + 141, startY + 69, 108, 20, "Add To Old Data", p_214266_1_ -> {
            this.addDataBtn.active = false;
            this.clearDataBtn.active = true;
            this.confirmBtn.active = true;
        });
        this.clearDataBtn = new Button(startX + 141, startY + 93, 108, 20, "Clear Old Data", p_214266_1_ -> {
            this.addDataBtn.active = true;
            this.clearDataBtn.active = false;
            this.confirmBtn.active = true;
        });
        this.confirmBtn = new Button(startX + 141, startY + 117, 108, 20, "Confirm Import", p_214266_1_ -> {
            FileImport.sendDataToServer(this.json.getGraffiti(), !this.clearDataBtn.active);
            this.minecraft.func_147108_a((Screen)new ImportListMenu((ContainerGraffiti)this.field_147002_h, this.field_213127_e, this.title));
        });
        this.confirmBtn.active = false;
        if (!((ContainerGraffiti)this.field_147002_h).graffiti.hasPixelGrid() && ((ContainerGraffiti)this.field_147002_h).graffiti.textList.isEmpty()) {
            this.addDataBtn.active = false;
            this.clearDataBtn.active = false;
            this.confirmBtn.active = true;
        }
    }

    @Override
    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        if (this.json.getGraffiti() != null) {
            this.graffiti = this.json.getGraffiti();
        }
        this.initButtons();
        this.addButton((Widget)this.backBtn);
        this.addButton((Widget)this.confirmBtn);
        this.addButton((Widget)this.addDataBtn);
        this.addButton((Widget)this.clearDataBtn);
        super.init();
    }

    @Override
    public void render(int mouseX, int mouseY, float p_render_3_) {
        ArrayList<String> list;
        super.render(mouseX, mouseY, p_render_3_);
        if (this.addDataBtn.isHovered()) {
            list = new ArrayList<String>();
            list.add("Add new data over existing graffiti data");
            this.renderTooltip(list, mouseX, mouseY);
        }
        if (this.clearDataBtn.isHovered()) {
            list = new ArrayList();
            list.add("Delete all current graffiti data.");
            list.add("\u00a7lTHIS CANNOT BE UNDONE.");
            this.renderTooltip(list, mouseX, mouseY);
        }
        if (this.confirmBtn.isHovered() && !this.confirmBtn.active) {
            list = new ArrayList();
            list.add("Please select what to do with existing data before continuing");
            this.renderTooltip(list, mouseX, mouseY);
        }
        if (this.confirmBtn.isHovered() && this.confirmBtn.active && !this.clearDataBtn.active) {
            list = new ArrayList();
            list.add("ALL EXISTING GRAFFITI DATA WILL BE OVERWRITTEN");
            list.add("THIS IS YOUR LAST WARNING! Click to continue");
            this.renderTooltip(list, mouseX, mouseY);
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        this.blit(i, j + 189, 0, 249, this.field_146999_f, 7);
        if (this.json.getGraffiti() != null) {
            this.drawGraffiti(this.json.getGraffiti());
        }
    }

    public void drawGraffiti(CompleteGraffitiObject graffiti) {
        int texture;
        int startX = (this.width - this.field_146999_f) / 2 + 8;
        int startY = (this.height - this.field_147000_g) / 2 + 8;
        int n = texture = graffiti.pixelGrid == null ? 0 : graffiti.pixelGrid.getSize();
        if (graffiti.pixelGrid != null) {
            if (graffiti.pixelGrid.getSize() == 16) {
                texture = 0;
            }
            if (graffiti.pixelGrid.getSize() == 128) {
                texture = 96;
            }
        }
        this.blit(startX, startY, 8 + texture, 8, 32, 128);
        this.blit(startX + 32, startY, 8 + texture, 8, 32, 128);
        this.blit(startX + 64, startY, 8 + texture, 8, 32, 128);
        this.blit(startX + 96, startY, 8 + texture, 8, 32, 128);
        PixelGridDrawable grid = graffiti.pixelGrid;
        if (grid.getSize() > 0) {
            int size = 8;
            if (grid.getSize() == 32) {
                size = 4;
            } else if (grid.getSize() == 64) {
                size = 2;
            } else if (grid.getSize() == 128) {
                size = 1;
            }
            for (int i = 0; i < grid.getSize(); ++i) {
                for (int j = 0; j < grid.getSize(); ++j) {
                    this.fillGradient(startX + j * size, startY + i * size, startX + j * size + size, startY + i * size + size, grid.getPixelRGB(j, i), grid.getPixelRGB(j, i));
                }
            }
        }
        for (int i = 0; i < graffiti.textList.size(); ++i) {
            TextDrawable text = graffiti.textList.get(i);
            GL11.glPushMatrix();
            GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
            this.font.func_211126_b(text.getDrawableText(), (float)((startX + text.xPos() * 2) / 2), (float)((startY + Math.abs(text.yPos() * 2 - 128)) / 2), text.getCol());
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            GL11.glPopMatrix();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b("Imported Art Data", 7.0f, 140.0f, 0x404040);
        this.font.func_211126_b("Name: " + this.json.getName(), 7.0f, 152.0f, 0x404040);
        this.font.func_211126_b("Artist: " + this.json.getArtist(), 7.0f, 164.0f, 0x404040);
        this.font.func_211126_b("Source: " + this.json.getSource() + (this.json.getSource().equalsIgnoreCase("Game") ? " (Version " + this.json.getSourceVersion() + ")" : ""), 7.0f, 176.0f, 0x404040);
        this.font.func_211126_b("Has Grid?: " + this.json.hasGrid() + (this.json.hasGrid() ? " (" + this.graffiti.pixelGrid.getSize() + "x" + this.graffiti.pixelGrid.getSize() + ")" : ""), 7.0f, 188.0f, 0x404040);
        this.font.func_211126_b("Texts: " + this.json.getTextObjectCount(), 7.0f, 200.0f, 0x404040);
    }
}

